/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.exception.UnsupportedException;
import ch.cyberduck.core.features.PromptUrlProvider;
import ch.cyberduck.core.onedrive.GraphExceptionMappingService;
import ch.cyberduck.core.onedrive.OneDriveSession;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import org.apache.log4j.Logger;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.OneDriveItem;
import org.nuxeo.onedrive.client.OneDriveSharingLink;

public class OneDriveSharingLinkUrlProvider
implements PromptUrlProvider {
    private static final Logger log = Logger.getLogger(OneDriveSharingLinkUrlProvider.class);
    private final OneDriveSession session;

    public OneDriveSharingLinkUrlProvider(OneDriveSession session) {
        this.session = session;
    }

    public boolean isSupported(Path file, PromptUrlProvider.Type type) {
        switch (type) {
            case download: {
                return file.isFile();
            }
        }
        return false;
    }

    public DescriptiveUrl toDownloadUrl(Path file, Object o, PasswordCallback callback) throws BackgroundException {
        try {
            OneDriveItem item = this.session.toItem(file);
            if (null == item) {
                throw new NotfoundException(file.getAbsolute());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Create shared link for %s", file));
            }
            return new DescriptiveUrl(URI.create(item.createSharedLink(OneDriveSharingLink.Type.VIEW).getLink().getWebUrl()), DescriptiveUrl.Type.signed, MessageFormat.format(LocaleFactory.localizedString((String)"{0} URL"), LocaleFactory.localizedString((String)"Pre-Signed", (String)"S3")));
        }
        catch (OneDriveAPIException e) {
            throw new GraphExceptionMappingService().map(e);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    public DescriptiveUrl toUploadUrl(Path file, Object o, PasswordCallback callback) throws BackgroundException {
        throw new UnsupportedException();
    }
}

