/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.onedrive.AbstractListService;
import ch.cyberduck.core.onedrive.SharepointSession;
import java.util.EnumSet;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.nuxeo.onedrive.client.GroupsIterator;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.resources.GroupItem;

public class SharepointGroupListService
extends AbstractListService<GroupItem.Metadata> {
    private static final Logger log = Logger.getLogger(SharepointGroupListService.class);
    private final SharepointSession session;

    public SharepointGroupListService(SharepointSession session) {
        this.session = session;
    }

    @Override
    protected Iterator<GroupItem.Metadata> getIterator(Path directory) {
        return new GroupsIterator((OneDriveAPI)this.session.getClient());
    }

    @Override
    protected Path toPath(GroupItem.Metadata metadata, Path directory) {
        PathAttributes attributes = new PathAttributes();
        attributes.setVersionId(metadata.getId());
        return new Path(directory, metadata.getDisplayName(), EnumSet.of(AbstractPath.Type.directory, AbstractPath.Type.volume), attributes);
    }
}

