/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.IdProvider;
import ch.cyberduck.core.onedrive.GraphSession;
import ch.cyberduck.core.onedrive.SharepointContainerService;
import ch.cyberduck.core.onedrive.SharepointListService;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.OneDriveDrive;
import org.nuxeo.onedrive.client.OneDriveFile;
import org.nuxeo.onedrive.client.OneDriveFolder;
import org.nuxeo.onedrive.client.OneDriveItem;
import org.nuxeo.onedrive.client.OneDrivePackageItem;
import org.nuxeo.onedrive.client.OneDriveResource;

public class SharepointSession
extends GraphSession {
    private static final Logger log = Logger.getLogger(SharepointSession.class);

    public SharepointSession(Host host, X509TrustManager trust, X509KeyManager key) {
        super(host, trust, key);
    }

    @Override
    public OneDriveItem toItem(Path file, boolean resolveLastItem) throws BackgroundException {
        String itemId;
        String driveId;
        String versionId = this.fileIdProvider.getFileid(file, (ListProgressListener)new DisabledListProgressListener());
        if (StringUtils.isEmpty((CharSequence)versionId)) {
            throw new NotfoundException(String.format("Version ID for %s is empty", file.getAbsolute()));
        }
        String[] idParts = versionId.split(String.valueOf('/'));
        if (idParts.length == 1) {
            return new OneDriveDrive((OneDriveAPI)this.getClient(), idParts[0]).getRoot();
        }
        if (idParts.length == 2 || !resolveLastItem) {
            driveId = idParts[0];
            itemId = idParts[1];
        } else if (idParts.length == 4) {
            driveId = idParts[2];
            itemId = idParts[3];
        } else {
            throw new NotfoundException(file.getAbsolute());
        }
        OneDriveDrive drive = new OneDriveDrive((OneDriveAPI)this.getClient(), driveId);
        if (file.getType().contains(AbstractPath.Type.file)) {
            return new OneDriveFile((OneDriveAPI)this.getClient(), drive, itemId, OneDriveItem.ItemIdentifierType.Id);
        }
        if (file.getType().contains(AbstractPath.Type.directory)) {
            return new OneDriveFolder((OneDriveAPI)this.getClient(), (OneDriveResource)drive, itemId, OneDriveItem.ItemIdentifierType.Id);
        }
        if (file.getType().contains(AbstractPath.Type.placeholder)) {
            return new OneDrivePackageItem((OneDriveAPI)this.getClient(), (OneDriveResource)drive, itemId, OneDriveItem.ItemIdentifierType.Id);
        }
        throw new NotfoundException(file.getAbsolute());
    }

    @Override
    public boolean isAccessible(Path file, boolean container) {
        if (file.isRoot()) {
            return false;
        }
        if (file.isChild(SharepointListService.DEFAULT_NAME)) {
            if (SharepointListService.DEFAULT_NAME.equals((Object)file)) {
                return false;
            }
            if (!container && SharepointListService.DEFAULT_NAME.equals((Object)file.getParent())) {
                return false;
            }
        } else if (file.isChild(SharepointListService.GROUPS_NAME)) {
            if (SharepointListService.GROUPS_NAME.equals((Object)file) || SharepointListService.GROUPS_NAME.equals((Object)file.getParent())) {
                return false;
            }
            if (!container && SharepointListService.GROUPS_NAME.equals((Object)file.getParent().getParent())) {
                return false;
            }
        } else {
            log.warn((Object)String.format("File %s is neither in %s nor in %s", file, SharepointListService.DEFAULT_NAME, SharepointListService.GROUPS_NAME));
            return false;
        }
        return true;
    }

    @Override
    public Path getContainer(Path file) {
        return new SharepointContainerService().getContainer(file);
    }

    @Override
    public <T> T _getFeature(Class<T> type) {
        if (type == ListService.class) {
            return (T)new SharepointListService(this, (IdProvider)this.getFeature(IdProvider.class));
        }
        return super._getFeature(type);
    }
}

