/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive.features;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.MultipartWrite;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpResponseOutputStream;
import ch.cyberduck.core.io.Buffer;
import ch.cyberduck.core.io.BufferInputStream;
import ch.cyberduck.core.io.BufferOutputStream;
import ch.cyberduck.core.io.FileBuffer;
import ch.cyberduck.core.onedrive.GraphSession;
import ch.cyberduck.core.onedrive.features.GraphTouchFeature;
import ch.cyberduck.core.onedrive.features.GraphWriteFeature;
import ch.cyberduck.core.shared.DefaultAttributesFinderFeature;
import ch.cyberduck.core.shared.DefaultFindFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class GraphBufferWriteFeature
implements MultipartWrite<Void> {
    private static final Logger log = Logger.getLogger(GraphBufferWriteFeature.class);
    private final GraphSession session;
    private final Find finder;
    private final AttributesFinder attributes;

    public GraphBufferWriteFeature(GraphSession session) {
        this(session, (Find)new DefaultFindFeature((Session)session), (AttributesFinder)new DefaultAttributesFinderFeature((Session)session));
    }

    public GraphBufferWriteFeature(GraphSession session, Find finder, AttributesFinder attributes) {
        this.session = session;
        this.finder = finder;
        this.attributes = attributes;
    }

    public HttpResponseOutputStream<Void> write(final Path file, final TransferStatus status, final ConnectionCallback callback) {
        final FileBuffer buffer = new FileBuffer();
        return new HttpResponseOutputStream<Void>((OutputStream)new BufferOutputStream((Buffer)buffer){

            public void flush() {
            }

            public void close() throws IOException {
                try {
                    TransferStatus range = new TransferStatus(status).length(buffer.length().longValue()).append(false);
                    if (0L == buffer.length()) {
                        new GraphTouchFeature(GraphBufferWriteFeature.this.session).touch(file, new TransferStatus());
                    } else {
                        HttpResponseOutputStream<Void> out = new GraphWriteFeature(GraphBufferWriteFeature.this.session).write(file, range, callback);
                        IOUtils.copy((InputStream)new BufferInputStream((Buffer)buffer), out);
                        out.close();
                        log.info((Object)String.format("Completed upload for %s with status %s", file, range));
                    }
                    super.close();
                }
                catch (BackgroundException e) {
                    throw new IOException(e);
                }
            }
        }){

            public Void getStatus() {
                return null;
            }
        };
    }

    public Write.Append append(Path file, Long length, Cache<Path> cache) throws BackgroundException {
        if (this.finder.withCache(cache).find(file)) {
            PathAttributes attr = this.attributes.withCache(cache).find(file);
            return new Write.Append(false, true).withSize(Long.valueOf(attr.getSize())).withChecksum(attr.getChecksum());
        }
        return Write.notfound;
    }

    public boolean temporary() {
        return true;
    }

    public boolean random() {
        return false;
    }
}

