/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive.features;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.onedrive.GraphExceptionMappingService;
import ch.cyberduck.core.onedrive.GraphSession;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.util.Map;
import org.apache.log4j.Logger;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.OneDriveItem;

public class GraphDeleteFeature
implements Delete {
    private static final Logger logger = Logger.getLogger(GraphDeleteFeature.class);
    private final GraphSession session;

    public GraphDeleteFeature(GraphSession session) {
        this.session = session;
    }

    public void delete(Map<Path, TransferStatus> files, PasswordCallback prompt, Delete.Callback callback) throws BackgroundException {
        for (Path file : files.keySet()) {
            callback.delete(file);
            try {
                OneDriveItem item = this.session.toItem(file);
                item.delete();
            }
            catch (NotfoundException e) {
                logger.warn((Object)String.format("Cannot delete %s. Not found.", file));
            }
            catch (OneDriveAPIException e) {
                throw new GraphExceptionMappingService().map("Cannot delete {0}", e, file);
            }
            catch (IOException e) {
                throw new DefaultIOExceptionMappingService().map("Cannot delete {0}", (Throwable)e, file);
            }
        }
    }

    public boolean isSupported(Path file) {
        return this.session.isAccessible(file, false);
    }

    public boolean isRecursive() {
        return true;
    }
}

