/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.importer;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.importer.ThirdpartyBookmarkCollection;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class TotalCommanderBookmarkCollection
extends ThirdpartyBookmarkCollection {
    private static final Logger log = Logger.getLogger(TotalCommanderBookmarkCollection.class);
    private static final long serialVersionUID = -1125641222323961118L;

    @Override
    public String getBundleIdentifier() {
        return "com.ghisler.totalcommander";
    }

    @Override
    public String getName() {
        return "Total Commander";
    }

    @Override
    public Local getFile() {
        return LocalFactory.get((String)PreferencesFactory.get().getProperty("bookmark.import.totalcommander.location"));
    }

    @Override
    protected void parse(ProtocolFactory protocols, Local file) throws AccessDeniedException {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(file.getInputStream(), StandardCharsets.UTF_8));){
            String line;
            Host current = null;
            block21: while ((line = in.readLine()) != null) {
                if (line.startsWith("[")) {
                    if (current != null) {
                        this.add(current);
                    }
                    current = new Host(protocols.forScheme(Scheme.ftp));
                    current.getCredentials().setUsername(PreferencesFactory.get().getProperty("connection.login.anon.name"));
                    Pattern pattern = Pattern.compile("\\[(.*)\\]");
                    Matcher matcher = pattern.matcher(line);
                    if (!matcher.matches()) continue;
                    current.setNickname(matcher.group(1));
                    continue;
                }
                if (null == current) {
                    log.warn((Object)"Failed to detect start of bookmark");
                    continue;
                }
                Scanner scanner = new Scanner(line);
                scanner.useDelimiter("=");
                if (!scanner.hasNext()) {
                    log.warn((Object)("Missing key in line:" + line));
                    continue;
                }
                String name = scanner.next().toLowerCase(Locale.ROOT);
                if (!scanner.hasNext()) {
                    log.warn((Object)("Missing value in line:" + line));
                    continue;
                }
                String value = scanner.next();
                switch (name) {
                    case "host": {
                        current.setHostname(value);
                        continue block21;
                    }
                    case "directory": {
                        current.setDefaultPath(value);
                        continue block21;
                    }
                    case "username": {
                        current.getCredentials().setUsername(value);
                        continue block21;
                    }
                }
                log.warn((Object)String.format("Ignore property %s", name));
            }
            if (current != null) {
                this.add(current);
            }
        }
        catch (IOException e) {
            throw new AccessDeniedException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean add(Host bookmark) {
        if (!StringUtils.equals((CharSequence)bookmark.getHostname(), (CharSequence)PreferencesFactory.get().getProperty("connection.hostname.default"))) {
            return super.add(bookmark);
        }
        return false;
    }
}

