/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.nextcloud;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.URIEncoder;
import ch.cyberduck.core.dav.DAVClient;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.PromptUrlProvider;
import ch.cyberduck.core.http.DefaultHttpResponseExceptionMappingService;
import ch.cyberduck.core.nextcloud.NextcloudSession;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.client.AbstractResponseHandler;

public class NextcloudShareProvider
implements PromptUrlProvider {
    private final NextcloudSession session;

    public NextcloudShareProvider(NextcloudSession session) {
        this.session = session;
    }

    public boolean isSupported(Path file, PromptUrlProvider.Type type) {
        switch (type) {
            case upload: {
                return file.isDirectory();
            }
        }
        return true;
    }

    public DescriptiveUrl toDownloadUrl(Path file, Object options, PasswordCallback callback) throws BackgroundException {
        HttpPost resource = new HttpPost(String.format("https://%s/ocs/v2.php/apps/files_sharing/api/v1/shares?path=%s&shareType=%d", this.session.getHost().getHostname(), URIEncoder.encode((String)StringUtils.substringAfter((String)file.getAbsolute(), (String)this.session.getHost().getDefaultPath())), 3));
        resource.setHeader("OCS-APIRequest", "true");
        resource.setHeader("Accept", "application/xml");
        try {
            return new DescriptiveUrl((URI)((DAVClient)this.session.getClient()).execute((HttpRequestBase)resource, (ResponseHandler)new AbstractResponseHandler<URI>(){

                public URI handleEntity(HttpEntity entity) throws IOException {
                    XmlMapper mapper = new XmlMapper();
                    ocs value = (ocs)mapper.readValue(entity.getContent(), ocs.class);
                    return URI.create(value.data.url);
                }
            }), DescriptiveUrl.Type.http);
        }
        catch (HttpResponseException e) {
            throw new DefaultHttpResponseExceptionMappingService().map(e);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    public DescriptiveUrl toUploadUrl(Path file, Object options, PasswordCallback callback) throws BackgroundException {
        HttpPost resource = new HttpPost(String.format("https://%s/ocs/v2.php/apps/files_sharing/api/v1/shares?path=%s&shareType=%d&publicUpload=true", this.session.getHost().getHostname(), URIEncoder.encode((String)StringUtils.substringAfter((String)file.getAbsolute(), (String)this.session.getHost().getDefaultPath())), 3));
        resource.setHeader("OCS-APIRequest", "true");
        resource.setHeader("Accept", "application/xml");
        try {
            return new DescriptiveUrl((URI)((DAVClient)this.session.getClient()).execute((HttpRequestBase)resource, (ResponseHandler)new AbstractResponseHandler<URI>(){

                public URI handleEntity(HttpEntity entity) throws IOException {
                    XmlMapper mapper = new XmlMapper();
                    ocs value = (ocs)mapper.readValue(entity.getContent(), ocs.class);
                    return URI.create(value.data.url);
                }
            }), DescriptiveUrl.Type.http);
        }
        catch (HttpResponseException e) {
            throw new DefaultHttpResponseExceptionMappingService().map(e);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static final class ocs {
        public data data;

        private ocs() {
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        private static final class data {
            public int id;
            public String url;

            private data() {
            }
        }
    }
}

