/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.s3.S3AttributesFinderFeature;
import ch.cyberduck.core.s3.S3Session;

public class S3FindFeature
implements Find {
    private final S3AttributesFinderFeature attributes;

    public S3FindFeature(S3Session session) {
        this.attributes = new S3AttributesFinderFeature(session);
    }

    public boolean find(Path file) throws BackgroundException {
        if (file.isRoot()) {
            return true;
        }
        try {
            this.attributes.find(file);
            return true;
        }
        catch (NotfoundException e) {
            return false;
        }
        catch (AccessDeniedException e) {
            return true;
        }
    }

    public Find withCache(Cache<Path> cache) {
        this.attributes.withCache(cache);
        return this;
    }
}

