/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.features.Location;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3PathContainerService;
import ch.cyberduck.core.s3.S3Session;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jets3t.service.ServiceException;
import org.jets3t.service.impl.rest.httpclient.RegionEndpointCache;

public class S3LocationFeature
implements Location {
    private static final Logger log = Logger.getLogger(S3LocationFeature.class);
    private final S3Session session;
    private final PathContainerService containerService = new S3PathContainerService();
    private RegionEndpointCache cache = new RegionEndpointCache();

    public S3LocationFeature(S3Session session) {
        this.session = session;
    }

    public S3LocationFeature(S3Session session, RegionEndpointCache cache) {
        this.session = session;
        this.cache = cache;
    }

    public Set<Location.Name> getLocations() {
        if (StringUtils.isNotBlank((CharSequence)this.session.getHost().getRegion())) {
            return Collections.singleton(new S3Region(this.session.getHost().getRegion()));
        }
        if (S3Session.isAwsHostname(this.session.getHost().getHostname())) {
            return this.session.getHost().getProtocol().getRegions();
        }
        return Collections.emptySet();
    }

    public Location.Name getLocation(Path file) throws BackgroundException {
        Path bucket = this.containerService.getContainer(file);
        if (bucket.isRoot()) {
            return unknown;
        }
        return this.getLocation(bucket.getName());
    }

    protected Location.Name getLocation(String bucketname) throws BackgroundException {
        try {
            S3Region region;
            String location;
            if (this.cache.containsRegionForBucketName(bucketname)) {
                return new S3Region(this.cache.getRegionForBucketName(bucketname));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Query location for bucket %s", bucketname));
            }
            if (StringUtils.isBlank((CharSequence)(location = ((RequestEntityRestStorageService)((Object)this.session.getClient())).getBucketLocation(bucketname)))) {
                log.warn((Object)String.format("No region known for bucket %s", bucketname));
                region = new S3Region("us-east-1");
            } else {
                switch (location) {
                    case "US": {
                        region = new S3Region("us-east-1");
                        break;
                    }
                    case "EU": {
                        region = new S3Region("eu-west-1");
                        break;
                    }
                    default: {
                        region = new S3Region(location);
                    }
                }
            }
            this.cache.putRegionForBucketName(bucketname, region.getIdentifier());
            return region;
        }
        catch (ServiceException e) {
            try {
                throw new S3ExceptionMappingService().map("Cannot read bucket location", e);
            }
            catch (AccessDeniedException l) {
                log.warn((Object)String.format("Missing permission to read location for %s %s", bucketname, e.getMessage()));
                return unknown;
            }
            catch (InteroperabilityException i) {
                log.warn((Object)String.format("Not supported to read location for %s %s", bucketname, e.getMessage()));
                return unknown;
            }
        }
    }

    public static final class S3Region
    extends Location.Name {
        public S3Region(String identifier) {
            super(identifier);
        }

        public String toString() {
            String identifier = this.getIdentifier();
            if (null == identifier) {
                return LocaleFactory.localizedString((String)"Unknown");
            }
            return LocaleFactory.localizedString((String)identifier, (String)"S3");
        }
    }
}

