/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.callback;

import ch.cyberduck.binding.DisabledSheetCallback;
import ch.cyberduck.binding.SheetInvoker;
import ch.cyberduck.binding.WindowController;
import ch.cyberduck.binding.application.NSWindow;
import ch.cyberduck.binding.application.SheetCallback;
import ch.cyberduck.binding.foundation.FoundationKitFunctions;
import ch.cyberduck.core.CertificateTrustCallback;
import ch.cyberduck.core.Controller;
import ch.cyberduck.core.KeychainCertificateStore;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.keychain.SFCertificateTrustPanel;
import ch.cyberduck.core.keychain.SecPolicyRef;
import ch.cyberduck.core.keychain.SecTrustRef;
import ch.cyberduck.core.keychain.SecurityFunctions;
import ch.cyberduck.core.threading.DefaultMainAction;
import ch.cyberduck.core.threading.MainAction;
import com.sun.jna.PointerType;
import com.sun.jna.ptr.PointerByReference;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;

public class PromptCertificateTrustCallback
implements CertificateTrustCallback {
    private static final Logger log = Logger.getLogger(PromptCertificateTrustCallback.class);
    private final Controller controller;

    public PromptCertificateTrustCallback(Controller controller) {
        this.controller = controller;
    }

    public void prompt(String hostname, List<X509Certificate> certificates) throws ConnectionCanceledException {
        SecPolicyRef policyRef = SecurityFunctions.library.SecPolicyCreateSSL(false, hostname);
        PointerByReference reference = new PointerByReference();
        SecurityFunctions.library.SecTrustCreateWithCertificates(KeychainCertificateStore.toDEREncodedCertificates(certificates), policyRef, reference);
        SecTrustRef trustRef = new SecTrustRef(reference.getValue());
        final AtomicReference ref = new AtomicReference();
        this.controller.invoke((MainAction)new DefaultMainAction(){

            public void run() {
                ref.set(SFCertificateTrustPanel.sharedCertificateTrustPanel());
            }
        }, true);
        SFCertificateTrustPanel panel = (SFCertificateTrustPanel)ref.get();
        panel.setInformativeText(null);
        panel.setAlternateButtonTitle(LocaleFactory.localizedString((String)"Disconnect"));
        panel.setPolicies(policyRef);
        panel.setShowsHelp(true);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Display trust panel for controller %s", this.controller));
        }
        int option = this.prompt(panel, trustRef);
        FoundationKitFunctions.library.CFRelease((PointerType)trustRef);
        FoundationKitFunctions.library.CFRelease((PointerType)policyRef);
        switch (option) {
            case 1: {
                return;
            }
        }
        throw new ConnectionCanceledException();
    }

    protected int prompt(final SFCertificateTrustPanel panel, final SecTrustRef trustRef) {
        return new SheetInvoker((SheetCallback)new DisabledSheetCallback(), (WindowController)this.controller, (NSWindow)panel){

            protected void beginSheet(NSWindow sheet) {
                panel.beginSheetForWindow_modalDelegate_didEndSelector_contextInfo_trust_message(((WindowController)PromptCertificateTrustCallback.this.controller).window(), this.id(), Foundation.selector((String)"sheetDidClose:returnCode:contextInfo:"), null, trustRef, null);
            }
        }.beginSheet();
    }
}

