/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.callback;

import ch.cyberduck.binding.WindowController;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.LimitedListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.exception.ListCanceledException;
import ch.cyberduck.ui.cocoa.controller.LimitedListAlertController;

public class PromptLimitedListProgressListener
extends LimitedListProgressListener {
    private final WindowController controller;
    private boolean suppressed;

    public PromptLimitedListProgressListener(WindowController controller) {
        super((ProgressListener)controller);
        this.controller = controller;
    }

    public void chunk(Path parent, AttributedList<Path> list) throws ListCanceledException {
        if (this.suppressed) {
            return;
        }
        try {
            super.chunk(parent, list);
        }
        catch (ListCanceledException e) {
            LimitedListAlertController alert = new LimitedListAlertController(e);
            int returncode = alert.beginSheet(this.controller);
            if (alert.isSuppressed()) {
                this.disable();
            }
            switch (returncode) {
                case -1: {
                    throw e;
                }
            }
        }
    }

    protected void disable() {
        super.disable();
        this.suppressed = true;
    }
}

