/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.controller;

import ch.cyberduck.binding.ProxyController;
import ch.cyberduck.core.Archive;
import ch.cyberduck.core.Controller;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Compress;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.core.threading.DefaultMainAction;
import ch.cyberduck.core.threading.MainAction;
import ch.cyberduck.core.threading.RegistryBackgroundAction;
import ch.cyberduck.ui.cocoa.controller.BrowserController;
import ch.cyberduck.ui.cocoa.controller.OverwriteController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ArchiveController
extends ProxyController {
    private final BrowserController parent;

    public ArchiveController(BrowserController parent) {
        this.parent = parent;
    }

    public void archive(final Archive format, final List<Path> selected) {
        new OverwriteController(this.parent).overwrite(Collections.singletonList(format.getArchive(selected)), (MainAction)new DefaultMainAction(){

            public void run() {
                ArchiveController.this.parent.background((BackgroundAction)new RegistryBackgroundAction<Boolean>((Controller)ArchiveController.this.parent, ArchiveController.this.parent.getSession()){

                    public Boolean run(Session<?> session) throws BackgroundException {
                        Compress feature = (Compress)session.getFeature(Compress.class);
                        feature.archive(format, ArchiveController.this.parent.workdir(), selected, (ProgressListener)ArchiveController.this.parent, (TranscriptListener)ArchiveController.this.parent);
                        return true;
                    }

                    public void cleanup() {
                        super.cleanup();
                        ArchiveController.this.parent.reload(ArchiveController.this.parent.workdir(), selected, Collections.singletonList(format.getArchive(selected)));
                    }

                    public String getActivity() {
                        return format.getCompressCommand(ArchiveController.this.parent.workdir(), selected);
                    }
                });
            }
        });
    }

    public void unarchive(final List<Path> selected) {
        final ArrayList expanded = new ArrayList();
        for (final Path s : selected) {
            final Archive archive = Archive.forName((String)s.getName());
            if (null == archive) continue;
            new OverwriteController(this.parent).overwrite(archive.getExpanded(Collections.singletonList(s)), (MainAction)new DefaultMainAction(){

                public void run() {
                    ArchiveController.this.parent.background((BackgroundAction)new RegistryBackgroundAction<Boolean>((Controller)ArchiveController.this.parent, ArchiveController.this.parent.getSession()){

                        public Boolean run(Session<?> session) throws BackgroundException {
                            Compress feature = (Compress)session.getFeature(Compress.class);
                            feature.unarchive(archive, s, (ProgressListener)ArchiveController.this.parent, (TranscriptListener)ArchiveController.this.parent);
                            return true;
                        }

                        public void cleanup() {
                            super.cleanup();
                            expanded.addAll(archive.getExpanded(Collections.singletonList(s)));
                            ArchiveController.this.parent.reload(ArchiveController.this.parent.workdir(), selected, (List<Path>)expanded);
                        }

                        public String getActivity() {
                            return archive.getDecompressCommand(s);
                        }
                    });
                }
            });
        }
    }
}

