/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.controller;

import ch.cyberduck.binding.AlertController;
import ch.cyberduck.binding.application.NSAlert;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.ProviderHelpServiceFactory;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.threading.DefaultFailureDiagnostics;
import ch.cyberduck.core.threading.FailureDiagnostics;

public class BackgroundExceptionAlertController
extends AlertController {
    private final BackgroundException failure;
    private final Host host;
    public final String defaultButton;
    public final String cancelButton;

    public BackgroundExceptionAlertController(BackgroundException failure, Host host) {
        this.failure = failure;
        this.host = host;
        this.defaultButton = LocaleFactory.localizedString((String)"Try Again", (String)"Alert");
        this.cancelButton = LocaleFactory.localizedString((String)"Cancel", (String)"Alert");
    }

    public BackgroundExceptionAlertController(BackgroundException failure, Host host, String defaultButton, String cancelButton) {
        this.failure = failure;
        this.host = host;
        this.defaultButton = defaultButton;
        this.cancelButton = cancelButton;
    }

    public void loadBundle() {
        NSAlert alert = NSAlert.alert();
        alert.setMessageText(null == this.failure.getMessage() ? LocaleFactory.localizedString((String)"Unknown") : this.failure.getMessage());
        alert.setInformativeText(null == this.failure.getDetail() ? LocaleFactory.localizedString((String)"Unknown") : this.failure.getDetail());
        alert.addButtonWithTitle(this.defaultButton);
        alert.addButtonWithTitle(this.cancelButton);
        if (new DefaultFailureDiagnostics().determine(this.failure) == FailureDiagnostics.Type.network) {
            alert.addButtonWithTitle(LocaleFactory.localizedString((String)"Network Diagnostics", (String)"Alert"));
        }
        this.loadBundle(alert);
    }

    protected String help() {
        return ProviderHelpServiceFactory.get().help(this.host.getProtocol());
    }
}

