/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.controller;

import ch.cyberduck.binding.application.NSAlert;
import ch.cyberduck.binding.application.NSImage;
import ch.cyberduck.binding.application.NSView;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.resources.IconCacheFactory;
import ch.cyberduck.ui.cocoa.controller.FileController;
import java.text.MessageFormat;
import org.apache.commons.io.FilenameUtils;

public class CreateSymlinkController
extends FileController {
    private final Path selected;
    private final Callback callback;

    public CreateSymlinkController(Path workdir, Path selected, Cache<Path> cache, Callback callback) {
        super(workdir, selected, cache);
        this.selected = selected;
        this.callback = callback;
    }

    public void loadBundle() {
        NSAlert alert = NSAlert.alert();
        alert.setAlertStyle(1);
        alert.setMessageText(LocaleFactory.localizedString((String)"Create new symbolic link", (String)"File"));
        alert.setInformativeText(MessageFormat.format(LocaleFactory.localizedString((String)"Enter the name for the new symbolic link for {0}", (String)"File"), this.selected.getName()));
        alert.addButtonWithTitle(LocaleFactory.localizedString((String)"Create", (String)"File"));
        alert.addButtonWithTitle(LocaleFactory.localizedString((String)"Cancel", (String)"File"));
        alert.setIcon((NSImage)IconCacheFactory.get().aliasIcon(null, Integer.valueOf(64)));
        super.loadBundle(alert);
    }

    @Override
    public NSView getAccessoryView(NSAlert alert) {
        NSView view = super.getAccessoryView(alert);
        this.updateField(this.inputField, FilenameUtils.getBaseName((String)this.selected.getName()));
        return view;
    }

    @Override
    public void callback(int returncode, Path file) {
        this.callback.callback(this.selected, file);
    }

    public static interface Callback {
        public void callback(Path var1, Path var2);
    }
}

