/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.controller;

import ch.cyberduck.binding.ProxyController;
import ch.cyberduck.binding.application.NSAlert;
import ch.cyberduck.binding.application.SheetCallback;
import ch.cyberduck.core.Controller;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginCallbackFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.core.threading.WorkerBackgroundAction;
import ch.cyberduck.core.worker.DeleteWorker;
import ch.cyberduck.core.worker.Worker;
import ch.cyberduck.ui.cocoa.controller.BrowserController;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class DeleteController
extends ProxyController {
    private final BrowserController parent;

    public DeleteController(BrowserController parent) {
        this.parent = parent;
    }

    public void delete(List<Path> selected) {
        final List normalized = PathNormalizer.normalize(selected);
        if (normalized.isEmpty()) {
            return;
        }
        StringBuilder alertText = new StringBuilder(MessageFormat.format(LocaleFactory.localizedString((String)"Delete {0} files"), selected.size()));
        Iterator iter = normalized.iterator();
        for (int i = 0; i < 10 && iter.hasNext(); ++i) {
            alertText.append('\n').append('\u2022').append(' ').append(((Path)iter.next()).getName());
        }
        if (iter.hasNext()) {
            alertText.append('\n').append('\u2022').append(' ').append('\u2026');
        }
        NSAlert alert = NSAlert.alert((String)LocaleFactory.localizedString((String)"Delete"), (String)alertText.toString(), (String)LocaleFactory.localizedString((String)"Delete"), (String)LocaleFactory.localizedString((String)"Cancel"), null);
        this.parent.alert(alert, new SheetCallback(){

            public void callback(int returncode) {
                if (returncode == 1) {
                    DeleteController.this.run(normalized);
                }
            }
        });
    }

    private void run(final List<Path> files) {
        this.parent.background((BackgroundAction)new WorkerBackgroundAction((Controller)this.parent, this.parent.getSession(), (Worker)new DeleteWorker(LoginCallbackFactory.get((Controller)this.parent), files, this.parent.getCache(), (ProgressListener)this.parent){

            public void cleanup(List<Path> deleted) {
                super.cleanup(deleted);
                DeleteController.this.parent.reload(DeleteController.this.parent.workdir(), files, Collections.emptyList());
            }
        }));
    }
}

