/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.controller;

import ch.cyberduck.binding.AlertController;
import ch.cyberduck.binding.application.NSAlert;
import ch.cyberduck.binding.application.NSResponder;
import ch.cyberduck.binding.application.NSTextField;
import ch.cyberduck.binding.application.NSView;
import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProviderHelpServiceFactory;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.ui.browser.UploadTargetFinder;
import java.util.EnumSet;
import org.apache.commons.lang3.StringUtils;
import org.rococoa.cocoa.foundation.NSRect;

public abstract class FileController
extends AlertController {
    private final Path workdir;
    private final Path selected;
    private final Cache<Path> cache;
    protected NSTextField inputField;

    public FileController(Path workdir, Path selected, Cache<Path> cache) {
        this.workdir = workdir;
        this.selected = selected;
        this.cache = cache;
    }

    public void loadBundle(NSAlert alert) {
        this.inputField = NSTextField.textfieldWithFrame((NSRect)new NSRect(alert.window().frame().size.width.doubleValue(), 22.0));
        this.inputField.cell().setWraps(false);
        this.inputField.cell().setPlaceholderString(alert.informativeText());
        super.loadBundle(alert);
    }

    public NSView getAccessoryView(NSAlert alert) {
        return this.inputField;
    }

    protected void focus(NSAlert alert) {
        super.focus(alert);
        alert.window().makeFirstResponder((NSResponder)this.inputField);
        this.inputField.selectText(null);
    }

    public boolean validate() {
        if (StringUtils.contains((CharSequence)this.inputField.stringValue(), (int)47)) {
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)this.inputField.stringValue())) {
            if (this.cache.get((Referenceable)this.workdir).contains((Referenceable)new Path(this.workdir, this.inputField.stringValue(), EnumSet.of(AbstractPath.Type.file)))) {
                return false;
            }
            return !this.cache.get((Referenceable)this.workdir).contains((Referenceable)new Path(this.workdir, this.inputField.stringValue(), EnumSet.of(AbstractPath.Type.directory)));
        }
        return false;
    }

    public void callback(int returncode) {
        Path directory = new UploadTargetFinder(this.workdir).find(this.selected);
        switch (returncode) {
            case 0: 
            case 1: {
                this.callback(returncode, new Path(directory, this.inputField.stringValue(), EnumSet.of(AbstractPath.Type.file)));
            }
        }
    }

    public abstract void callback(int var1, Path var2);

    protected String help() {
        return ProviderHelpServiceFactory.get().help();
    }
}

