/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.controller;

import ch.cyberduck.binding.AlertController;
import ch.cyberduck.binding.application.NSAlert;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.ProviderHelpServiceFactory;

public class InsecureLoginAlertController
extends AlertController {
    private final String title;
    private final String message;
    private final String continueButton;
    private final String disconnectButton;
    private final Protocol protocol;
    private final boolean enableSuppressionButton;

    public InsecureLoginAlertController(String title, String message, String continueButton, String disconnectButton, Protocol protocol, boolean enableSuppressionButton) {
        this.title = title;
        this.message = message;
        this.continueButton = continueButton;
        this.disconnectButton = disconnectButton;
        this.protocol = protocol;
        this.enableSuppressionButton = enableSuppressionButton;
    }

    public void loadBundle() {
        NSAlert alert = NSAlert.alert();
        alert.setAlertStyle(0);
        alert.setMessageText(this.title);
        alert.setInformativeText(this.message);
        alert.addButtonWithTitle(this.continueButton);
        alert.addButtonWithTitle(this.disconnectButton);
        alert.setShowsHelp(true);
        alert.setShowsSuppressionButton(this.enableSuppressionButton);
        alert.suppressionButton().setTitle(LocaleFactory.localizedString((String)"Don't show again", (String)"Credentials"));
        super.loadBundle(alert);
    }

    protected String help() {
        return ProviderHelpServiceFactory.get().help(this.protocol);
    }
}

