/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.controller;

import ch.cyberduck.binding.AlertController;
import ch.cyberduck.binding.application.NSAlert;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.exception.ListCanceledException;
import java.text.MessageFormat;

public class LimitedListAlertController
extends AlertController {
    private final ListCanceledException e;

    public LimitedListAlertController(ListCanceledException e) {
        this.e = e;
    }

    public void loadBundle() {
        NSAlert alert = NSAlert.alert();
        alert.setAlertStyle(1);
        alert.setMessageText(MessageFormat.format(LocaleFactory.localizedString((String)"Listing directory {0}", (String)"Status"), ""));
        alert.setInformativeText(MessageFormat.format(LocaleFactory.localizedString((String)"Continue listing directory with more than {0} files.", (String)"Alert"), this.e.getChunk().size()));
        alert.addButtonWithTitle(LocaleFactory.localizedString((String)"Continue", (String)"Credentials"));
        alert.addButtonWithTitle(LocaleFactory.localizedString((String)"Cancel"));
        alert.setShowsSuppressionButton(true);
        alert.suppressionButton().setTitle(LocaleFactory.localizedString((String)"Always"));
        super.loadBundle(alert);
    }
}

