/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.controller;

import ch.cyberduck.binding.AlertController;
import ch.cyberduck.binding.BundleController;
import ch.cyberduck.binding.ProxyController;
import ch.cyberduck.binding.SheetController;
import ch.cyberduck.binding.WindowController;
import ch.cyberduck.binding.application.AlertSheetReturnCodeMapper;
import ch.cyberduck.binding.application.NSAlert;
import ch.cyberduck.binding.application.NSApplication;
import ch.cyberduck.binding.application.NSImage;
import ch.cyberduck.binding.application.NSMenu;
import ch.cyberduck.binding.application.NSMenuItem;
import ch.cyberduck.binding.application.NSPasteboard;
import ch.cyberduck.binding.application.NSPopUpButton;
import ch.cyberduck.binding.application.NSView;
import ch.cyberduck.binding.application.NSWindow;
import ch.cyberduck.binding.application.NSWorkspace;
import ch.cyberduck.binding.application.SheetCallback;
import ch.cyberduck.binding.application.WindowListener;
import ch.cyberduck.binding.foundation.NSAppleEventDescriptor;
import ch.cyberduck.binding.foundation.NSAppleEventManager;
import ch.cyberduck.binding.foundation.NSArray;
import ch.cyberduck.binding.foundation.NSAttributedString;
import ch.cyberduck.binding.foundation.NSBundle;
import ch.cyberduck.binding.foundation.NSDictionary;
import ch.cyberduck.binding.foundation.NSNotification;
import ch.cyberduck.binding.foundation.NSNotificationCenter;
import ch.cyberduck.binding.foundation.NSObject;
import ch.cyberduck.core.AbstractHostCollection;
import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.BookmarkCollection;
import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.Controller;
import ch.cyberduck.core.CrashReporter;
import ch.cyberduck.core.CredentialsConfiguratorFactory;
import ch.cyberduck.core.DefaultCharsetProvider;
import ch.cyberduck.core.DefaultPathKindDetector;
import ch.cyberduck.core.HistoryCollection;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostParser;
import ch.cyberduck.core.HostReaderFactory;
import ch.cyberduck.core.HostUrlProvider;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathKindDetector;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.ProfileReaderFactory;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.ProviderHelpServiceFactory;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.SerializerFactory;
import ch.cyberduck.core.TransferCollection;
import ch.cyberduck.core.aquaticprime.DisabledLicenseVerifierCallback;
import ch.cyberduck.core.aquaticprime.License;
import ch.cyberduck.core.aquaticprime.LicenseFactory;
import ch.cyberduck.core.aquaticprime.LicenseVerifierCallback;
import ch.cyberduck.core.bonjour.NotificationRendezvousListener;
import ch.cyberduck.core.bonjour.Rendezvous;
import ch.cyberduck.core.bonjour.RendezvousFactory;
import ch.cyberduck.core.bonjour.RendezvousListener;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.HostParserException;
import ch.cyberduck.core.importer.CloudMounterBookmarkCollection;
import ch.cyberduck.core.importer.CrossFtpBookmarkCollection;
import ch.cyberduck.core.importer.Expandrive3BookmarkCollection;
import ch.cyberduck.core.importer.Expandrive4BookmarkCollection;
import ch.cyberduck.core.importer.Expandrive5BookmarkCollection;
import ch.cyberduck.core.importer.Expandrive6BookmarkCollection;
import ch.cyberduck.core.importer.Expandrive7BookmarkCollection;
import ch.cyberduck.core.importer.FetchBookmarkCollection;
import ch.cyberduck.core.importer.FilezillaBookmarkCollection;
import ch.cyberduck.core.importer.FireFtpBookmarkCollection;
import ch.cyberduck.core.importer.FlowBookmarkCollection;
import ch.cyberduck.core.importer.InterarchyBookmarkCollection;
import ch.cyberduck.core.importer.ThirdpartyBookmarkCollection;
import ch.cyberduck.core.importer.Transmit4BookmarkCollection;
import ch.cyberduck.core.importer.Transmit5BookmarkCollection;
import ch.cyberduck.core.local.Application;
import ch.cyberduck.core.local.BrowserLauncherFactory;
import ch.cyberduck.core.local.DefaultLocalDirectoryFeature;
import ch.cyberduck.core.local.TemporaryFileServiceFactory;
import ch.cyberduck.core.notification.NotificationServiceFactory;
import ch.cyberduck.core.oauth.OAuth2AuthorizationService;
import ch.cyberduck.core.oauth.OAuth2TokenListenerRegistry;
import ch.cyberduck.core.pool.SessionPool;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.preferences.SupportDirectoryFinderFactory;
import ch.cyberduck.core.resources.IconCacheFactory;
import ch.cyberduck.core.serializer.HostDictionary;
import ch.cyberduck.core.threading.AbstractBackgroundAction;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.core.threading.DefaultBackgroundExecutor;
import ch.cyberduck.core.transfer.DownloadTransfer;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferItem;
import ch.cyberduck.core.transfer.TransferOptions;
import ch.cyberduck.core.transfer.UploadTransfer;
import ch.cyberduck.core.updater.PeriodicUpdateChecker;
import ch.cyberduck.core.updater.PeriodicUpdateCheckerFactory;
import ch.cyberduck.core.urlhandler.SchemeHandlerFactory;
import ch.cyberduck.ui.browser.BrowserColumn;
import ch.cyberduck.ui.browser.DownloadDirectoryFinder;
import ch.cyberduck.ui.cocoa.controller.ActivityController;
import ch.cyberduck.ui.cocoa.controller.ActivityControllerFactory;
import ch.cyberduck.ui.cocoa.controller.BrowserController;
import ch.cyberduck.ui.cocoa.controller.DonateAlertController;
import ch.cyberduck.ui.cocoa.controller.DownloadController;
import ch.cyberduck.ui.cocoa.controller.PreferencesController;
import ch.cyberduck.ui.cocoa.controller.PreferencesControllerFactory;
import ch.cyberduck.ui.cocoa.controller.TransferController;
import ch.cyberduck.ui.cocoa.controller.TransferControllerFactory;
import ch.cyberduck.ui.cocoa.delegate.ArchiveMenuDelegate;
import ch.cyberduck.ui.cocoa.delegate.BookmarkMenuDelegate;
import ch.cyberduck.ui.cocoa.delegate.CopyURLMenuDelegate;
import ch.cyberduck.ui.cocoa.delegate.EditMenuDelegate;
import ch.cyberduck.ui.cocoa.delegate.OpenURLMenuDelegate;
import ch.cyberduck.ui.cocoa.delegate.URLMenuDelegate;
import com.google.common.util.concurrent.Uninterruptibles;
import java.net.URI;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.ID;
import org.rococoa.ObjCObject;
import org.rococoa.Rococoa;
import org.rococoa.Selector;
import org.rococoa.cocoa.foundation.NSInteger;
import org.rococoa.cocoa.foundation.NSRect;
import org.rococoa.cocoa.foundation.NSUInteger;

public class MainController
extends BundleController
implements NSApplication.Delegate,
NSMenu.Validation {
    private static final Logger log = Logger.getLogger(MainController.class);
    public static final int kInternetEventClass = 1196773964;
    public static final int kAEGetURL = 1196773964;
    public static final int kAEFetchURL = 1179996748;
    public static final int keyAEResult = 0x2D2D2D2D;
    private final Preferences preferences = PreferencesFactory.get();
    private final PeriodicUpdateChecker updater = PeriodicUpdateCheckerFactory.get((Controller)this);
    private final PathKindDetector detector = new DefaultPathKindDetector();
    private static final List<BrowserController> browsers = new ArrayList<BrowserController>();
    private final AbstractHostCollection sessions = new BookmarkCollection(LocalFactory.get((Local)SupportDirectoryFinderFactory.get().find(), (String)"Sessions"), "session");
    private final NSWorkspace workspace = NSWorkspace.sharedWorkspace();
    private boolean displayDonationPrompt = true;
    private SheetController donationController;
    private NSMenu applicationMenu;
    private NSMenu encodingMenu;
    private NSMenu columnMenu;
    private NSMenu editMenu;
    private EditMenuDelegate editMenuDelegate;
    private NSMenu urlMenu;
    private URLMenuDelegate urlMenuDelegate;
    private NSMenu openUrlMenu;
    private URLMenuDelegate openUrlMenuDelegate;
    private NSMenu archiveMenu;
    private ArchiveMenuDelegate archiveMenuDelegate;
    private NSMenu bookmarkMenu;
    private BookmarkMenuDelegate bookmarkMenuDelegate;
    private final CountDownLatch bookmarksSemaphore = new CountDownLatch(1);

    public static BrowserController newDocument(boolean force, String frame) {
        final List<BrowserController> browsers = MainController.getBrowsers();
        if (!force) {
            for (BrowserController controller : browsers) {
                if (!controller.isIdle()) continue;
                controller.window().makeKeyAndOrderFront(null);
                return controller;
            }
        }
        final BrowserController controller = new BrowserController();
        controller.addListener(new WindowListener(){

            public void windowWillClose() {
                browsers.remove((Object)controller);
            }
        });
        if (StringUtils.isNotBlank((CharSequence)frame)) {
            controller.window().setFrameUsingName(frame);
        }
        controller.window().makeKeyAndOrderFront(null);
        browsers.add(controller);
        return controller;
    }

    public static BrowserController newDocument() {
        return MainController.newDocument(false);
    }

    public static List<BrowserController> getBrowsers() {
        return browsers;
    }

    public BrowserController getBrowser() {
        for (BrowserController browser : browsers) {
            if (!browser.window().isKeyWindow()) continue;
            return browser;
        }
        return null;
    }

    public static BrowserController newDocument(boolean force) {
        return MainController.newDocument(force, null);
    }

    protected String getBundleName() {
        return "Main";
    }

    public void setApplicationMenu(NSMenu menu) {
        this.applicationMenu = menu;
        this.updateLicenseMenu();
        this.updateUpdateMenu();
    }

    protected void updateLicenseMenu() {
        License key = LicenseFactory.find();
        if (key.isReceipt()) {
            this.applicationMenu.removeItemAtIndex(new NSInteger(5L));
            this.applicationMenu.removeItemAtIndex(new NSInteger(4L));
        } else {
            this.applicationMenu.itemAtIndex(new NSInteger(5L)).setAttributedTitle(NSAttributedString.attributedStringWithAttributes((String)key.toString(), (NSDictionary)MENU_HELP_FONT_ATTRIBUTES));
        }
    }

    private void updateUpdateMenu() {
        if (!this.updater.hasUpdatePrivileges()) {
            this.applicationMenu.removeItemAtIndex(new NSInteger(1L));
        }
    }

    public void setEncodingMenu(NSMenu encodingMenu) {
        this.encodingMenu = encodingMenu;
        for (String charset : new DefaultCharsetProvider().availableCharsets()) {
            NSMenuItem item = this.encodingMenu.addItemWithTitle_action_keyEquivalent(charset, Foundation.selector((String)"encodingMenuClicked:"), "");
            item.setRepresentedObject(charset);
        }
    }

    public void setColumnMenu(NSMenu columnMenu) {
        this.columnMenu = columnMenu;
        HashMap<String, String> columns = new HashMap<String, String>();
        columns.put(String.format("browser.column.%s", BrowserColumn.kind.name()), BrowserColumn.kind.toString());
        columns.put(String.format("browser.column.%s", BrowserColumn.extension.name()), BrowserColumn.extension.toString());
        columns.put(String.format("browser.column.%s", BrowserColumn.size.name()), BrowserColumn.size.toString());
        columns.put(String.format("browser.column.%s", BrowserColumn.modified.name()), BrowserColumn.modified.toString());
        columns.put(String.format("browser.column.%s", BrowserColumn.owner.name()), BrowserColumn.owner.toString());
        columns.put(String.format("browser.column.%s", BrowserColumn.group.name()), BrowserColumn.group.toString());
        columns.put(String.format("browser.column.%s", BrowserColumn.permission.name()), BrowserColumn.permission.toString());
        columns.put(String.format("browser.column.%s", BrowserColumn.region.name()), BrowserColumn.region.toString());
        columns.put(String.format("browser.column.%s", BrowserColumn.version.name()), BrowserColumn.version.toString());
        for (Map.Entry entry : columns.entrySet()) {
            NSMenuItem item = this.columnMenu.addItemWithTitle_action_keyEquivalent((String)entry.getValue(), Foundation.selector((String)"columnMenuClicked:"), "");
            String identifier = (String)entry.getKey();
            item.setState(this.preferences.getBoolean(identifier) ? 1 : 0);
            item.setRepresentedObject(identifier);
        }
    }

    public void columnMenuClicked(NSMenuItem sender) {
        String identifier = sender.representedObject();
        boolean enabled = !this.preferences.getBoolean(identifier);
        sender.setState(enabled ? 1 : 0);
        this.preferences.setProperty(identifier, enabled);
        BrowserController.updateBrowserTableColumns();
    }

    public void setEditMenu(NSMenu editMenu) {
        this.editMenu = editMenu;
        this.editMenuDelegate = new EditMenuDelegate(){

            @Override
            protected Path getEditable() {
                List<BrowserController> b = MainController.getBrowsers();
                for (BrowserController controller : b) {
                    if (!controller.window().isKeyWindow()) continue;
                    Path selected = controller.getSelectedPath();
                    if (null == selected) {
                        return null;
                    }
                    if (controller.isEditable(selected)) {
                        return selected;
                    }
                    return null;
                }
                return null;
            }

            @Override
            protected ID getTarget() {
                return MainController.this.getBrowser().id();
            }
        };
        this.editMenu.setDelegate(this.editMenuDelegate.id());
    }

    public void setUrlMenu(NSMenu urlMenu) {
        this.urlMenu = urlMenu;
        this.urlMenuDelegate = new CopyURLMenuDelegate(){

            @Override
            protected SessionPool getSession() {
                List<BrowserController> b = MainController.getBrowsers();
                for (BrowserController controller : b) {
                    if (!controller.window().isKeyWindow() || !controller.isMounted()) continue;
                    return controller.getSession();
                }
                return null;
            }

            @Override
            protected List<Path> getSelected() {
                List<BrowserController> b = MainController.getBrowsers();
                for (BrowserController controller : b) {
                    if (!controller.window().isKeyWindow()) continue;
                    List<Path> selected = controller.getSelectedPaths();
                    if (selected.isEmpty() && controller.isMounted()) {
                        return Collections.singletonList(controller.workdir());
                    }
                    return selected;
                }
                return Collections.emptyList();
            }
        };
        this.urlMenu.setDelegate(this.urlMenuDelegate.id());
    }

    public void setOpenUrlMenu(NSMenu openUrlMenu) {
        this.openUrlMenu = openUrlMenu;
        this.openUrlMenuDelegate = new OpenURLMenuDelegate(){

            @Override
            protected SessionPool getSession() {
                List<BrowserController> b = MainController.getBrowsers();
                for (BrowserController controller : b) {
                    if (!controller.window().isKeyWindow() || !controller.isMounted()) continue;
                    return controller.getSession();
                }
                return null;
            }

            @Override
            protected List<Path> getSelected() {
                List<BrowserController> b = MainController.getBrowsers();
                for (BrowserController controller : b) {
                    if (!controller.window().isKeyWindow()) continue;
                    List<Path> selected = controller.getSelectedPaths();
                    if (selected.isEmpty() && controller.isMounted()) {
                        return Collections.singletonList(controller.workdir());
                    }
                    return selected;
                }
                return Collections.emptyList();
            }
        };
        this.openUrlMenu.setDelegate(this.openUrlMenuDelegate.id());
    }

    public void setArchiveMenu(NSMenu archiveMenu) {
        this.archiveMenu = archiveMenu;
        this.archiveMenuDelegate = new ArchiveMenuDelegate();
        this.archiveMenu.setDelegate(this.archiveMenuDelegate.id());
    }

    public void setBookmarkMenu(NSMenu bookmarkMenu) {
        this.bookmarkMenu = bookmarkMenu;
        this.bookmarkMenuDelegate = new BookmarkMenuDelegate();
        this.bookmarkMenu.setDelegate(this.bookmarkMenuDelegate.id());
    }

    public void bugreportMenuClicked(ID sender) {
        BrowserLauncherFactory.get().open(MessageFormat.format(this.preferences.getProperty("website.bug"), this.preferences.getProperty("application.version")));
    }

    public void helpMenuClicked(ID sender) {
        BrowserLauncherFactory.get().open(ProviderHelpServiceFactory.get().help());
    }

    public void licenseMenuClicked(ID sender) {
        BrowserLauncherFactory.get().open(this.preferences.getProperty("website.license"));
    }

    public void acknowledgmentsMenuClicked(ID sender) {
        BrowserLauncherFactory.get().open(this.preferences.getProperty("website.acknowledgments"));
    }

    public void websiteMenuClicked(ID sender) {
        BrowserLauncherFactory.get().open(this.preferences.getProperty("website.home"));
    }

    public void donateMenuClicked(ID sender) {
        BrowserLauncherFactory.get().open(this.preferences.getProperty("website.donate"));
    }

    public void aboutMenuClicked(ID sender) {
        NSDictionary dict = NSDictionary.dictionaryWithObjectsForKeys((NSArray)NSArray.arrayWithObjects((String[])new String[]{this.preferences.getProperty("application.name"), this.preferences.getProperty("application.version"), this.preferences.getProperty("application.revision")}), (NSArray)NSArray.arrayWithObjects((String[])new String[]{"ApplicationName", "ApplicationVersion", "Version"}));
        NSApplication.sharedApplication().orderFrontStandardAboutPanelWithOptions(dict);
    }

    public void feedbackMenuClicked(ID sender) {
        BrowserLauncherFactory.get().open(this.preferences.getProperty("mail.feedback") + "?subject=" + this.preferences.getProperty("application.name") + "-" + this.preferences.getProperty("application.version"));
    }

    public void preferencesMenuClicked(ID sender) {
        PreferencesController controller = PreferencesControllerFactory.instance();
        controller.window().makeKeyAndOrderFront(null);
    }

    public void newDownloadMenuClicked(ID sender) {
        this.showTransferQueueClicked(sender);
        DownloadController c = new DownloadController();
        c.beginSheet(TransferControllerFactory.get());
    }

    public void newBrowserMenuClicked(ID sender) {
        this.openDefaultBookmark(MainController.newDocument(true));
    }

    public void newWindowForTab(ID sender) {
        this.openDefaultBookmark(MainController.newDocument(true));
    }

    protected void openDefaultBookmark(BrowserController controller) {
        String defaultBookmark = this.preferences.getProperty("browser.open.bookmark.default");
        if (null == defaultBookmark) {
            log.info((Object)"No default bookmark configured");
            return;
        }
        Host bookmark = BookmarkCollection.defaultCollection().lookup(defaultBookmark);
        if (null == bookmark) {
            log.info((Object)"Default bookmark no more available");
            return;
        }
        for (BrowserController browser : MainController.getBrowsers()) {
            if (!bookmark.equals((Object)browser.getSession().getHost())) continue;
            log.debug((Object)"Default bookmark already mounted");
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Mounting default bookmark %s", bookmark));
        }
        controller.mount(bookmark);
    }

    public void showTransferQueueClicked(ID sender) {
        TransferController c = TransferControllerFactory.get();
        c.window().makeKeyAndOrderFront(null);
    }

    public void showActivityWindowClicked(ID sender) {
        ActivityController c = ActivityControllerFactory.get();
        if (c.isVisible()) {
            c.window().orderOut(null);
        } else {
            c.window().orderFront(null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean application_openFile(NSApplication app, String filename) {
        Local f;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Open file %s", filename));
        }
        if (!(f = LocalFactory.get((String)filename)).exists()) return false;
        if ("duck".equals(f.getExtension())) {
            try {
                MainController.newDocument().mount((Host)HostReaderFactory.get().read(f));
                return true;
            }
            catch (AccessDeniedException e) {
                log.error((Object)String.format("Failure reading bookmark from %s. %s", f, e.getMessage()));
                return false;
            }
        }
        if ("cyberducklicense".equals(f.getExtension())) {
            License l = LicenseFactory.get((Local)f);
            if (l.verify((LicenseVerifierCallback)new DisabledLicenseVerifierCallback())) {
                try {
                    f.copy(LocalFactory.get((Local)SupportDirectoryFinderFactory.get().find(), (String)f.getName()));
                    NSAlert alert = NSAlert.alert((String)l.toString(), (String)(LocaleFactory.localizedString((String)"Thanks for your support! Your contribution helps to further advance development to make Cyberduck even better.", (String)"License") + "\n\n" + LocaleFactory.localizedString((String)"Your donation key has been copied to the Application Support folder.", (String)"License")), (String)LocaleFactory.localizedString((String)"Continue", (String)"License"), null, null);
                    alert.setAlertStyle(1);
                    if (new AlertSheetReturnCodeMapper().getOption(alert.runModal()) != 1) return true;
                    for (BrowserController c : MainController.getBrowsers()) {
                        c.removeDonateWindowTitle();
                    }
                    this.updateLicenseMenu();
                    return true;
                }
                catch (AccessDeniedException e) {
                    log.error((Object)e.getMessage());
                    return false;
                }
            } else {
                NSAlert alert = NSAlert.alert((String)LocaleFactory.localizedString((String)"Not a valid registration key", (String)"License"), (String)LocaleFactory.localizedString((String)"This donation key does not appear to be valid.", (String)"License"), (String)LocaleFactory.localizedString((String)"Continue", (String)"License"), null, null);
                alert.setAlertStyle(0);
                alert.setShowsHelp(true);
                alert.setDelegate(new ProxyController(){

                    public boolean alertShowHelp(NSAlert alert) {
                        BrowserLauncherFactory.get().open(ProviderHelpServiceFactory.get().help());
                        return true;
                    }
                }.id());
                alert.runModal();
            }
            return true;
        }
        if ("cyberduckprofile".equals(f.getExtension())) {
            try {
                Protocol profile = (Protocol)ProfileReaderFactory.get().read(f);
                if (!profile.isEnabled()) return false;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Register profile %s", profile));
                }
                ProtocolFactory.get().register(profile);
                Host host = new Host(profile, profile.getDefaultHostname(), profile.getDefaultPort());
                MainController.newDocument().addBookmark(host);
                Local profiles = LocalFactory.get((Local)SupportDirectoryFinderFactory.get().find(), (String)this.preferences.getProperty("profiles.folder.name"));
                if (!profiles.exists()) {
                    new DefaultLocalDirectoryFeature().mkdir(profiles);
                }
                f.copy(LocalFactory.get((Local)profiles, (String)f.getName()));
                return false;
            }
            catch (AccessDeniedException e) {
                log.error((Object)String.format("Failure reading profile from %s. %s", new Object[]{f, e}));
                return false;
            }
        } else {
            this.background((BackgroundAction)new AbstractBackgroundAction<Void>(){

                public Void run() {
                    Uninterruptibles.awaitUninterruptibly((CountDownLatch)MainController.this.bookmarksSemaphore);
                    return null;
                }

                public void cleanup() {
                    MainController.this.upload(f);
                }

                public String getActivity() {
                    return "Open File";
                }
            });
            return true;
        }
    }

    private boolean upload(Local f) {
        return this.upload(Collections.singletonList(f));
    }

    private boolean upload(final List<Local> files) {
        BookmarkCollection bookmarks;
        Host open = null;
        Path workdir = null;
        for (BrowserController browser : MainController.getBrowsers()) {
            if (!browser.isMounted()) continue;
            open = browser.getSession().getHost();
            workdir = browser.workdir();
            if (1 != MainController.getBrowsers().size()) break;
            this.upload(open, files, workdir);
            return true;
        }
        if ((bookmarks = BookmarkCollection.defaultCollection()).isEmpty()) {
            log.warn((Object)"No bookmark for upload");
            return false;
        }
        final NSPopUpButton bookmarksPopup = NSPopUpButton.buttonWithFrame((NSRect)new NSRect(0.0, 26.0));
        bookmarksPopup.setToolTip(LocaleFactory.localizedString((String)"Bookmarks", (String)"Browser"));
        for (Object b : bookmarks) {
            String title = BookmarkNameProvider.toString((Host)b);
            int i = 1;
            while (bookmarksPopup.itemWithTitle(title) != null) {
                title = BookmarkNameProvider.toString((Host)b) + "-" + i;
                ++i;
            }
            bookmarksPopup.addItemWithTitle(title);
            bookmarksPopup.lastItem().setImage((NSImage)IconCacheFactory.get().iconNamed(b.getProtocol().icon(), Integer.valueOf(16)));
            bookmarksPopup.lastItem().setRepresentedObject(b.getUuid());
            if (!b.equals((Object)open)) continue;
            bookmarksPopup.selectItemAtIndex(bookmarksPopup.indexOfItem(bookmarksPopup.lastItem()));
        }
        if (null == open) {
            int i = 0;
            for (Host bookmark : bookmarks) {
                boolean found = false;
                for (Local file : files) {
                    if (!file.isChild(new DownloadDirectoryFinder().find(bookmark))) continue;
                    bookmarksPopup.selectItemAtIndex(new NSInteger((long)i));
                    found = true;
                    break;
                }
                if (found) break;
                ++i;
            }
        }
        if (-1 == bookmarksPopup.indexOfSelectedItem().intValue()) {
            bookmarksPopup.selectItemAtIndex(new NSInteger(0L));
        }
        final Host mount = open;
        final Path destination = workdir;
        final NSAlert alert = NSAlert.alert((String)"Select Bookmark", (String)MessageFormat.format("Upload {0} to the selected bookmark.", files.size() == 1 ? files.iterator().next().getName() : MessageFormat.format(LocaleFactory.localizedString((String)"{0} Items"), String.valueOf(files.size()))), (String)LocaleFactory.localizedString((String)"Upload", (String)"Transfer"), (String)LocaleFactory.localizedString((String)"Cancel"), null);
        alert.setAlertStyle(1);
        AlertController controller = new AlertController(){

            public void loadBundle() {
                this.loadBundle(alert);
            }

            public NSView getAccessoryView(NSAlert alert2) {
                return bookmarksPopup;
            }

            public void callback(int returncode) {
                if (1 == returncode) {
                    String selected = bookmarksPopup.selectedItem().representedObject();
                    Host bookmark = bookmarks.lookup(selected);
                    if (bookmark.equals((Object)mount)) {
                        MainController.this.upload(bookmark, files, destination);
                    } else if (StringUtils.isNotBlank((CharSequence)bookmark.getDefaultPath())) {
                        MainController.this.upload(bookmark, files, new Path(PathNormalizer.normalize((String)bookmark.getDefaultPath()), EnumSet.of(AbstractPath.Type.directory)));
                    } else {
                        MainController.this.upload(bookmark, files, destination);
                    }
                }
            }

            public boolean validate() {
                return StringUtils.isNotEmpty((CharSequence)bookmarksPopup.selectedItem().representedObject());
            }
        };
        controller.beginSheet((WindowController)TransferControllerFactory.get());
        return true;
    }

    private void upload(Host bookmark, List<Local> files, Path destination) {
        ArrayList<TransferItem> roots = new ArrayList<TransferItem>();
        for (Local file : files) {
            roots.add(new TransferItem(new Path(destination, file.getName(), file.isDirectory() ? EnumSet.of(AbstractPath.Type.directory) : EnumSet.of(AbstractPath.Type.file)), file));
        }
        TransferController t = TransferControllerFactory.get();
        t.start((Transfer)new UploadTransfer(bookmark, roots), new TransferOptions());
    }

    public boolean application_openTempFile(NSApplication app, String filename) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("applicationOpenTempFile:" + filename));
        }
        return this.application_openFile(app, filename);
    }

    public boolean applicationShouldOpenUntitledFile(NSApplication sender) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"applicationShouldOpenUntitledFile");
        }
        return this.preferences.getBoolean("browser.open.untitled");
    }

    public boolean applicationOpenUntitledFile(NSApplication app) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"applicationOpenUntitledFile");
        }
        return false;
    }

    public boolean applicationShouldHandleReopen_hasVisibleWindows(NSApplication app, boolean visibleWindowsFound) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Should handle reopen with windows %s", visibleWindowsFound));
        }
        if (MainController.getBrowsers().isEmpty() && !TransferControllerFactory.get().isVisible()) {
            this.openDefaultBookmark(MainController.newDocument());
        }
        NSWindow miniaturized = null;
        for (BrowserController browser : MainController.getBrowsers()) {
            if (!browser.window().isMiniaturized()) {
                return false;
            }
            if (null != miniaturized) continue;
            miniaturized = browser.window();
        }
        if (null == miniaturized) {
            return false;
        }
        miniaturized.deminiaturize(null);
        return false;
    }

    public void applicationDidFinishLaunching(NSNotification notification) {
        WindowController c;
        NSWindow.setAllowsAutomaticWindowTabbing((boolean)true);
        this.loadBundle();
        if (this.preferences.getBoolean("browser.open.untitled")) {
            c = MainController.newDocument();
            c.window().makeKeyAndOrderFront(null);
        }
        if (this.preferences.getBoolean("queue.window.open.default")) {
            c = TransferControllerFactory.get();
            c.window().makeKeyAndOrderFront(null);
        }
        if (this.preferences.getBoolean("browser.serialize")) {
            this.background((BackgroundAction)new AbstractBackgroundAction<Void>(){

                public Void run() throws BackgroundException {
                    MainController.this.sessions.load();
                    return null;
                }

                public void cleanup() {
                    for (Host host : MainController.this.sessions) {
                        if (log.isInfoEnabled()) {
                            log.info((Object)String.format("New browser for saved session %s", host));
                        }
                        BrowserController browser = MainController.newDocument(true, host.getUuid());
                        browser.mount(host);
                    }
                    MainController.this.sessions.clear();
                }
            });
        }
        BookmarkCollection bookmarks = BookmarkCollection.defaultCollection();
        this.background((BackgroundAction)new AbstractBackgroundAction<Void>((AbstractHostCollection)bookmarks){
            final /* synthetic */ AbstractHostCollection val$bookmarks;
            {
                this.val$bookmarks = abstractHostCollection;
            }

            public Void run() throws BackgroundException {
                this.val$bookmarks.load();
                MainController.this.bookmarksSemaphore.countDown();
                return null;
            }

            public void cleanup() {
                if (MainController.this.preferences.getBoolean("browser.open.untitled") && MainController.this.preferences.getProperty("browser.open.bookmark.default") != null) {
                    MainController.this.openDefaultBookmark(MainController.newDocument());
                }
                NSApplication.sharedApplication().setServicesProvider(MainController.this.id());
            }
        });
        this.background((BackgroundAction)new AbstractBackgroundAction<Void>(){

            public Void run() throws BackgroundException {
                HistoryCollection history = HistoryCollection.defaultCollection();
                history.load();
                return null;
            }
        });
        this.background((BackgroundAction)new AbstractBackgroundAction<Void>(){

            public Void run() throws BackgroundException {
                TransferCollection transfers = TransferCollection.defaultCollection();
                transfers.load();
                return null;
            }
        });
        final Rendezvous bonjour = RendezvousFactory.instance();
        bonjour.addListener((RendezvousListener)new NotificationRendezvousListener(bonjour));
        if (this.preferences.getBoolean("defaulthandler.reminder") && this.preferences.getInteger("uses") > 0 && !SchemeHandlerFactory.get().isDefaultHandler(Arrays.asList(Scheme.ftp.name(), Scheme.ftps.name(), Scheme.sftp.name()), new Application(this.preferences.getProperty("application.identifier")))) {
            NSAlert alert = NSAlert.alert((String)LocaleFactory.localizedString((String)"Set Cyberduck as default application for FTP and SFTP locations?", (String)"Configuration"), (String)LocaleFactory.localizedString((String)"As the default application, Cyberduck will open when you click on FTP or SFTP links in other applications, such as your web browser. You can change this setting in the Preferences later.", (String)"Configuration"), (String)LocaleFactory.localizedString((String)"Change", (String)"Configuration"), null, (String)LocaleFactory.localizedString((String)"Cancel", (String)"Configuration"));
            alert.setAlertStyle(1);
            alert.setShowsSuppressionButton(true);
            alert.suppressionButton().setTitle(LocaleFactory.localizedString((String)"Don't ask again", (String)"Configuration"));
            int choice = new AlertSheetReturnCodeMapper().getOption(alert.runModal());
            if (alert.suppressionButton().state() == 1) {
                this.preferences.setProperty("defaulthandler.reminder", false);
            }
            if (choice == 1) {
                SchemeHandlerFactory.get().setDefaultHandler(new Application(this.preferences.getProperty("application.identifier")), Arrays.asList(Scheme.ftp.name(), Scheme.ftps.name(), Scheme.sftp.name()));
            }
        }
        this.workspace.notificationCenter().addObserver(this.id(), Foundation.selector((String)"workspaceWillPowerOff:"), "NSWorkspaceWillPowerOffNotification", null);
        this.workspace.notificationCenter().addObserver(this.id(), Foundation.selector((String)"workspaceWillLogout:"), "NSWorkspaceSessionDidResignActiveNotification", null);
        this.workspace.notificationCenter().addObserver(this.id(), Foundation.selector((String)"workspaceWillSleep:"), "NSWorkspaceWillSleepNotification", null);
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector((String)"applicationWillRestartAfterUpdate:"), "SUUpdaterWillRestartNotificationName", null);
        this.background((BackgroundAction)new AbstractBackgroundAction<Void>(){

            public Void run() {
                bonjour.init();
                return null;
            }
        });
        this.background((BackgroundAction)new ImporterBackgroundAction((AbstractHostCollection)bookmarks, this.bookmarksSemaphore));
        CrashReporter reporter = CrashReporter.create();
        if (log.isInfoEnabled()) {
            log.info((Object)"Check for crash report");
        }
        reporter.checkForCrash(this.preferences.getProperty("website.crash"));
        if (this.updater.hasUpdatePrivileges() && this.preferences.getBoolean("update.check")) {
            long next = this.preferences.getLong("update.check.timestamp") + this.preferences.getLong("update.check.interval") * 1000L;
            if (next < System.currentTimeMillis()) {
                this.updater.check(true);
            }
            this.updater.register();
        }
        String handler = this.preferences.getProperty("oauth.handler.scheme");
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Register OAuth handler %s", handler));
        }
        SchemeHandlerFactory.get().setDefaultHandler(new Application(this.preferences.getProperty("application.identifier")), Collections.singletonList(handler));
        NSAppleEventManager.sharedAppleEventManager().setEventHandler_andSelector_forEventClass_andEventID(this.id(), Foundation.selector((String)"handleGetURLEvent:withReplyEvent:"), 1196773964, 1196773964);
    }

    public void serviceUploadFileUrl_(NSPasteboard pboard, String userData) {
        NSObject o;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("serviceUploadFileUrl_: with user data %s", userData));
        }
        if (pboard.availableTypeFromArray(NSArray.arrayWithObject((String)"NSFilenamesPboardType")) != null && (o = pboard.propertyListForType("NSFilenamesPboardType")) != null && o.isKindOfClass(Rococoa.createClass((String)"NSArray", NSArray._Class.class))) {
            NSArray elements = (NSArray)Rococoa.cast((ObjCObject)o, NSArray.class);
            ArrayList<Local> files = new ArrayList<Local>();
            for (int i = 0; i < elements.count().intValue(); ++i) {
                files.add(LocalFactory.get((String)elements.objectAtIndex(new NSUInteger((long)i)).toString()));
            }
            this.upload(files);
        }
    }

    public NSUInteger applicationShouldTerminate(NSApplication app) {
        NSUInteger result;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Application should quit with notification");
        }
        if (!(result = TransferControllerFactory.applicationShouldTerminate(app)).equals((Object)NSApplication.NSTerminateNow)) {
            return result;
        }
        for (BrowserController browser : MainController.getBrowsers()) {
            if (this.preferences.getBoolean("browser.serialize") && browser.isMounted()) {
                Host serialized = new HostDictionary().deserialize(browser.getSession().getHost().serialize(SerializerFactory.get()));
                serialized.setWorkdir(browser.workdir());
                this.sessions.add((Object)serialized);
                browser.window().saveFrameUsingName(serialized.getUuid());
            }
            if (!browser.isConnected()) continue;
            if (this.preferences.getBoolean("browser.disconnect.confirm")) {
                NSAlert alert = NSAlert.alert((String)LocaleFactory.localizedString((String)"Quit"), (String)LocaleFactory.localizedString((String)"You are connected to at least one remote site. Do you want to review open browsers?"), (String)LocaleFactory.localizedString((String)"Quit Anyway"), (String)LocaleFactory.localizedString((String)"Cancel"), (String)LocaleFactory.localizedString((String)"Review\u2026"));
                alert.setAlertStyle(0);
                alert.setShowsSuppressionButton(true);
                alert.suppressionButton().setTitle(LocaleFactory.localizedString((String)"Don't ask again", (String)"Configuration"));
                int choice = new AlertSheetReturnCodeMapper().getOption(alert.runModal());
                if (alert.suppressionButton().state() == 1) {
                    this.preferences.setProperty("browser.disconnect.confirm", false);
                }
                if (choice == 0) {
                    this.sessions.clear();
                    return NSApplication.NSTerminateCancel;
                }
                if (choice == -1) {
                    if (NSApplication.NSTerminateNow.equals((Object)BrowserController.applicationShouldTerminate(app))) {
                        return this.applicationShouldTerminateAfterDonationPrompt(app);
                    }
                    return NSApplication.NSTerminateLater;
                }
                if (choice != 1) continue;
                return this.applicationShouldTerminateAfterDonationPrompt(app);
            }
            browser.windowShouldClose(browser.window());
        }
        return this.applicationShouldTerminateAfterDonationPrompt(app);
    }

    public NSUInteger applicationShouldTerminateAfterDonationPrompt(NSApplication app) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"applicationShouldTerminateAfterDonationPrompt");
        }
        if (!this.displayDonationPrompt) {
            return NSApplication.NSTerminateNow;
        }
        License key = LicenseFactory.find();
        if (!key.verify((LicenseVerifierCallback)new DisabledLicenseVerifierCallback())) {
            String lastversion = this.preferences.getProperty("donate.reminder");
            if (NSBundle.mainBundle().infoDictionary().objectForKey("CFBundleShortVersionString").toString().equals(lastversion)) {
                return NSApplication.NSTerminateNow;
            }
            Calendar nextreminder = Calendar.getInstance();
            nextreminder.setTimeInMillis(this.preferences.getLong("donate.reminder.date"));
            nextreminder.add(6, this.preferences.getInteger("donate.reminder.interval"));
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Next reminder %s", nextreminder.getTime().toString()));
            }
            if (nextreminder.getTime().after(new Date(System.currentTimeMillis()))) {
                return NSApplication.NSTerminateNow;
            }
            this.displayDonationPrompt = false;
            this.donationController = new DonateAlertController(app);
            this.donationController.setCallback((SheetCallback)this.donationController);
            this.donationController.loadBundle();
            this.donationController.window().center();
            this.donationController.window().makeKeyAndOrderFront(null);
            return NSApplication.NSTerminateLater;
        }
        return NSApplication.NSTerminateNow;
    }

    public void applicationWillTerminate(NSNotification notification) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Application will quit with notification %s", notification));
        }
        this.invalidate();
        OAuth2TokenListenerRegistry.get().shutdown();
        TemporaryFileServiceFactory.get().shutdown();
        RendezvousFactory.instance().quit();
        NotificationServiceFactory.get().unregister();
        this.updater.unregister();
        this.preferences.setProperty("uses", this.preferences.getInteger("uses") + 1);
        this.preferences.save();
        DefaultBackgroundExecutor.get().shutdown();
    }

    public void applicationWillRestartAfterUpdate(ID updater) {
        this.displayDonationPrompt = false;
    }

    public boolean applicationShouldTerminateAfterLastWindowClosed(NSApplication app) {
        return false;
    }

    public void updateMenuClicked(ID sender) {
        this.updater.check(false);
    }

    public void handleGetURLEvent_withReplyEvent(NSAppleEventDescriptor event, NSAppleEventDescriptor reply) {
        log.debug((Object)String.format("Received URL from event %s", event));
        NSAppleEventDescriptor param = event.paramDescriptorForKeyword(0x2D2D2D2D);
        if (null == param) {
            log.error((Object)"No URL parameter");
            return;
        }
        String url = param.stringValue();
        if (StringUtils.isEmpty((CharSequence)url)) {
            log.error((Object)"URL parameter is empty");
            return;
        }
        switch (url) {
            case "x-cyberduck-action:update": {
                this.updater.check(false);
                break;
            }
            default: {
                if (StringUtils.startsWith((CharSequence)url, (CharSequence)OAuth2AuthorizationService.CYBERDUCK_REDIRECT_URI)) {
                    String action = StringUtils.removeStart((String)url, (String)OAuth2AuthorizationService.CYBERDUCK_REDIRECT_URI);
                    List pairs = URLEncodedUtils.parse((URI)URI.create(action), (Charset)Charset.defaultCharset());
                    String state = "";
                    String code = "";
                    for (NameValuePair pair : pairs) {
                        if (StringUtils.equals((CharSequence)pair.getName(), (CharSequence)"state")) {
                            String string = state = StringUtils.equals((CharSequence)pair.getName(), (CharSequence)"state") ? pair.getValue() : "";
                        }
                        if (!StringUtils.equals((CharSequence)pair.getName(), (CharSequence)"code")) continue;
                        code = StringUtils.equals((CharSequence)pair.getName(), (CharSequence)"code") ? pair.getValue() : "";
                    }
                    OAuth2TokenListenerRegistry oauth = OAuth2TokenListenerRegistry.get();
                    oauth.notify(state, code);
                    break;
                }
                try {
                    Host h = HostParser.parse((String)url);
                    h.setCredentials(CredentialsConfiguratorFactory.get((Protocol)h.getProtocol()).configure(h));
                    if (AbstractPath.Type.file == this.detector.detect(h.getDefaultPath())) {
                        Path file = new Path(PathNormalizer.normalize((String)h.getDefaultPath()), EnumSet.of(AbstractPath.Type.file));
                        TransferControllerFactory.get().start((Transfer)new DownloadTransfer(h, file, LocalFactory.get((String)this.preferences.getProperty("queue.download.folder"), (String)file.getName())), new TransferOptions());
                        break;
                    }
                    for (BrowserController browser : MainController.getBrowsers()) {
                        if (!browser.isMounted() || !new HostUrlProvider().get(browser.getSession().getHost()).equals(new HostUrlProvider().get(h))) continue;
                        browser.window().makeKeyAndOrderFront(null);
                        return;
                    }
                    BrowserController browser = MainController.newDocument(false);
                    browser.mount(h);
                    break;
                }
                catch (HostParserException e) {
                    log.warn((Object)e);
                }
            }
        }
    }

    public void workspaceWillPowerOff(NSNotification notification) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Workspace will power off with notification %s", notification));
        }
    }

    public void workspaceWillLogout(NSNotification notification) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Workspace will logout with notification %s", notification));
        }
    }

    public void workspaceWillSleep(NSNotification notification) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Workspace will sleep with notification %s", notification));
        }
    }

    public boolean validateMenuItem(NSMenuItem item) {
        Selector action = item.action();
        if (action.equals((Object)Foundation.selector((String)"updateMenuClicked:"))) {
            if (this.updater.hasUpdatePrivileges()) {
                return !this.updater.isUpdateInProgress((Object)item);
            }
            return false;
        }
        return true;
    }

    private static final class ImporterBackgroundAction
    extends AbstractBackgroundAction<Void> {
        private final Preferences preferences = PreferencesFactory.get();
        private final AbstractHostCollection bookmarks;
        private final List<ThirdpartyBookmarkCollection> collections;
        private final CountDownLatch lock;

        public ImporterBackgroundAction(AbstractHostCollection bookmarks, CountDownLatch lock) {
            this(bookmarks, lock, Arrays.asList(new Transmit5BookmarkCollection(), new Transmit4BookmarkCollection(), new FilezillaBookmarkCollection(), new FetchBookmarkCollection(), new FlowBookmarkCollection(), new InterarchyBookmarkCollection(), new CrossFtpBookmarkCollection(), new FireFtpBookmarkCollection(), new Expandrive3BookmarkCollection(), new Expandrive4BookmarkCollection(), new Expandrive5BookmarkCollection(), new Expandrive6BookmarkCollection(), new Expandrive7BookmarkCollection(), new CloudMounterBookmarkCollection()));
        }

        public ImporterBackgroundAction(AbstractHostCollection bookmarks, CountDownLatch lock, List<ThirdpartyBookmarkCollection> collections) {
            this.bookmarks = bookmarks;
            this.lock = lock;
            this.collections = collections;
        }

        public Void run() {
            for (ThirdpartyBookmarkCollection t : this.collections) {
                if (!t.isInstalled()) {
                    if (!log.isInfoEnabled()) continue;
                    log.info((Object)String.format("No application installed for %s", t.getBundleIdentifier()));
                    continue;
                }
                try {
                    t.load();
                }
                catch (AccessDeniedException e) {
                    log.warn((Object)String.format("Failure %s loading bookmarks from %s", new Object[]{e, t}));
                }
                if (!t.isEmpty()) continue;
                this.preferences.setProperty(t.getConfiguration(), true);
            }
            Uninterruptibles.awaitUninterruptibly((CountDownLatch)this.lock);
            return null;
        }

        public void cleanup() {
            for (ThirdpartyBookmarkCollection t : this.collections) {
                t.filter(this.bookmarks);
                if (t.isEmpty()) {
                    this.preferences.setProperty(t.getConfiguration(), true);
                    continue;
                }
                NSAlert alert = NSAlert.alert((String)MessageFormat.format(LocaleFactory.localizedString((String)"Import {0} Bookmarks", (String)"Configuration"), t.getName()), (String)MessageFormat.format(LocaleFactory.localizedString((String)"{0} bookmarks found. Do you want to add these to your bookmarks?", (String)"Configuration"), t.size()), (String)LocaleFactory.localizedString((String)"Import", (String)"Configuration"), null, (String)LocaleFactory.localizedString((String)"Cancel", (String)"Configuration"));
                alert.setShowsSuppressionButton(true);
                alert.suppressionButton().setTitle(LocaleFactory.localizedString((String)"Don't ask again", (String)"Configuration"));
                alert.setAlertStyle(1);
                int choice = new AlertSheetReturnCodeMapper().getOption(alert.runModal());
                if (alert.suppressionButton().state() == 1) {
                    this.preferences.setProperty(t.getConfiguration(), true);
                }
                if (choice != 1) continue;
                this.bookmarks.addAll((Collection)t);
                this.preferences.setProperty(t.getConfiguration(), true);
            }
        }
    }
}

