/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.controller;

import ch.cyberduck.binding.AlertController;
import ch.cyberduck.binding.application.NSAlert;
import ch.cyberduck.binding.application.NSButton;
import ch.cyberduck.binding.application.NSImage;
import ch.cyberduck.binding.application.NSSecureTextField;
import ch.cyberduck.binding.application.NSView;
import ch.cyberduck.binding.application.NSWindow;
import ch.cyberduck.binding.foundation.NSNotification;
import ch.cyberduck.binding.foundation.NSNotificationCenter;
import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.ProviderHelpServiceFactory;
import ch.cyberduck.core.StringAppender;
import ch.cyberduck.core.resources.IconCacheFactory;
import org.apache.commons.lang3.StringUtils;
import org.rococoa.Foundation;
import org.rococoa.cocoa.foundation.NSPoint;
import org.rococoa.cocoa.foundation.NSRect;

public class PasswordController
extends AlertController {
    private NSView view;
    private NSSecureTextField inputField;
    private NSButton keychainCheckbox;
    private final NSNotificationCenter notificationCenter = NSNotificationCenter.defaultCenter();
    private final Host bookmark;
    private final Credentials credentials;
    private final String title;
    private final String reason;
    private final LoginOptions options;

    public PasswordController(Host bookmark, Credentials credentials, String title, String reason, LoginOptions options) {
        this.bookmark = bookmark;
        this.credentials = credentials;
        this.title = title;
        this.reason = reason;
        this.options = options;
    }

    public void loadBundle() {
        NSAlert alert = NSAlert.alert();
        alert.setAlertStyle(1);
        alert.setIcon((NSImage)IconCacheFactory.get().iconNamed(this.options.icon, Integer.valueOf(64)));
        alert.setMessageText(this.title);
        alert.setInformativeText(new StringAppender().append(this.reason).toString());
        alert.addButtonWithTitle(LocaleFactory.localizedString((String)"Continue", (String)"Credentials"));
        alert.addButtonWithTitle(LocaleFactory.localizedString((String)"Cancel", (String)"Alert"));
        alert.setShowsSuppressionButton(false);
        this.loadBundle(alert);
    }

    public void setWindow(NSWindow window) {
        window.setTitle(BookmarkNameProvider.toString((Host)this.bookmark));
        super.setWindow(window);
    }

    public void keychainCheckboxClicked(NSButton sender) {
        this.credentials.setSaved(sender.state() == 1);
    }

    public void passwordFieldTextDidChange(NSNotification notification) {
        this.credentials.setPassword(this.inputField.stringValue());
    }

    public NSView getAccessoryView(NSAlert alert) {
        this.view = NSView.create((NSRect)new NSRect(alert.window().frame().size.width.doubleValue(), 0.0));
        if (this.options.keychain) {
            this.keychainCheckbox = NSButton.buttonWithFrame((NSRect)new NSRect(alert.window().frame().size.width.doubleValue(), 18.0));
            this.keychainCheckbox.setTitle(LocaleFactory.localizedString((String)"Save Password", (String)"Keychain"));
            this.keychainCheckbox.setAction(Foundation.selector((String)"keychainCheckboxClicked:"));
            this.keychainCheckbox.setTarget(this.id());
            this.keychainCheckbox.setButtonType(3);
            this.keychainCheckbox.setState(this.credentials.isSaved() ? 1 : 0);
            this.keychainCheckbox.sizeToFit();
            this.keychainCheckbox.setFrameOrigin(new NSPoint(0.0, this.getFrame((NSAlert)alert, (NSView)this.view).size.height.doubleValue()));
            this.view.addSubview((NSView)this.keychainCheckbox);
        }
        this.inputField = NSSecureTextField.textfieldWithFrame((NSRect)new NSRect(alert.window().frame().size.width.doubleValue(), 22.0));
        this.inputField.cell().setPlaceholderString(this.options.getPasswordPlaceholder());
        this.inputField.setFrameOrigin(new NSPoint(0.0, this.getFrame((NSAlert)alert, (NSView)this.view).size.height.doubleValue() + this.view.subviews().count().doubleValue() * 4.0));
        this.view.addSubview((NSView)this.inputField);
        return this.view;
    }

    public void setPasswordFieldText(String input) {
        this.inputField.setStringValue(input);
    }

    protected void focus(NSAlert alert) {
        super.focus(alert);
        this.inputField.selectText(null);
        this.notificationCenter.addObserver(this.id(), Foundation.selector((String)"passwordFieldTextDidChange:"), "NSControlTextDidChangeNotification", this.inputField.id());
    }

    public boolean validate() {
        return StringUtils.isNotBlank((CharSequence)this.inputField.stringValue());
    }

    protected String help() {
        return ProviderHelpServiceFactory.get().help(this.bookmark.getProtocol());
    }
}

