/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.controller;

import ch.cyberduck.binding.BundleController;
import ch.cyberduck.binding.application.NSColor;
import ch.cyberduck.binding.application.NSFont;
import ch.cyberduck.binding.application.NSImage;
import ch.cyberduck.binding.application.NSImageView;
import ch.cyberduck.binding.application.NSMenuItem;
import ch.cyberduck.binding.application.NSPopUpButton;
import ch.cyberduck.binding.application.NSProgressIndicator;
import ch.cyberduck.binding.application.NSTextField;
import ch.cyberduck.binding.application.NSView;
import ch.cyberduck.binding.foundation.NSArray;
import ch.cyberduck.binding.foundation.NSAttributedString;
import ch.cyberduck.binding.foundation.NSDictionary;
import ch.cyberduck.binding.foundation.NSNotification;
import ch.cyberduck.binding.foundation.NSNotificationCenter;
import ch.cyberduck.binding.foundation.NSObject;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.UserDateFormatterFactory;
import ch.cyberduck.core.formatter.SizeFormatter;
import ch.cyberduck.core.formatter.SizeFormatterFactory;
import ch.cyberduck.core.resources.IconCacheFactory;
import ch.cyberduck.core.threading.DefaultMainAction;
import ch.cyberduck.core.threading.MainAction;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferItem;
import ch.cyberduck.core.transfer.TransferListener;
import ch.cyberduck.core.transfer.TransferProgress;
import ch.cyberduck.ui.cocoa.delegate.AbstractMenuDelegate;
import ch.cyberduck.ui.cocoa.delegate.TransferMenuDelegate;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.rococoa.Foundation;
import org.rococoa.cocoa.foundation.NSInteger;

public class ProgressController
extends BundleController
implements TransferListener,
ProgressListener {
    private static final NSDictionary NORMAL_FONT_ATTRIBUTES = NSDictionary.dictionaryWithObjectsForKeys((NSArray)NSArray.arrayWithObjects((NSObject[])new NSObject[]{NSFont.systemFontOfSize((double)NSFont.smallSystemFontSize()), NSColor.controlTextColor(), BundleController.PARAGRAPH_STYLE_LEFT_ALIGNMENT_TRUNCATE_TAIL}), (NSArray)NSArray.arrayWithObjects((String[])new String[]{"NSFont", "NSColor", "NSParagraphStyle"}));
    private static final NSDictionary HIGHLIGHTED_FONT_ATTRIBUTES = NSDictionary.dictionaryWithObjectsForKeys((NSArray)NSArray.arrayWithObjects((NSObject[])new NSObject[]{NSFont.systemFontOfSize((double)NSFont.smallSystemFontSize()), NSColor.alternateSelectedControlTextColor(), BundleController.PARAGRAPH_STYLE_LEFT_ALIGNMENT_TRUNCATE_TAIL}), (NSArray)NSArray.arrayWithObjects((String[])new String[]{"NSFont", "NSColor", "NSParagraphStyle"}));
    private static final NSImage RED_ICON = (NSImage)IconCacheFactory.get().iconNamed("NSStatusUnavailable");
    private static final NSImage GREEN_ICON = (NSImage)IconCacheFactory.get().iconNamed("NSStatusAvailable");
    private static final NSImage YELLOW_ICON = (NSImage)IconCacheFactory.get().iconNamed("NSStatusPartiallyAvailable");
    private final NSNotificationCenter notificationCenter = NSNotificationCenter.defaultCenter();
    private final Transfer transfer;
    private final SizeFormatter sizeFormatter = SizeFormatterFactory.get();
    private boolean highlighted;
    private NSPopUpButton filesPopup;
    private AbstractMenuDelegate filesPopupMenuDelegate;
    private NSTextField progressField;
    private NSTextField statusField;
    private NSTextField messageField;
    private NSProgressIndicator progressBar;
    private NSImageView statusIconView;
    private NSImageView iconImageView;
    private NSView progressView;

    public ProgressController(Transfer transfer) {
        this.transfer = transfer;
    }

    public void awakeFromNib() {
        this.setProgress(MessageFormat.format(LocaleFactory.localizedString((String)"{0} of {1}"), this.sizeFormatter.format(this.transfer.getTransferred().longValue()), this.sizeFormatter.format(this.transfer.getSize().longValue())));
        this.setMessage("");
        this.setStatus(LocaleFactory.localizedString((String)(this.transfer.isComplete() ? String.format("%s complete", StringUtils.capitalize((String)this.transfer.getType().name())) : "Transfer incomplete"), (String)"Status"));
        super.awakeFromNib();
    }

    protected String getBundleName() {
        return "Progress.nib";
    }

    public void message(final String message) {
        this.invoke((MainAction)new DefaultMainAction(){

            public void run() {
                ProgressController.this.setMessage(message);
            }
        });
    }

    public void transferDidStart(Transfer transfer) {
        this.invoke((MainAction)new DefaultMainAction(){

            public void run() {
                ProgressController.this.progressBar.setHidden(false);
                ProgressController.this.progressBar.setIndeterminate(true);
                ProgressController.this.progressBar.startAnimation(null);
                ProgressController.this.statusIconView.setImage(YELLOW_ICON);
                ProgressController.this.setProgress("");
                ProgressController.this.setStatus("");
            }
        });
    }

    public void transferDidStop(final Transfer transfer) {
        this.invoke((MainAction)new DefaultMainAction(){

            public void run() {
                ProgressController.this.progressBar.stopAnimation(null);
                ProgressController.this.progressBar.setIndeterminate(true);
                ProgressController.this.progressBar.setHidden(true);
                ProgressController.this.setMessage("");
                ProgressController.this.setProgress(MessageFormat.format(LocaleFactory.localizedString((String)"{0} of {1}"), ProgressController.this.sizeFormatter.format(transfer.getTransferred().longValue()), ProgressController.this.sizeFormatter.format(transfer.getSize().longValue())));
                ProgressController.this.setStatus(LocaleFactory.localizedString((String)LocaleFactory.localizedString((String)(transfer.isComplete() ? String.format("%s complete", StringUtils.capitalize((String)transfer.getType().name())) : "Transfer incomplete"), (String)"Status"), (String)"Status"));
                ProgressController.this.statusIconView.setImage(transfer.isComplete() ? GREEN_ICON : RED_ICON);
            }
        });
    }

    public void transferDidProgress(Transfer transfer, TransferProgress progress) {
        this.setProgress(progress.getProgress());
        final double transferred = progress.getTransferred().longValue();
        final double size = progress.getSize().longValue();
        this.invoke((MainAction)new DefaultMainAction(){

            public void run() {
                if (transferred > 0.0 && size > 0.0) {
                    ProgressController.this.progressBar.setIndeterminate(false);
                    ProgressController.this.progressBar.setMaxValue(size);
                    ProgressController.this.progressBar.setDoubleValue(transferred);
                } else {
                    ProgressController.this.progressBar.setIndeterminate(true);
                }
            }
        });
    }

    private void setProgress(final String message) {
        this.invoke((MainAction)new DefaultMainAction(){

            public void run() {
                ProgressController.this.progressField.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes((String)message, (NSDictionary)BundleController.TRUNCATE_MIDDLE_ATTRIBUTES));
            }
        });
    }

    public void setMessage(String message) {
        Date timestamp;
        String text = StringUtils.isBlank((CharSequence)message) ? (null != (timestamp = this.transfer.getTimestamp()) ? UserDateFormatterFactory.get().getLongFormat(timestamp.getTime(), false) : "") : message;
        this.messageField.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes((String)text, (NSDictionary)TRUNCATE_MIDDLE_ATTRIBUTES));
    }

    private void setStatus(String status) {
        this.statusField.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes((String)status, (NSDictionary)TRUNCATE_MIDDLE_ATTRIBUTES));
    }

    public boolean isHighlighted() {
        return this.highlighted;
    }

    public void setHighlighted(boolean h) {
        this.highlighted = h;
        this.statusField.setTextColor(h ? NSColor.alternateSelectedControlTextColor() : NSColor.controlTextColor());
        this.progressField.setTextColor(h ? NSColor.alternateSelectedControlTextColor() : NSColor.controlTextColor());
        this.messageField.setTextColor(h ? NSColor.alternateSelectedControlTextColor() : NSColor.controlTextColor());
        this.setMenuHighlighted(h);
    }

    private void setMenuHighlighted(boolean highlighted) {
        for (int i = 0; i < this.filesPopup.numberOfItems().intValue(); ++i) {
            NSMenuItem item = this.filesPopup.itemAtIndex(new NSInteger((long)i));
            item.setAttributedTitle(NSAttributedString.attributedStringWithAttributes((String)item.title(), (NSDictionary)(highlighted ? HIGHLIGHTED_FONT_ATTRIBUTES : NORMAL_FONT_ATTRIBUTES)));
        }
    }

    public void setFilesPopup(NSPopUpButton p) {
        this.filesPopup = p;
        this.filesPopup.setTarget(this.id());
        this.filesPopup.removeAllItems();
        List items = this.transfer.getRoots();
        for (int i = 0; i < items.size(); ++i) {
            TransferItem entry = (TransferItem)items.get(i);
            this.filesPopup.addItemWithTitle(i == 0 && items.size() > 1 ? String.format("%s (%d more)", entry.remote.getName(), items.size() - 1) : entry.remote.getName());
        }
        this.filesPopupMenuDelegate = new TransferMenuDelegate(this.transfer);
        this.filesPopup.menu().setDelegate(this.filesPopupMenuDelegate.id());
        this.notificationCenter.addObserver(this.id(), Foundation.selector((String)"filesPopupWillShow:"), "NSPopUpButtonWillPopUpNotification", this.filesPopup.id());
        this.notificationCenter.addObserver(this.id(), Foundation.selector((String)"filesPopupWillHide:"), "NSMenuDidEndTrackingNotification", this.filesPopup.menu().id());
    }

    public void filesPopupWillShow(NSNotification sender) {
        this.setMenuHighlighted(false);
    }

    public void filesPopupWillHide(NSNotification sender) {
        this.setMenuHighlighted(this.highlighted);
    }

    public void setProgressField(NSTextField f) {
        this.progressField = f;
        this.progressField.setEditable(false);
        this.progressField.setSelectable(false);
        this.progressField.setTextColor(NSColor.controlTextColor());
        this.progressField.setFont(NSFont.monospacedDigitSystemFontOfSize((double)NSFont.smallSystemFontSize()));
    }

    public void setStatusField(NSTextField f) {
        this.statusField = f;
        this.statusField.setEditable(false);
        this.statusField.setSelectable(false);
        this.statusField.setTextColor(NSColor.controlTextColor());
    }

    public void setMessageField(NSTextField f) {
        this.messageField = f;
        this.messageField.setEditable(false);
        this.messageField.setSelectable(false);
        this.messageField.setTextColor(NSColor.controlTextColor());
    }

    public void setProgressBar(NSProgressIndicator p) {
        this.progressBar = p;
        this.progressBar.setDisplayedWhenStopped(false);
        this.progressBar.setUsesThreadedAnimation(true);
        this.progressBar.setControlSize(1);
        this.progressBar.setStyle(0);
        this.progressBar.setMinValue(0.0);
    }

    public void setStatusIconView(NSImageView statusIconView) {
        this.statusIconView = statusIconView;
        this.statusIconView.setImage(this.transfer.isComplete() ? GREEN_ICON : RED_ICON);
    }

    public void setIconImageView(NSImageView iconImageView) {
        this.iconImageView = iconImageView;
        this.iconImageView.setImage((NSImage)IconCacheFactory.get().iconNamed(String.format("transfer-%s.tiff", this.transfer.getType().name()), Integer.valueOf(32)));
    }

    public void setProgressView(NSView v) {
        this.progressView = v;
    }

    public NSView view() {
        return this.progressView;
    }
}

