/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.controller;

import ch.cyberduck.binding.BundleController;
import ch.cyberduck.binding.application.NSColor;
import ch.cyberduck.binding.application.NSFont;
import ch.cyberduck.binding.application.NSTextView;
import ch.cyberduck.binding.application.NSView;
import ch.cyberduck.binding.foundation.NSArray;
import ch.cyberduck.binding.foundation.NSAttributedString;
import ch.cyberduck.binding.foundation.NSDictionary;
import ch.cyberduck.binding.foundation.NSObject;
import ch.cyberduck.binding.foundation.NSRange;
import ch.cyberduck.core.Controller;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.threading.ControllerMainAction;
import ch.cyberduck.core.threading.MainAction;
import org.rococoa.cocoa.foundation.NSUInteger;

public abstract class TranscriptController
extends BundleController
implements TranscriptListener {
    public static final NSDictionary FIXED_WITH_FONT_RESPONSE_ATTRIBUTES = NSDictionary.dictionaryWithObjectsForKeys((NSArray)NSArray.arrayWithObjects((NSObject[])new NSObject[]{NSFont.userFixedPitchFontOfSize((double)9.0), NSColor.disabledControlTextColor()}), (NSArray)NSArray.arrayWithObjects((String[])new String[]{"NSFont", "NSColor"}));
    protected static final NSDictionary FIXED_WITH_FONT_REQUEST_ATTRIBUTES = NSDictionary.dictionaryWithObjectsForKeys((NSArray)NSArray.arrayWithObjects((NSObject[])new NSObject[]{NSFont.userFixedPitchFontOfSize((double)9.0), NSColor.controlTextColor()}), (NSArray)NSArray.arrayWithObjects((String[])new String[]{"NSFont", "NSColor"}));
    private NSView logView;
    private NSTextView logTextView;

    public TranscriptController() {
        this.loadBundle();
    }

    public NSView getLogView() {
        return this.logView;
    }

    public void setLogView(NSView logView) {
        this.logView = logView;
    }

    public void setLogTextView(NSTextView logTextView) {
        this.logTextView = logTextView;
    }

    protected String getBundleName() {
        return "Transcript";
    }

    public abstract boolean isOpen();

    public void log(final TranscriptListener.Type request, final String transcript) {
        if (this.isOpen()) {
            this.invoke((MainAction)new ControllerMainAction((Controller)this){

                public void run() {
                    switch (request) {
                        case request: {
                            TranscriptController.this.write(FIXED_WITH_FONT_REQUEST_ATTRIBUTES, transcript);
                            break;
                        }
                        case response: {
                            TranscriptController.this.write(FIXED_WITH_FONT_RESPONSE_ATTRIBUTES, transcript);
                        }
                    }
                }
            });
        }
    }

    private void write(NSDictionary font, String transcript) {
        this.logTextView.textStorage().appendAttributedString(NSAttributedString.attributedStringWithAttributes((String)(transcript + "\n"), (NSDictionary)font));
        this.logTextView.scrollRangeToVisible(NSRange.NSMakeRange((NSUInteger)this.logTextView.textStorage().length(), (NSUInteger)new NSUInteger(0L)));
    }

    public void clear() {
        this.logTextView.setString("");
    }
}

