/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.controller;

import ch.cyberduck.binding.application.NSAlert;
import ch.cyberduck.binding.application.NSApplication;
import ch.cyberduck.binding.application.SheetCallback;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.TransferCollection;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.core.threading.BackgroundActionRegistry;
import ch.cyberduck.ui.cocoa.controller.TransferController;
import org.rococoa.cocoa.foundation.NSUInteger;

public final class TransferControllerFactory {
    private static TransferController shared = null;

    private TransferControllerFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TransferController get() {
        NSApplication nSApplication = NSApplication.sharedApplication();
        synchronized (nSApplication) {
            if (null == shared) {
                shared = new TransferController();
                shared.loadBundle();
            }
            return shared;
        }
    }

    public static NSUInteger applicationShouldTerminate(final NSApplication app) {
        if (null == shared) {
            return NSApplication.NSTerminateNow;
        }
        PreferencesFactory.get().setProperty("queue.window.open.default", shared.isVisible());
        if (TransferCollection.defaultCollection().numberOfRunningTransfers() > 0) {
            NSAlert alert = NSAlert.alert((String)LocaleFactory.localizedString((String)"Transfer in progress"), (String)LocaleFactory.localizedString((String)"There are files currently being transferred. Quit anyway?"), (String)LocaleFactory.localizedString((String)"Quit"), (String)LocaleFactory.localizedString((String)"Cancel"), null);
            shared.alert(alert, new SheetCallback(){

                public void callback(int returncode) {
                    if (returncode == 1) {
                        BackgroundActionRegistry registry = shared.getRegistry();
                        for (BackgroundAction action : (BackgroundAction[])registry.toArray((Object[])new BackgroundAction[registry.size()])) {
                            action.cancel();
                        }
                        app.replyToApplicationShouldTerminate(true);
                    }
                    if (returncode == -1) {
                        app.replyToApplicationShouldTerminate(false);
                    }
                }
            });
            return NSApplication.NSTerminateLater;
        }
        return NSApplication.NSTerminateNow;
    }
}

