/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.datasource;

import ch.cyberduck.binding.ProxyController;
import ch.cyberduck.binding.application.NSApplication;
import ch.cyberduck.binding.application.NSDraggingInfo;
import ch.cyberduck.binding.application.NSDraggingSource;
import ch.cyberduck.binding.application.NSEvent;
import ch.cyberduck.binding.application.NSImage;
import ch.cyberduck.binding.application.NSPasteboard;
import ch.cyberduck.binding.application.NSTableView;
import ch.cyberduck.binding.foundation.NSArray;
import ch.cyberduck.binding.foundation.NSAttributedString;
import ch.cyberduck.binding.foundation.NSDictionary;
import ch.cyberduck.binding.foundation.NSMutableArray;
import ch.cyberduck.binding.foundation.NSObject;
import ch.cyberduck.binding.foundation.NSURL;
import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Acl;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostParser;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.UserDateFormatterFactory;
import ch.cyberduck.core.cache.LRUCache;
import ch.cyberduck.core.date.AbstractUserDateFormatter;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.HostParserException;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.formatter.SizeFormatter;
import ch.cyberduck.core.formatter.SizeFormatterFactory;
import ch.cyberduck.core.local.DefaultLocalDirectoryFeature;
import ch.cyberduck.core.local.FileDescriptor;
import ch.cyberduck.core.local.FileDescriptorFactory;
import ch.cyberduck.core.local.IconServiceFactory;
import ch.cyberduck.core.local.LocalTouchFactory;
import ch.cyberduck.core.pasteboard.PathPasteboard;
import ch.cyberduck.core.pasteboard.PathPasteboardFactory;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.preferences.TemporarySupportDirectoryFinder;
import ch.cyberduck.core.resources.IconCache;
import ch.cyberduck.core.resources.IconCacheFactory;
import ch.cyberduck.core.transfer.CopyTransfer;
import ch.cyberduck.core.transfer.DownloadTransfer;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferItem;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.transfer.UploadTransfer;
import ch.cyberduck.core.transfer.download.DownloadFilterOptions;
import ch.cyberduck.ui.browser.BrowserColumn;
import ch.cyberduck.ui.cocoa.controller.BrowserController;
import ch.cyberduck.ui.cocoa.controller.CopyController;
import ch.cyberduck.ui.cocoa.controller.DeleteController;
import ch.cyberduck.ui.cocoa.controller.MoveController;
import ch.cyberduck.ui.cocoa.datasource.TableCellAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.rococoa.ObjCObject;
import org.rococoa.Rococoa;
import org.rococoa.cocoa.foundation.NSInteger;
import org.rococoa.cocoa.foundation.NSPoint;
import org.rococoa.cocoa.foundation.NSRect;
import org.rococoa.cocoa.foundation.NSSize;
import org.rococoa.cocoa.foundation.NSUInteger;

public abstract class BrowserTableDataSource
extends ProxyController
implements NSDraggingSource {
    private static final Logger log = Logger.getLogger(BrowserTableDataSource.class);
    private final SizeFormatter sizeFormatter = SizeFormatterFactory.get();
    private final AbstractUserDateFormatter dateFormatter = UserDateFormatterFactory.get();
    private final IconCache<NSImage> icons = IconCacheFactory.get();
    private final FileDescriptor descriptor = FileDescriptorFactory.get();
    private final Preferences preferences = PreferencesFactory.get();
    private final LRUCache<Item, NSAttributedString> attributed = LRUCache.build((long)this.preferences.getInteger("browser.model.cache.size"));
    private final LRUCache<Path, AttributedList<Path>> filtered = LRUCache.build((long)this.preferences.getInteger("browser.model.cache.size"));
    protected final BrowserController controller;
    protected final Cache<Path> cache;

    protected BrowserTableDataSource(BrowserController controller, Cache<Path> cache) {
        this.controller = controller;
        this.cache = cache;
    }

    public void invalidate() {
        this.attributed.clear();
        this.filtered.clear();
        super.invalidate();
    }

    public void render(NSTableView view, List<Path> folders) {
        this.attributed.clear();
        for (Path folder : folders) {
            this.filtered.remove((Object)folder);
        }
    }

    public AttributedList<Path> get(Path directory) {
        if (!this.filtered.contains((Object)directory)) {
            this.filtered.put((Object)directory, (Object)this.cache.get((Referenceable)directory).filter(this.controller.getComparator(), this.controller.getFilter()));
        }
        return (AttributedList)this.filtered.get((Object)directory);
    }

    public int indexOf(NSTableView view, Path file) {
        return this.get(this.controller.workdir()).indexOf((Referenceable)file);
    }

    protected void setObjectValueForItem(Path item, NSObject value, String identifier) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Set new value %s for item %s", value, item));
        }
        if (identifier.equals(BrowserColumn.filename.name()) && StringUtils.isNotBlank((CharSequence)value.toString()) && !item.getName().equals(value.toString())) {
            Path renamed = new Path(item.getParent(), value.toString(), item.getType(), item.attributes());
            new MoveController(this.controller).rename(item, renamed);
        }
    }

    public NSImage iconForPath(Path item) {
        if (item.isVolume()) {
            return (NSImage)this.icons.volumeIcon(this.controller.getSession().getHost().getProtocol(), Integer.valueOf(16));
        }
        return (NSImage)this.icons.fileIcon(item, Integer.valueOf(16));
    }

    protected NSObject objectValueForItem(Path item, String identifier) {
        if (null == item) {
            return null;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("objectValueForItem:" + item.getAbsolute()));
        }
        if (identifier.equals(BrowserColumn.icon.name())) {
            return this.iconForPath(item);
        }
        Item key = new Item(item, identifier);
        NSAttributedString value = (NSAttributedString)this.attributed.get((Object)key);
        if (null != value) {
            return value;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Lookup failed for %s in cache", key));
        }
        if (identifier.equals(BrowserColumn.filename.name())) {
            value = NSAttributedString.attributedStringWithAttributes((String)item.getName(), (NSDictionary)TableCellAttributes.browserFontLeftAlignment());
        } else if (identifier.equals(BrowserColumn.size.name())) {
            value = NSAttributedString.attributedStringWithAttributes((String)this.sizeFormatter.format(item.attributes().getSize()), (NSDictionary)TableCellAttributes.browserFontRightAlignment());
        } else if (identifier.equals(BrowserColumn.modified.name())) {
            value = NSAttributedString.attributedStringWithAttributes((String)this.dateFormatter.getShortFormat(item.attributes().getModificationDate(), this.preferences.getBoolean("browser.date.natural")), (NSDictionary)TableCellAttributes.browserFontLeftAlignment());
        } else if (identifier.equals(BrowserColumn.owner.name())) {
            value = NSAttributedString.attributedStringWithAttributes((String)(StringUtils.isBlank((CharSequence)item.attributes().getOwner()) ? LocaleFactory.localizedString((String)"Unknown") : item.attributes().getOwner()), (NSDictionary)TableCellAttributes.browserFontLeftAlignment());
        } else if (identifier.equals(BrowserColumn.group.name())) {
            value = NSAttributedString.attributedStringWithAttributes((String)(StringUtils.isBlank((CharSequence)item.attributes().getGroup()) ? LocaleFactory.localizedString((String)"Unknown") : item.attributes().getGroup()), (NSDictionary)TableCellAttributes.browserFontLeftAlignment());
        } else if (identifier.equals(BrowserColumn.permission.name())) {
            Acl acl = item.attributes().getAcl();
            if (!Acl.EMPTY.equals((Object)acl)) {
                StringBuilder s = new StringBuilder();
                for (Map.Entry entry : acl.entrySet()) {
                    s.append(String.format("%s%s:%s", s.length() == 0 ? "" : ", ", ((Acl.User)entry.getKey()).getDisplayName(), entry.getValue()));
                }
                value = NSAttributedString.attributedStringWithAttributes((String)s.toString(), (NSDictionary)TableCellAttributes.browserFontLeftAlignment());
            } else {
                Permission permission = item.attributes().getPermission();
                value = NSAttributedString.attributedStringWithAttributes((String)permission.toString(), (NSDictionary)TableCellAttributes.browserFontLeftAlignment());
            }
        } else if (identifier.equals(BrowserColumn.kind.name())) {
            value = NSAttributedString.attributedStringWithAttributes((String)this.descriptor.getKind(item), (NSDictionary)TableCellAttributes.browserFontLeftAlignment());
        } else if (identifier.equals(BrowserColumn.extension.name())) {
            value = NSAttributedString.attributedStringWithAttributes((String)(item.isFile() ? (StringUtils.isNotBlank((CharSequence)item.getExtension()) ? item.getExtension() : LocaleFactory.localizedString((String)"None")) : LocaleFactory.localizedString((String)"None")), (NSDictionary)TableCellAttributes.browserFontLeftAlignment());
        } else if (identifier.equals(BrowserColumn.region.name())) {
            value = NSAttributedString.attributedStringWithAttributes((String)(StringUtils.isNotBlank((CharSequence)item.attributes().getRegion()) ? item.attributes().getRegion() : LocaleFactory.localizedString((String)"Unknown")), (NSDictionary)TableCellAttributes.browserFontLeftAlignment());
        } else if (identifier.equals(BrowserColumn.version.name())) {
            value = NSAttributedString.attributedStringWithAttributes((String)(StringUtils.isNotBlank((CharSequence)item.attributes().getVersionId()) ? item.attributes().getVersionId() : LocaleFactory.localizedString((String)"None")), (NSDictionary)TableCellAttributes.browserFontLeftAlignment());
        } else {
            throw new IllegalArgumentException(String.format("Unknown identifier %s", identifier));
        }
        this.attributed.put((Object)key, (Object)value);
        return value;
    }

    public boolean ignoreModifierKeysWhileDragging() {
        return false;
    }

    public NSUInteger draggingSourceOperationMaskForLocal(boolean local) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Request dragging source operation mask for local %s", local));
        }
        if (local) {
            return new NSUInteger((long)(NSDraggingInfo.NSDragOperationMove.intValue() | NSDraggingInfo.NSDragOperationCopy.intValue()));
        }
        return new NSUInteger((long)(NSDraggingInfo.NSDragOperationCopy.intValue() | NSDraggingInfo.NSDragOperationDelete.intValue()));
    }

    public boolean acceptDrop(NSTableView view, Path destination, NSDraggingInfo info) {
        NSArray elements;
        NSObject o;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Accept drop for destination %s", destination));
        }
        if (info.draggingPasteboard().availableTypeFromArray(NSArray.arrayWithObject((String)"Apple URL pasteboard type")) != null && (o = info.draggingPasteboard().propertyListForType("Apple URL pasteboard type")) != null && o.isKindOfClass(Rococoa.createClass((String)"NSArray", NSArray._Class.class))) {
            elements = (NSArray)Rococoa.cast((ObjCObject)o, NSArray.class);
            for (int i = 0; i < elements.count().intValue(); ++i) {
                if (!Scheme.isURL((String)elements.objectAtIndex(new NSUInteger((long)i)).toString())) continue;
                try {
                    this.controller.mount(HostParser.parse((String)elements.objectAtIndex(new NSUInteger((long)i)).toString()));
                }
                catch (HostParserException e) {
                    log.warn((Object)e);
                    continue;
                }
                return true;
            }
        }
        if (this.controller.isMounted()) {
            if (info.draggingPasteboard().availableTypeFromArray(NSArray.arrayWithObject((String)"NSFilenamesPboardType")) != null) {
                o = info.draggingPasteboard().propertyListForType("NSFilenamesPboardType");
                if (o != null && o.isKindOfClass(Rococoa.createClass((String)"NSArray", NSArray._Class.class))) {
                    elements = (NSArray)Rococoa.cast((ObjCObject)o, NSArray.class);
                    ArrayList<TransferItem> roots = new ArrayList<TransferItem>();
                    for (int i = 0; i < elements.count().intValue(); ++i) {
                        Local local = LocalFactory.get((String)elements.objectAtIndex(new NSUInteger((long)i)).toString());
                        roots.add(new TransferItem(new Path(destination, local.getName(), local.isDirectory() ? EnumSet.of(AbstractPath.Type.directory) : EnumSet.of(AbstractPath.Type.file)), local));
                    }
                    this.controller.transfer((Transfer)new UploadTransfer(this.controller.getSession().getHost(), roots));
                    return true;
                }
                return false;
            }
            List pasteboards = PathPasteboardFactory.allPasteboards();
            for (PathPasteboard pasteboard : pasteboards) {
                if (pasteboard.isEmpty()) continue;
                HashMap<Path, Path> files = new HashMap<Path, Path>();
                for (Path next : pasteboard) {
                    Path renamed = new Path(destination, next.getName(), next.getType(), new PathAttributes(next.attributes()).withVersionId(null));
                    files.put(next, renamed);
                }
                if (pasteboard.getBookmark().compareTo(this.controller.getSession().getHost()) != 0) {
                    Host target = this.controller.getSession().getHost();
                    this.controller.transfer((Transfer)new CopyTransfer(pasteboard.getBookmark(), target, files), new ArrayList<Path>(files.values()), false);
                } else if (info.draggingSourceOperationMask().intValue() == NSDraggingInfo.NSDragOperationCopy.intValue()) {
                    new CopyController(this.controller).copy(files);
                } else {
                    new MoveController(this.controller).rename(files);
                }
                pasteboard.clear();
            }
            return true;
        }
        return false;
    }

    public NSUInteger validateDrop(NSTableView view, Path destination, NSInteger row, NSDraggingInfo info) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Validate drop for destination %s", destination));
        }
        if (info.draggingPasteboard().availableTypeFromArray(NSArray.arrayWithObject((String)"Apple URL pasteboard type")) != null) {
            NSObject o = info.draggingPasteboard().propertyListForType("Apple URL pasteboard type");
            if (o != null) {
                if (o.isKindOfClass(Rococoa.createClass((String)"NSArray", NSArray._Class.class))) {
                    NSArray elements = (NSArray)Rococoa.cast((ObjCObject)o, NSArray.class);
                    for (int i = 0; i < elements.count().intValue(); ++i) {
                        if (Scheme.isURL((String)elements.objectAtIndex(new NSUInteger((long)i)).toString())) {
                            view.setDropRow(new NSInteger(-1L), NSTableView.NSTableViewDropOn);
                            return NSDraggingInfo.NSDragOperationCopy;
                        }
                        log.warn((Object)String.format("Protocol not supported for URL %s", elements.objectAtIndex(new NSUInteger((long)i)).toString()));
                    }
                }
            } else {
                log.warn((Object)"URL dragging pasteboard is empty.");
            }
        }
        if (this.controller.isMounted()) {
            if (null == destination) {
                log.warn((Object)"Dragging destination is null.");
                return NSDraggingInfo.NSDragOperationNone;
            }
            Touch feature = (Touch)this.controller.getSession().getFeature(Touch.class);
            if (!feature.isSupported(destination, "")) {
                return NSDraggingInfo.NSDragOperationNone;
            }
            if (info.draggingPasteboard().availableTypeFromArray(NSArray.arrayWithObject((String)"NSFilenamesPboardType")) != null) {
                this.setDropRowAndDropOperation(view, destination, row);
                return NSDraggingInfo.NSDragOperationCopy;
            }
            for (Path next : this.controller.getPasteboard()) {
                if (destination.equals((Object)next)) {
                    return NSDraggingInfo.NSDragOperationNone;
                }
                if (next.isDirectory() && destination.isChild(next)) {
                    return NSDraggingInfo.NSDragOperationNone;
                }
                if (!next.isFile() || !next.getParent().equals((Object)destination)) continue;
                return NSDraggingInfo.NSDragOperationNone;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Drag operation mask is %d", info.draggingSourceOperationMask().intValue()));
            }
            this.setDropRowAndDropOperation(view, destination, row);
            List pasteboards = PathPasteboardFactory.allPasteboards();
            for (PathPasteboard pasteboard : pasteboards) {
                if (pasteboard.isEmpty()) continue;
                if (pasteboard.getBookmark().compareTo(this.controller.getSession().getHost()) == 0) {
                    if (info.draggingSourceOperationMask().intValue() == NSDraggingInfo.NSDragOperationCopy.intValue()) {
                        for (Path file : pasteboard) {
                            if (((Copy)this.controller.getSession().getFeature(Copy.class)).isSupported(file, destination)) continue;
                            return NSDraggingInfo.NSDragOperationNone;
                        }
                        return NSDraggingInfo.NSDragOperationCopy;
                    }
                    for (Path file : pasteboard) {
                        if (((Move)this.controller.getSession().getFeature(Move.class)).isSupported(file, destination)) continue;
                        return NSDraggingInfo.NSDragOperationNone;
                    }
                    return NSDraggingInfo.NSDragOperationMove;
                }
                return NSDraggingInfo.NSDragOperationCopy;
            }
        }
        return NSDraggingInfo.NSDragOperationNone;
    }

    private void setDropRowAndDropOperation(NSTableView view, Path destination, NSInteger row) {
        if (destination.equals((Object)this.controller.workdir())) {
            log.debug((Object)"setDropRowAndDropOperation:-1");
            view.setDropRow(new NSInteger(-1L), NSTableView.NSTableViewDropOn);
        } else if (destination.isDirectory()) {
            log.debug((Object)("setDropRowAndDropOperation:" + row.intValue()));
            view.setDropRow(row, NSTableView.NSTableViewDropOn);
        }
    }

    public boolean writeItemsToPasteBoard(NSTableView view, List<Path> selected, NSPasteboard pboard) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Write items to pasteboard %s", pboard));
        }
        if (this.controller.isMounted() && selected.size() > 0) {
            LinkedHashSet<String> fileTypes = new LinkedHashSet<String>();
            PathPasteboard pasteboard = this.controller.getPasteboard();
            for (Path f : selected) {
                if (f.isFile()) {
                    if (StringUtils.isNotBlank((CharSequence)f.getExtension())) {
                        fileTypes.add(f.getExtension());
                    } else {
                        fileTypes.add("NSFileTypeRegular");
                    }
                } else if (f.isDirectory()) {
                    fileTypes.add("'fldr'");
                } else {
                    fileTypes.add("NSFileTypeUnknown");
                }
                pasteboard.add((Object)f);
            }
            NSEvent event = NSApplication.sharedApplication().currentEvent();
            if (event != null) {
                NSPoint dragPosition = view.convertPoint_fromView(event.locationInWindow(), null);
                NSRect imageRect = new NSRect(new NSPoint(dragPosition.x.doubleValue() - 16.0, dragPosition.y.doubleValue() - 16.0), new NSSize(32.0, 32.0));
                if (!view.dragPromisedFilesOfTypes(NSMutableArray.arrayWithObject((String)((String)fileTypes.iterator().next())), imageRect, this.id(), true, event)) {
                    log.warn((Object)String.format("Failure for drag promise operation of %s", event));
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public void draggedImage_beganAt(NSImage image, NSPoint point) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("draggedImage_beganAt:" + point));
        }
    }

    public void draggedImage_endedAt_operation(NSImage image, NSPoint point, NSUInteger operation) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("draggedImage_endedAt_operation:" + operation));
        }
        PathPasteboard pasteboard = this.controller.getPasteboard();
        if (NSDraggingInfo.NSDragOperationDelete.intValue() == operation.intValue()) {
            new DeleteController(this.controller).delete((List<Path>)pasteboard);
        }
        pasteboard.clear();
    }

    public void draggedImage_movedTo(NSImage image, NSPoint point) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("draggedImage_movedTo:" + point));
        }
    }

    public NSArray namesOfPromisedFilesDroppedAtDestination(NSURL url) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Return names of promised files dropped at %s", url));
        }
        NSMutableArray promisedDragNames = NSMutableArray.array();
        if (null != url) {
            boolean dock;
            Local destination = LocalFactory.get((String)url.path());
            DownloadFilterOptions options = new DownloadFilterOptions();
            if (destination.isChild(new TemporarySupportDirectoryFinder().find())) {
                options.icon = false;
                options.segments = false;
            }
            PathPasteboard pasteboard = this.controller.getPasteboard();
            ArrayList<TransferItem> downloads = new ArrayList<TransferItem>();
            for (Path p : pasteboard) {
                downloads.add(new TransferItem(p, LocalFactory.get((Local)destination, (String)p.getName())));
                promisedDragNames.addObject(p.getName());
            }
            if (downloads.size() == 1) {
                Local file;
                if (((TransferItem)downloads.iterator().next()).remote.isFile() && !(file = ((TransferItem)downloads.iterator().next()).local).exists()) {
                    try {
                        LocalTouchFactory.get().touch(file);
                        if (options.icon) {
                            IconServiceFactory.get().set(file, new TransferStatus().length(0L));
                        }
                    }
                    catch (AccessDeniedException e) {
                        log.warn((Object)String.format("Failure creating file %s %s", file, e.getMessage()));
                    }
                }
                if (((TransferItem)downloads.iterator().next()).remote.isDirectory() && !(file = ((TransferItem)downloads.iterator().next()).local).exists()) {
                    try {
                        new DefaultLocalDirectoryFeature().mkdir(file);
                    }
                    catch (AccessDeniedException e) {
                        log.warn((Object)e.getMessage());
                    }
                }
            }
            if (dock = destination.equals((Object)LocalFactory.get((String)"~/Library/Caches/TemporaryItems"))) {
                for (Path p : pasteboard) {
                    this.controller.edit(p);
                }
            } else {
                Transfer transfer = new DownloadTransfer(this.controller.getSession().getHost(), downloads).withOptions(options);
                this.controller.transfer(transfer, Collections.emptyList());
            }
            pasteboard.clear();
        }
        return promisedDragNames;
    }

    private static final class Item {
        private final Path file;
        private final String column;

        public Item(Path file, String column) {
            this.file = file;
            this.column = column;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Item item = (Item)o;
            if (!Objects.equals(this.column, item.column)) {
                return false;
            }
            return Objects.equals(this.file, item.file);
        }

        public int hashCode() {
            int result = this.file != null ? this.file.hashCode() : 0;
            result = 31 * result + (this.column != null ? this.column.hashCode() : 0);
            return result;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Item{");
            sb.append("file=").append(this.file);
            sb.append(", column='").append(this.column).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }
}

