/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.datasource;

import ch.cyberduck.binding.ListDataSource;
import ch.cyberduck.binding.application.NSDraggingInfo;
import ch.cyberduck.binding.application.NSTableColumn;
import ch.cyberduck.binding.application.NSTableView;
import ch.cyberduck.binding.foundation.NSArray;
import ch.cyberduck.binding.foundation.NSIndexSet;
import ch.cyberduck.binding.foundation.NSObject;
import ch.cyberduck.core.AbstractCollectionListener;
import ch.cyberduck.core.Collection;
import ch.cyberduck.core.CollectionListener;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.TransferCollection;
import ch.cyberduck.core.pasteboard.PathPasteboard;
import ch.cyberduck.core.pasteboard.PathPasteboardFactory;
import ch.cyberduck.core.transfer.DownloadTransfer;
import ch.cyberduck.core.transfer.NullTransferFilter;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferFilter;
import ch.cyberduck.core.transfer.TransferItem;
import ch.cyberduck.ui.browser.DownloadDirectoryFinder;
import ch.cyberduck.ui.cocoa.controller.DownloadController;
import ch.cyberduck.ui.cocoa.controller.ProgressController;
import ch.cyberduck.ui.cocoa.controller.TransferControllerFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.rococoa.cocoa.foundation.NSInteger;
import org.rococoa.cocoa.foundation.NSUInteger;

public class TransferTableDataSource
extends ListDataSource {
    private static final Logger log = Logger.getLogger(TransferTableDataSource.class);
    private final Map<Transfer, ProgressController> controllers = new HashMap<Transfer, ProgressController>();
    private TransferFilter filter = new NullTransferFilter();
    private final Collection<Transfer> collection = TransferCollection.defaultCollection();

    public TransferTableDataSource() {
        this.collection.addListener((CollectionListener)new AbstractCollectionListener<Transfer>(){

            public void collectionItemRemoved(Transfer item) {
                ProgressController controller = (ProgressController)((Object)TransferTableDataSource.this.controllers.remove(item));
                if (controller != null) {
                    controller.invalidate();
                }
            }
        });
    }

    public void setFilter(final String searchString) {
        this.filter = StringUtils.isBlank((CharSequence)searchString) ? new NullTransferFilter() : new TransferFilter(){

            public boolean accept(Transfer transfer) {
                for (TransferItem root : transfer.getRoots()) {
                    if (!root.remote.getName().toLowerCase(Locale.ROOT).contains(searchString.toLowerCase(Locale.ROOT))) continue;
                    return true;
                }
                return transfer.getSource().getHostname().toLowerCase(Locale.ROOT).contains(searchString.toLowerCase(Locale.ROOT));
            }
        };
    }

    public Collection<Transfer> getSource() {
        if (this.filter instanceof NullTransferFilter) {
            return this.collection;
        }
        Collection filtered = new Collection(this.collection);
        filtered.removeIf(transfer -> !this.filter.accept(transfer));
        return filtered;
    }

    public NSObject tableView_objectValueForTableColumn_row(NSTableView view, NSTableColumn tableColumn, NSInteger row) {
        return null;
    }

    public NSInteger numberOfRowsInTableView(NSTableView view) {
        return new NSInteger((long)this.getSource().size());
    }

    public NSUInteger tableView_validateDrop_proposedRow_proposedDropOperation(NSTableView view, NSDraggingInfo draggingInfo, NSInteger row, NSUInteger operation) {
        log.debug((Object)("tableViewValidateDrop:row:" + row + ",operation:" + operation));
        if (draggingInfo.draggingPasteboard().availableTypeFromArray(NSArray.arrayWithObject((String)"NSStringPboardType")) != null) {
            view.setDropRow(row, NSTableView.NSTableViewDropAbove);
            return NSDraggingInfo.NSDragOperationCopy;
        }
        if (!PathPasteboardFactory.allPasteboards().isEmpty()) {
            view.setDropRow(row, NSTableView.NSTableViewDropAbove);
            return NSDraggingInfo.NSDragOperationCopy;
        }
        log.debug((Object)"tableViewValidateDrop:DragOperationNone");
        return NSDraggingInfo.NSDragOperationNone;
    }

    public boolean tableView_acceptDrop_row_dropOperation(NSTableView view, NSDraggingInfo draggingInfo, NSInteger row, NSUInteger operation) {
        if (draggingInfo.draggingPasteboard().availableTypeFromArray(NSArray.arrayWithObject((String)"NSStringPboardType")) != null) {
            String droppedText = draggingInfo.draggingPasteboard().stringForType("NSStringPboardType");
            if (StringUtils.isNotBlank((CharSequence)droppedText)) {
                log.info((Object)("NSPasteboard.StringPboardType:" + droppedText));
                DownloadController c = new DownloadController(droppedText);
                c.beginSheet(TransferControllerFactory.get());
                return true;
            }
            return false;
        }
        List pasteboards = PathPasteboardFactory.allPasteboards();
        if (pasteboards.isEmpty()) {
            return false;
        }
        for (PathPasteboard pasteboard : pasteboards) {
            if (pasteboard.isEmpty()) continue;
            Host host = pasteboard.getBookmark();
            ArrayList<TransferItem> downloads = new ArrayList<TransferItem>();
            for (Path download : pasteboard) {
                downloads.add(new TransferItem(download, LocalFactory.get((Local)new DownloadDirectoryFinder().find(host), (String)download.getName())));
            }
            this.collection.add(row.intValue(), (Object)new DownloadTransfer(host, downloads));
            view.reloadData();
            view.selectRowIndexes(NSIndexSet.indexSetWithIndex((NSInteger)row), false);
            view.scrollRowToVisible(row);
        }
        pasteboards.clear();
        return true;
    }

    public ProgressController getController(int row) {
        return this.getController((Transfer)this.getSource().get(row));
    }

    public ProgressController getController(Transfer t) {
        if (!this.controllers.containsKey(t)) {
            ProgressController controller = new ProgressController(t);
            controller.loadBundle();
            this.controllers.put(t, controller);
        }
        return this.controllers.get(t);
    }

    public boolean isHighlighted(int row) {
        return this.getController(row).isHighlighted();
    }

    public void setHighlighted(int row, boolean highlighted) {
        this.getController(row).setHighlighted(highlighted);
    }
}

