/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.delegate;

import ch.cyberduck.binding.BundleController;
import ch.cyberduck.binding.application.NSImage;
import ch.cyberduck.binding.application.NSMenu;
import ch.cyberduck.binding.application.NSMenuItem;
import ch.cyberduck.binding.foundation.NSAttributedString;
import ch.cyberduck.binding.foundation.NSDictionary;
import ch.cyberduck.binding.foundation.NSMutableAttributedString;
import ch.cyberduck.core.AbstractHostCollection;
import ch.cyberduck.core.BookmarkCollection;
import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.HistoryCollection;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostFilter;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.local.ApplicationLauncherFactory;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.resources.IconCacheFactory;
import ch.cyberduck.ui.cocoa.controller.MainController;
import ch.cyberduck.ui.cocoa.delegate.CollectionMenuDelegate;
import ch.cyberduck.ui.cocoa.delegate.HistoryMenuDelegate;
import ch.cyberduck.ui.cocoa.delegate.MenuCallback;
import ch.cyberduck.ui.cocoa.delegate.RendezvousMenuDelegate;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.Selector;
import org.rococoa.cocoa.foundation.NSInteger;

public class BookmarkMenuDelegate
extends CollectionMenuDelegate<Host> {
    private static final Logger log = Logger.getLogger(BookmarkMenuDelegate.class);
    private static final int BOOKMARKS_INDEX = 8;
    private final Preferences preferences = PreferencesFactory.get();
    private final AbstractHostCollection bookmarks;
    private final int index;
    private final MenuCallback callback;
    private final NSMenu historyMenu = NSMenu.menu();
    private final HistoryMenuDelegate historyMenuDelegate;
    private final NSMenu rendezvousMenu = NSMenu.menu();
    private final RendezvousMenuDelegate rendezvousMenuDelegate;

    public BookmarkMenuDelegate() {
        this(new HistoryMenuDelegate(), new RendezvousMenuDelegate());
    }

    public BookmarkMenuDelegate(HistoryMenuDelegate history, RendezvousMenuDelegate rendezvous) {
        this(new MenuCallback(){

            @Override
            public void selected(NSMenuItem sender) {
                MainController.newDocument().mount(BookmarkCollection.defaultCollection().lookup(sender.representedObject()));
            }
        }, history, rendezvous);
    }

    public BookmarkMenuDelegate(MenuCallback callback) {
        this(callback, new HistoryMenuDelegate(), new RendezvousMenuDelegate());
    }

    public BookmarkMenuDelegate(MenuCallback callback, HistoryMenuDelegate history, RendezvousMenuDelegate rendezvous) {
        this((AbstractHostCollection)BookmarkCollection.defaultCollection(), 8, callback, history, rendezvous);
    }

    public BookmarkMenuDelegate(AbstractHostCollection bookmarks, int index, MenuCallback callback, HistoryMenuDelegate history, RendezvousMenuDelegate rendezvous) {
        super(bookmarks);
        this.bookmarks = bookmarks;
        this.index = index;
        this.historyMenuDelegate = history;
        this.rendezvousMenuDelegate = rendezvous;
        this.historyMenu.setDelegate(this.historyMenuDelegate.id());
        this.rendezvousMenu.setDelegate(this.rendezvousMenuDelegate.id());
        this.callback = callback;
    }

    @Override
    public NSInteger numberOfItemsInMenu(NSMenu menu) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean menuUpdateItemAtIndex(NSMenu menu, NSMenuItem item, NSInteger index, boolean cancel) {
        throw new UnsupportedOperationException();
    }

    public void menuNeedsUpdate(NSMenu menu) {
        if (!this.isPopulated()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("Build menu %s", menu));
            }
            for (int i = menu.numberOfItems().intValue() - 1; i >= 8; --i) {
                menu.removeItemAtIndex(new NSInteger((long)i));
            }
            NSMenuItem item = NSMenuItem.itemWithTitle((String)LocaleFactory.get().localize("History", "Localizable"), null, (String)"");
            item.setEnabled(true);
            item.setImage((NSImage)IconCacheFactory.get().iconNamed("history.tiff", Integer.valueOf(16)));
            item.setTarget(this.id());
            item.setAction(Foundation.selector((String)"historyMenuClicked:"));
            this.historyMenu.setSupermenu(null);
            item.setSubmenu(this.historyMenu);
            menu.addItem(item);
            item = NSMenuItem.itemWithTitle((String)LocaleFactory.get().localize("Bonjour", "Main"), null, (String)"");
            item.setEnabled(true);
            item.setImage((NSImage)IconCacheFactory.get().iconNamed("rendezvous.tiff", Integer.valueOf(16)));
            this.rendezvousMenu.setSupermenu(null);
            item.setSubmenu(this.rendezvousMenu);
            menu.addItem(item);
            menu.addItem(NSMenuItem.separatorItem());
            this.bookmarks.groups(HostFilter.NONE).forEach((label, bookmarks) -> {
                NSMenu submenu;
                if (StringUtils.isNotBlank((CharSequence)label)) {
                    NSMenuItem group = NSMenuItem.itemWithTitle((String)label, null, (String)"");
                    NSMutableAttributedString title = NSMutableAttributedString.create((String)label);
                    title.appendAttributedString(NSAttributedString.attributedStringWithAttributes((String)String.format("\n%s", MessageFormat.format(LocaleFactory.localizedString((String)"{0} Bookmarks", (String)"Localizable"), bookmarks.size())), (NSDictionary)BundleController.MENU_HELP_FONT_ATTRIBUTES));
                    group.setAttributedTitle((NSAttributedString)title);
                    switch (this.preferences.getInteger("bookmark.menu.icon.size")) {
                        default: {
                            group.setImage((NSImage)IconCacheFactory.get().iconNamed("NSFolder", Integer.valueOf(16)));
                            break;
                        }
                        case 32: {
                            group.setImage((NSImage)IconCacheFactory.get().iconNamed("NSFolder", Integer.valueOf(24)));
                            break;
                        }
                        case 64: {
                            group.setImage((NSImage)IconCacheFactory.get().iconNamed("NSFolder", Integer.valueOf(40)));
                        }
                    }
                    submenu = NSMenu.menu();
                    group.setSubmenu(submenu);
                    menu.addItem(group);
                } else {
                    submenu = menu;
                }
                for (Host h : bookmarks) {
                    submenu.addItem(this.build(h));
                }
            });
        }
    }

    private NSMenuItem build(Host h) {
        NSMenuItem item = NSMenuItem.itemWithTitle((String)BookmarkNameProvider.toString((Host)h), (Selector)this.getDefaultAction(), (String)"");
        NSMutableAttributedString title = NSMutableAttributedString.create((String)BookmarkNameProvider.toString((Host)h));
        if (this.preferences.getInteger("bookmark.menu.icon.size") >= 32) {
            title.appendAttributedString(NSAttributedString.attributedStringWithAttributes((String)String.format("\n%s", h.getHostname()), (NSDictionary)BundleController.MENU_HELP_FONT_ATTRIBUTES));
        }
        if (this.preferences.getInteger("bookmark.menu.icon.size") >= 64) {
            title.appendAttributedString(NSAttributedString.attributedStringWithAttributes((String)String.format("\n%s", StringUtils.isNotBlank((CharSequence)h.getCredentials().getUsername()) ? h.getCredentials().getUsername() : ""), (NSDictionary)BundleController.MENU_HELP_FONT_ATTRIBUTES));
        }
        item.setAttributedTitle((NSAttributedString)title);
        item.setTitle(BookmarkNameProvider.toString((Host)h));
        switch (this.preferences.getInteger("bookmark.menu.icon.size")) {
            default: {
                item.setImage((NSImage)IconCacheFactory.get().iconNamed(h.getProtocol().icon(), Integer.valueOf(16)));
                break;
            }
            case 32: {
                item.setImage((NSImage)IconCacheFactory.get().iconNamed(h.getProtocol().icon(), Integer.valueOf(24)));
                break;
            }
            case 64: {
                item.setImage((NSImage)IconCacheFactory.get().iconNamed(h.getProtocol().icon(), Integer.valueOf(40)));
            }
        }
        item.setTarget(this.id());
        item.setAction(this.getDefaultAction());
        item.setRepresentedObject(h.getUuid());
        return item;
    }

    public void bookmarkMenuItemClicked(NSMenuItem sender) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Menu item clicked %s", sender));
        }
        this.callback.selected(sender);
    }

    public void historyMenuClicked(NSMenuItem sender) {
        ApplicationLauncherFactory.get().open(HistoryCollection.defaultCollection().getFolder());
    }

    @Override
    public Selector getDefaultAction() {
        return Foundation.selector((String)"bookmarkMenuItemClicked:");
    }
}

