/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.delegate;

import ch.cyberduck.binding.application.NSMenu;
import ch.cyberduck.core.Collection;
import ch.cyberduck.core.CollectionListener;
import ch.cyberduck.ui.cocoa.delegate.AbstractMenuDelegate;
import org.rococoa.cocoa.foundation.NSInteger;

public abstract class CollectionMenuDelegate<T>
extends AbstractMenuDelegate
implements CollectionListener<T> {
    public static final int SMALL_ICON_SIZE = 16;
    public static final int MEDIUM_ICON_SIZE = 24;
    public static final int LARGE_ICON_SIZE = 40;
    private final Collection<T> collection;

    public CollectionMenuDelegate(Collection<T> c) {
        this.collection = c;
        this.collection.addListener((CollectionListener)this);
    }

    public NSInteger numberOfItemsInMenu(NSMenu menu) {
        if (this.isPopulated()) {
            return new NSInteger(-1L);
        }
        if (this.collection.size() > 0) {
            return new NSInteger((long)this.collection.size());
        }
        return new NSInteger(1L);
    }

    public T itemForIndex(NSInteger index) {
        return (T)this.collection.get(index.intValue());
    }

    public void collectionItemAdded(T item) {
        this.setNeedsUpdate(true);
    }

    public void collectionItemRemoved(T item) {
        this.setNeedsUpdate(true);
    }

    public void collectionItemChanged(T item) {
        this.setNeedsUpdate(true);
    }

    public void collectionLoaded() {
        this.setNeedsUpdate(true);
    }

    public void invalidate() {
        this.collection.removeListener((CollectionListener)this);
        super.invalidate();
    }
}

