/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.delegate;

import ch.cyberduck.binding.application.NSImage;
import ch.cyberduck.binding.application.NSMenu;
import ch.cyberduck.binding.application.NSMenuItem;
import ch.cyberduck.core.AbstractHostCollection;
import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.bonjour.RendezvousCollection;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.resources.IconCacheFactory;
import ch.cyberduck.ui.cocoa.controller.MainController;
import ch.cyberduck.ui.cocoa.delegate.CollectionMenuDelegate;
import ch.cyberduck.ui.cocoa.delegate.MenuCallback;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.Selector;
import org.rococoa.cocoa.foundation.NSInteger;

public class RendezvousMenuDelegate
extends CollectionMenuDelegate<Host> {
    private static final Logger log = Logger.getLogger(RendezvousMenuDelegate.class);
    private final AbstractHostCollection collection;
    private final MenuCallback callback;
    private final Preferences preferences = PreferencesFactory.get();

    public RendezvousMenuDelegate() {
        this(new MenuCallback(){

            @Override
            public void selected(NSMenuItem sender) {
                MainController.newDocument().mount(RendezvousCollection.defaultCollection().lookup(sender.representedObject()));
            }
        });
    }

    public RendezvousMenuDelegate(MenuCallback callback) {
        this((AbstractHostCollection)RendezvousCollection.defaultCollection(), callback);
    }

    public RendezvousMenuDelegate(AbstractHostCollection collection, MenuCallback callback) {
        super(collection);
        this.collection = collection;
        this.callback = callback;
    }

    @Override
    public boolean menuUpdateItemAtIndex(NSMenu menu, NSMenuItem item, NSInteger index, boolean cancel) {
        if (this.collection.size() == 0) {
            item.setTitle(LocaleFactory.localizedString((String)"None"));
            item.setTarget(null);
            item.setAction(null);
            item.setImage(null);
            item.setEnabled(false);
        } else {
            Host h = (Host)this.itemForIndex(index);
            item.setTitle(BookmarkNameProvider.toString((Host)h));
            item.setTarget(this.id());
            item.setEnabled(true);
            item.setImage((NSImage)IconCacheFactory.get().iconNamed(h.getProtocol().icon(), Integer.valueOf(16)));
            item.setTarget(this.id());
            item.setAction(this.getDefaultAction());
            item.setRepresentedObject(h.getUuid());
        }
        return super.menuUpdateItemAtIndex(menu, item, index, cancel);
    }

    public void menuItemClicked(NSMenuItem sender) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Menu item clicked %s", sender));
        }
        this.callback.selected(sender);
    }

    @Override
    public Selector getDefaultAction() {
        return Foundation.selector((String)"menuItemClicked:");
    }
}

