/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.toolbar;

import ch.cyberduck.binding.application.NSPopUpButton;
import ch.cyberduck.binding.application.NSToolbarItem;
import ch.cyberduck.binding.foundation.NSIndexSet;
import ch.cyberduck.core.Collection;
import ch.cyberduck.core.pasteboard.PathPasteboardFactory;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferItem;
import ch.cyberduck.ui.cocoa.controller.TransferController;
import ch.cyberduck.ui.cocoa.toolbar.ToolbarValidator;
import ch.cyberduck.ui.cocoa.toolbar.TransferToolbarFactory;
import org.rococoa.Foundation;
import org.rococoa.ObjCObject;
import org.rococoa.Rococoa;
import org.rococoa.Selector;
import org.rococoa.cocoa.foundation.NSUInteger;

public class TransferToolbarValidator
implements ToolbarValidator {
    private final TransferController controller;

    public TransferToolbarValidator(TransferController controller) {
        this.controller = controller;
    }

    @Override
    public boolean validate(final NSToolbarItem item) {
        Selector action = item.action();
        if (action.equals((Object)TransferToolbarFactory.TransferToolbarItem.bandwidth.action())) {
            return this.validate(new InnerTransferValidator(){

                @Override
                public boolean validate(Transfer transfer) {
                    NSPopUpButton popup = (NSPopUpButton)Rococoa.cast((ObjCObject)item.view(), NSPopUpButton.class);
                    popup.selectItemAtIndex(popup.indexOfItemWithRepresentedObject(String.valueOf((int)transfer.getBandwidth().getRate())));
                    return true;
                }
            });
        }
        if (action.equals((Object)TransferToolbarFactory.TransferToolbarItem.connections.action())) {
            this.validate(new InnerTransferValidator(){

                @Override
                public boolean validate(Transfer transfer) {
                    NSPopUpButton popup = (NSPopUpButton)Rococoa.cast((ObjCObject)item.view(), NSPopUpButton.class);
                    switch (transfer.getTransferType()) {
                        case newconnection: {
                            popup.selectItemAtIndex(popup.indexOfItemWithRepresentedObject(String.valueOf(1)));
                            break;
                        }
                        default: {
                            popup.selectItemAtIndex(popup.indexOfItemWithRepresentedObject(PreferencesFactory.get().getProperty("queue.connections.limit")));
                        }
                    }
                    return true;
                }
            });
            return true;
        }
        return this.validate(action);
    }

    @Override
    public boolean validate(Selector action) {
        if (action.equals((Object)Foundation.selector((String)"paste:"))) {
            return !PathPasteboardFactory.allPasteboards().isEmpty();
        }
        if (action.equals((Object)TransferToolbarFactory.TransferToolbarItem.stop.action())) {
            return this.validate(new InnerTransferValidator(){

                @Override
                public boolean validate(Transfer transfer) {
                    return transfer.isRunning();
                }
            });
        }
        if (action.equals((Object)TransferToolbarFactory.TransferToolbarItem.reload.action())) {
            return this.validate(new InnerTransferValidator(){

                @Override
                public boolean validate(Transfer transfer) {
                    return transfer.getType().isReloadable() && !transfer.isRunning();
                }
            });
        }
        if (action.equals((Object)TransferToolbarFactory.TransferToolbarItem.remove.action())) {
            return this.validate(new InnerTransferValidator(){

                @Override
                public boolean validate(Transfer transfer) {
                    return !transfer.isRunning();
                }
            });
        }
        if (action.equals((Object)TransferToolbarFactory.TransferToolbarItem.resume.action())) {
            return this.validate(new InnerTransferValidator(){

                @Override
                public boolean validate(Transfer transfer) {
                    if (transfer.isRunning()) {
                        return false;
                    }
                    return !transfer.isComplete();
                }
            });
        }
        if (action.equals((Object)TransferToolbarFactory.TransferToolbarItem.open.action()) || action.equals((Object)TransferToolbarFactory.TransferToolbarItem.trash.action())) {
            return this.validate(new InnerTransferValidator(){

                @Override
                public boolean validate(Transfer transfer) {
                    if (transfer.getLocal() != null) {
                        if (!transfer.isComplete()) {
                            return false;
                        }
                        if (!transfer.isRunning()) {
                            for (TransferItem l : transfer.getRoots()) {
                                if (!l.local.exists()) continue;
                                return true;
                            }
                        }
                    }
                    return false;
                }
            });
        }
        if (action.equals((Object)TransferToolbarFactory.TransferToolbarItem.reveal.action())) {
            return this.validate(new InnerTransferValidator(){

                @Override
                public boolean validate(Transfer transfer) {
                    if (transfer.getLocal() != null) {
                        for (TransferItem l : transfer.getRoots()) {
                            if (!l.local.exists()) continue;
                            return true;
                        }
                    }
                    return false;
                }
            });
        }
        if (action.equals((Object)TransferToolbarFactory.TransferToolbarItem.cleanup.action())) {
            return this.controller.getTransferTable().numberOfRows().intValue() > 0;
        }
        return true;
    }

    private boolean validate(InnerTransferValidator validator) {
        NSIndexSet iterator = this.controller.getTransferTable().selectedRowIndexes();
        Collection<Transfer> transfers = this.controller.getTransferTableModel().getSource();
        NSUInteger index = iterator.firstIndex();
        while (!index.equals((Object)NSIndexSet.NSNotFound)) {
            Transfer transfer = (Transfer)transfers.get(index.intValue());
            if (validator.validate(transfer)) {
                return true;
            }
            index = iterator.indexGreaterThanIndex(index);
        }
        return false;
    }

    private static interface InnerTransferValidator {
        public boolean validate(Transfer var1);
    }
}

