/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.HostUrlProvider;
import ch.cyberduck.core.brick.BrickSession;
import ch.cyberduck.core.dav.DAVClient;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Pairing;
import ch.cyberduck.core.http.DefaultHttpResponseExceptionMappingService;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.log4j.Logger;

public class BrickPairingFeature
implements Pairing {
    private static final Logger log = Logger.getLogger(BrickPairingFeature.class);
    private final BrickSession session;

    public BrickPairingFeature(BrickSession session) {
        this.session = session;
    }

    public void delete(String token) throws BackgroundException {
        try {
            HttpDelete resource = new HttpDelete(String.format("%s/api/rest/v1/api_key", new HostUrlProvider().withUsername(false).withPath(false).get(this.session.getHost())));
            resource.setHeader("X-FilesAPI-Auth", token);
            resource.setHeader("Accept", "application/json");
            resource.setHeader("Content-Type", "application/json");
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Delete paring key %s", token));
            }
            ((DAVClient)this.session.getClient()).execute((HttpRequestBase)resource, (ResponseHandler)new ResponseHandler<Void>(){

                public Void handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                    return null;
                }
            });
        }
        catch (HttpResponseException e) {
            throw new DefaultHttpResponseExceptionMappingService().map(e);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }
}

