/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick;

import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostUrlProvider;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.brick.BrickSession;
import ch.cyberduck.core.dav.DAVClient;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.exception.LoginCanceledException;
import ch.cyberduck.core.exception.LoginFailureException;
import ch.cyberduck.core.http.DefaultHttpResponseExceptionMappingService;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.threading.CancelCallback;
import ch.cyberduck.core.threading.ScheduledThreadPool;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.client.AbstractResponseHandler;
import org.apache.log4j.Logger;

public class BrickPairingSchedulerFeature {
    private static final Logger log = Logger.getLogger(BrickPairingSchedulerFeature.class);
    private final BrickSession session;
    private final String token;
    private final Host host;
    private final CancelCallback cancel;
    private final ScheduledThreadPool scheduler = new ScheduledThreadPool();
    private final Preferences preferences = PreferencesFactory.get();

    public BrickPairingSchedulerFeature(BrickSession session, String token, Host host, CancelCallback cancel) {
        this.session = session;
        this.token = token;
        this.host = host;
        this.cancel = cancel;
    }

    public Credentials repeat(PasswordCallback callback) {
        this.scheduler.repeat(() -> {
            try {
                this.operate(callback);
            }
            catch (ConnectionCanceledException e) {
                log.warn((Object)"Cancel processing scheduled task. %s", (Throwable)e);
                callback.close(null);
                this.shutdown();
            }
            catch (BackgroundException e) {
                log.warn((Object)String.format("Failure processing scheduled task. %s", e.getMessage()), (Throwable)e);
            }
            catch (Exception e) {
                log.error((Object)String.format("Failure processing scheduled task. %s", e.getMessage()), (Throwable)e);
                callback.close(null);
                this.shutdown();
            }
        }, Long.valueOf(this.preferences.getLong("brick.pairing.interval.ms")), TimeUnit.MILLISECONDS);
        return null;
    }

    private Credentials operate(PasswordCallback callback) throws BackgroundException {
        try {
            JsonObject json;
            HttpPost resource = new HttpPost(String.format("%s/api/rest/v1/sessions/pairing_key/%s", new HostUrlProvider().withUsername(false).withPath(false).get(this.session.getHost()), this.token));
            resource.setHeader("Accept", "application/json");
            resource.setHeader("Content-Type", "application/json");
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Fetch credentials for paring key %s from %s", this.token, resource));
            }
            if ((json = (JsonObject)((DAVClient)this.session.getClient()).execute((HttpRequestBase)resource, (ResponseHandler)new AbstractResponseHandler<JsonObject>(){

                public JsonObject handleEntity(HttpEntity entity) throws IOException {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)entity.getContent(), (OutputStream)out);
                    return JsonParser.parseReader((Reader)new InputStreamReader(new ByteArrayInputStream(out.toByteArray()))).getAsJsonObject();
                }
            })).has("nickname") && this.preferences.getBoolean("brick.pairing.nickname.configure")) {
                JsonPrimitive nickname = json.getAsJsonPrimitive("nickname");
                if (StringUtils.isNotBlank((CharSequence)this.host.getNickname()) && !StringUtils.equals((CharSequence)this.host.getNickname(), (CharSequence)nickname.getAsString())) {
                    log.warn((Object)String.format("Mismatch of nickname. Previously authorized as %s and now paired as %s", this.host.getNickname(), nickname.getAsString()));
                    callback.close(null);
                    throw new LoginCanceledException();
                }
                this.host.setNickname(nickname.getAsString());
            }
            Credentials credentials = this.host.getCredentials();
            if (!json.has("username")) {
                throw new LoginFailureException(String.format("Invalid response for pairing key %s", this.token));
            }
            credentials.setUsername(json.getAsJsonPrimitive("username").getAsString());
            if (!json.has("password")) {
                throw new LoginFailureException(String.format("Invalid response for pairing key %s", this.token));
            }
            credentials.setPassword(json.getAsJsonPrimitive("password").getAsString());
            if (json.has("server") && this.preferences.getBoolean("brick.pairing.hostname.configure")) {
                this.host.setHostname(URI.create(json.getAsJsonPrimitive("server").getAsString()).getHost());
            }
            callback.close(credentials.getUsername());
            return credentials;
        }
        catch (JsonParseException e) {
            throw new DefaultIOExceptionMappingService().map(new IOException(e.getMessage(), e));
        }
        catch (HttpResponseException e) {
            switch (e.getStatusCode()) {
                case 404: {
                    log.warn((Object)String.format("Missing login for pairing key %s", this.token));
                    this.cancel.verify();
                    return null;
                }
            }
            throw new DefaultHttpResponseExceptionMappingService().map(e);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    public void shutdown() {
        this.scheduler.shutdown();
    }
}

