/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.openstack;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.DisabledLoginCallback;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.cdn.Distribution;
import ch.cyberduck.core.cdn.DistributionConfiguration;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.openstack.SwiftContainerListService;
import ch.cyberduck.core.openstack.SwiftLocationFeature;
import ch.cyberduck.core.openstack.SwiftSession;
import ch.cyberduck.core.shared.OneTimeSchedulerFeature;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class SwiftDistributionConfigurationLoader
extends OneTimeSchedulerFeature<Map<Path, Distribution>> {
    private static final Logger log = Logger.getLogger(SwiftDistributionConfigurationLoader.class);
    private final SwiftSession session;

    public SwiftDistributionConfigurationLoader(SwiftSession session) {
        super(new Path(String.valueOf('/'), EnumSet.of(AbstractPath.Type.volume, AbstractPath.Type.directory)));
        this.session = session;
    }

    protected Map<Path, Distribution> operate(PasswordCallback callback, Path file) throws BackgroundException {
        DistributionConfiguration feature = (DistributionConfiguration)this.session.getFeature(DistributionConfiguration.class);
        if (null == feature) {
            return Collections.emptyMap();
        }
        AttributedList<Path> containers = new SwiftContainerListService(this.session, new SwiftLocationFeature.SwiftRegion(this.session.getHost().getRegion())).list(file, (ListProgressListener)new DisabledListProgressListener());
        ConcurrentHashMap<Path, Distribution> distributions = new ConcurrentHashMap<Path, Distribution>();
        for (Path container : containers) {
            for (Distribution.Method method : feature.getMethods(container)) {
                Distribution distribution = feature.read(container, method, (LoginCallback)new DisabledLoginCallback());
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Cache distribution %s", distribution));
                }
                distributions.put(container, distribution);
            }
        }
        return distributions;
    }
}

