/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.openstack;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.HashAlgorithm;
import ch.cyberduck.core.openstack.SwiftExceptionMappingService;
import ch.cyberduck.core.openstack.SwiftRegionService;
import ch.cyberduck.core.openstack.SwiftSegmentService;
import ch.cyberduck.core.openstack.SwiftSession;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.iterate.openstack.swift.Client;
import ch.iterate.openstack.swift.exception.GenericException;
import ch.iterate.openstack.swift.model.StorageObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SwiftLargeObjectCopyFeature
implements Copy {
    private final PathContainerService containerService = new PathContainerService();
    private final SwiftSession session;
    private final SwiftRegionService regionService;
    private final SwiftSegmentService segmentService;

    public SwiftLargeObjectCopyFeature(SwiftSession session) {
        this(session, new SwiftRegionService(session));
    }

    public SwiftLargeObjectCopyFeature(SwiftSession session, SwiftRegionService regionService) {
        this(session, regionService, new SwiftSegmentService(session));
    }

    public SwiftLargeObjectCopyFeature(SwiftSession session, SwiftRegionService regionService, SwiftSegmentService segmentService) {
        this.session = session;
        this.regionService = regionService;
        this.segmentService = segmentService;
    }

    public Path copy(Path source, Path target, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        return this.copy(source, this.segmentService.list(source), target, status, callback);
    }

    public boolean isRecursive(Path source, Path target) {
        return false;
    }

    public boolean isSupported(Path source, Path target) {
        return !this.containerService.isContainer(source) && !this.containerService.isContainer(target);
    }

    public Path copy(Path source, List<Path> sourceParts, Path target, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        ArrayList<Path> completed = new ArrayList<Path>();
        Path copySegmentsDirectory = this.segmentService.getSegmentsDirectory(target, status.getLength());
        for (Path path : sourceParts) {
            Path destination = new Path(copySegmentsDirectory, path.getName(), path.getType());
            try {
                ((Client)this.session.getClient()).copyObject(this.regionService.lookup(path), this.containerService.getContainer(path).getName(), this.containerService.getKey(path), this.containerService.getContainer(target).getName(), this.containerService.getKey(destination));
                destination.setAttributes(path.attributes());
                completed.add(destination);
            }
            catch (GenericException e) {
                throw new SwiftExceptionMappingService().map(e);
            }
            catch (IOException e) {
                throw new DefaultIOExceptionMappingService().map(e);
            }
        }
        ArrayList<StorageObject> manifestObjects = new ArrayList<StorageObject>();
        for (Path part : completed) {
            StorageObject model = new StorageObject(this.containerService.getKey(part));
            model.setSize(Long.valueOf(part.attributes().getSize()));
            model.setMd5sum(part.attributes().getChecksum().hash);
            manifestObjects.add(model);
        }
        String string = this.segmentService.manifest(this.containerService.getContainer(target).getName(), manifestObjects);
        StorageObject stored = new StorageObject(this.containerService.getKey(target));
        try {
            String checksum = ((Client)this.session.getClient()).createSLOManifestObject(this.regionService.lookup(this.containerService.getContainer(target)), this.containerService.getContainer(target).getName(), status.getMime(), this.containerService.getKey(target), string, Collections.emptyMap());
            stored.setMd5sum(checksum);
        }
        catch (GenericException e) {
            throw new SwiftExceptionMappingService().map(e);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
        PathAttributes attributes = new PathAttributes(source.attributes());
        attributes.setChecksum(new Checksum(HashAlgorithm.md5, stored.getMd5sum()));
        return new Path(target.getParent(), target.getName(), target.getType(), attributes);
    }
}

