/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.openstack;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.openstack.SwiftAttributesFinderFeature;
import ch.cyberduck.core.openstack.SwiftExceptionMappingService;
import ch.cyberduck.core.openstack.SwiftFindFeature;
import ch.cyberduck.core.openstack.SwiftRegionService;
import ch.cyberduck.core.openstack.SwiftSession;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.iterate.openstack.swift.Client;
import ch.iterate.openstack.swift.exception.GenericException;
import ch.iterate.openstack.swift.model.StorageObject;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class SwiftObjectListService
implements ListService {
    private static final Logger log = Logger.getLogger(SwiftObjectListService.class);
    private final SwiftSession session;
    private final PathContainerService containerService = new PathContainerService();
    private final SwiftRegionService regionService;
    private final SwiftAttributesFinderFeature attributes;

    public SwiftObjectListService(SwiftSession session) {
        this(session, new SwiftRegionService(session));
    }

    public SwiftObjectListService(SwiftSession session, SwiftRegionService regionService) {
        this.session = session;
        this.regionService = regionService;
        this.attributes = new SwiftAttributesFinderFeature(session, regionService);
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        try {
            List list;
            AttributedList children = new AttributedList();
            int limit = PreferencesFactory.get().getInteger("openstack.list.object.limit");
            String marker = null;
            Path container = this.containerService.getContainer(directory);
            do {
                list = ((Client)this.session.getClient()).listObjectsStartingWith(this.regionService.lookup(container), container.getName(), this.containerService.isContainer(directory) ? "" : this.containerService.getKey(directory) + '/', null, limit, marker, Character.valueOf('/'));
                for (StorageObject object : list) {
                    EnumSet<AbstractPath.Type> types;
                    PathAttributes attr = this.attributes.toAttributes(object);
                    EnumSet<AbstractPath.Type> enumSet = types = "application/directory".equals(object.getMimeType()) ? EnumSet.of(AbstractPath.Type.directory) : EnumSet.of(AbstractPath.Type.file);
                    if (StringUtils.endsWith((CharSequence)object.getName(), (CharSequence)String.valueOf('/')) && children.contains((Referenceable)new Path(directory, PathNormalizer.name((String)object.getName()), EnumSet.of(AbstractPath.Type.directory), attr))) continue;
                    attr.setOwner(container.attributes().getOwner());
                    attr.setRegion(container.attributes().getRegion());
                    children.add((Referenceable)new Path(directory, PathNormalizer.name((String)object.getName()), types, attr));
                    marker = object.getName();
                }
                listener.chunk(directory, children);
            } while (list.size() == limit);
            if (!this.containerService.isContainer(directory) && children.isEmpty() && !new SwiftFindFeature(this.session).find(directory)) {
                throw new NotfoundException(directory.getAbsolute());
            }
            return children;
        }
        catch (GenericException e) {
            throw new SwiftExceptionMappingService().map("Listing directory {0} failed", e, directory);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e, directory);
        }
    }
}

