/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk.crypto;

import com.dracoon.sdk.crypto.BadFileException;
import com.dracoon.sdk.crypto.CryptoSystemException;
import com.dracoon.sdk.crypto.FileCipher;
import com.dracoon.sdk.crypto.model.EncryptedDataContainer;
import com.dracoon.sdk.crypto.model.PlainDataContainer;
import com.dracoon.sdk.crypto.model.PlainFileKey;

public class FileDecryptionCipher
extends FileCipher {
    FileDecryptionCipher(PlainFileKey fileKey) throws CryptoSystemException {
        try {
            this.init(false, fileKey);
        }
        catch (IllegalArgumentException e) {
            throw new CryptoSystemException("Could not create decryption cipher.", e);
        }
    }

    public PlainDataContainer processBytes(EncryptedDataContainer encData) throws IllegalArgumentException, IllegalStateException, CryptoSystemException {
        byte[] pData;
        if (encData == null) {
            throw new IllegalArgumentException("Data container cannot be null.");
        }
        if (encData.getContent() == null) {
            throw new IllegalArgumentException("Data container content cannot be null.");
        }
        if (encData.getTag() != null) {
            throw new IllegalArgumentException("Data container tag must be null.");
        }
        try {
            pData = this.process(encData.getContent(), false);
        }
        catch (BadFileException e) {
            throw new CryptoSystemException("Could not decrypt file. Decryption failed.", e);
        }
        return new PlainDataContainer(pData);
    }

    public PlainDataContainer doFinal(EncryptedDataContainer encData) throws BadFileException, IllegalArgumentException, IllegalStateException, CryptoSystemException {
        if (encData == null) {
            throw new IllegalArgumentException("Data container cannot be null.");
        }
        if (encData.getContent() != null) {
            throw new IllegalArgumentException("Data container content must be null.");
        }
        if (encData.getTag() == null) {
            throw new IllegalArgumentException("Data container tag cannot be null.");
        }
        byte[] pData = this.process(encData.getTag(), true);
        return new PlainDataContainer(pData);
    }
}

