/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.hubic;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostKeyCallback;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.OAuthTokens;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.cdn.DistributionConfiguration;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.hubic.HubicAuthenticationRequest;
import ch.cyberduck.core.hubic.HubicAuthenticationResponseHandler;
import ch.cyberduck.core.oauth.OAuth2ErrorResponseInterceptor;
import ch.cyberduck.core.oauth.OAuth2RequestInterceptor;
import ch.cyberduck.core.openstack.SwiftExceptionMappingService;
import ch.cyberduck.core.openstack.SwiftSession;
import ch.cyberduck.core.proxy.Proxy;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import ch.cyberduck.core.threading.CancelCallback;
import ch.iterate.openstack.swift.Client;
import ch.iterate.openstack.swift.exception.GenericException;
import ch.iterate.openstack.swift.method.AuthenticationRequest;
import java.io.IOException;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.log4j.Logger;

public class HubicSession
extends SwiftSession {
    private static final Logger log = Logger.getLogger(HubicSession.class);
    private OAuth2RequestInterceptor authorizationService;

    public HubicSession(Host host, X509TrustManager trust, X509KeyManager key) {
        super(host, trust, key);
    }

    public Client connect(Proxy proxy, HostKeyCallback key, LoginCallback prompt) {
        HttpClientBuilder configuration = this.builder.build(proxy, (TranscriptListener)this, prompt);
        this.authorizationService = new OAuth2RequestInterceptor((HttpClient)configuration.build(), this.host.getProtocol()).withRedirectUri(this.host.getProtocol().getOAuthRedirectUrl());
        configuration.addInterceptorLast((HttpRequestInterceptor)this.authorizationService);
        configuration.setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)new OAuth2ErrorResponseInterceptor(this.host, this.authorizationService, prompt));
        return new Client(configuration.build());
    }

    public void login(Proxy proxy, LoginCallback prompt, CancelCallback cancel) throws BackgroundException {
        OAuthTokens tokens = this.authorizationService.authorize(this.host, prompt, cancel);
        try {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Attempt authentication with %s", tokens));
            }
            ((Client)this.client).authenticate((AuthenticationRequest)new HubicAuthenticationRequest(tokens.getAccessToken()), (ResponseHandler)new HubicAuthenticationResponseHandler());
        }
        catch (GenericException e) {
            throw new SwiftExceptionMappingService().map(e);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    public <T> T _getFeature(Class<T> type) {
        if (type == DistributionConfiguration.class) {
            return null;
        }
        return (T)super._getFeature(type);
    }
}

