/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cryptomator;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;

public class ContentReader {
    private final Session<?> session;

    public ContentReader(Session<?> session) {
        this.session = session;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String read(Path file) throws BackgroundException {
        Read read = (Read)this.session._getFeature(Read.class);
        try (InputStream in = read.read(file, new TransferStatus(), (ConnectionCallback)new DisabledConnectionCallback());){
            String string = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
            return string;
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }
}

