/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cryptomator.features;

import ch.cyberduck.core.Archive;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Compress;
import ch.cyberduck.core.features.Vault;
import java.util.ArrayList;
import java.util.List;

public class CryptoCompressFeature
implements Compress {
    private final Session<?> session;
    private final Compress delegate;
    private final Vault vault;

    public CryptoCompressFeature(Session<?> session, Compress delegate, Vault vault) {
        this.session = session;
        this.delegate = delegate;
        this.vault = vault;
    }

    public void archive(Archive archive, Path workdir, List<Path> files, ProgressListener listener, TranscriptListener transcript) throws BackgroundException {
        ArrayList<Path> encrypted = new ArrayList<Path>();
        for (Path f : files) {
            encrypted.add(this.vault.encrypt(this.session, f));
        }
        this.delegate.archive(archive, this.vault.encrypt(this.session, workdir), encrypted, listener, transcript);
    }

    public void unarchive(Archive archive, Path file, ProgressListener listener, TranscriptListener transcript) throws BackgroundException {
        this.delegate.unarchive(archive, this.vault.encrypt(this.session, file), listener, transcript);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CryptoCompressFeature{");
        sb.append("delegate=").append(this.delegate);
        sb.append('}');
        return sb.toString();
    }
}

