/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ftp;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.ftp.FTPClient;
import ch.cyberduck.core.ftp.FTPException;
import ch.cyberduck.core.ftp.FTPExceptionMappingService;
import ch.cyberduck.core.ftp.FTPSession;
import ch.cyberduck.core.shared.DefaultHomeFinderService;
import java.io.IOException;
import java.util.EnumSet;

public class FTPWorkdirService
extends DefaultHomeFinderService {
    private final FTPSession session;

    public FTPWorkdirService(FTPSession session) {
        super((Session)session);
        this.session = session;
    }

    public Path find() throws BackgroundException {
        Path home = super.find();
        if (home == this.DEFAULT_HOME) {
            try {
                String directory = ((FTPClient)((Object)this.session.getClient())).printWorkingDirectory();
                if (null == directory) {
                    throw new FTPException(((FTPClient)((Object)this.session.getClient())).getReplyCode(), ((FTPClient)((Object)this.session.getClient())).getReplyString());
                }
                return new Path(PathNormalizer.normalize((String)directory), directory.equals(String.valueOf('/')) ? EnumSet.of(AbstractPath.Type.volume, AbstractPath.Type.directory) : EnumSet.of(AbstractPath.Type.directory));
            }
            catch (IOException e) {
                throw new FTPExceptionMappingService().map(e);
            }
        }
        return home;
    }
}

