/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ftp.parser;

import ch.cyberduck.core.Permission;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPFileEntryParserImpl;

public class EPLFFTPEntryParser
extends FTPFileEntryParserImpl {
    public FTPFile parseFTPEntry(String entry) {
        int i;
        FTPFile file = new FTPFile();
        file.setRawListing(entry);
        if (!entry.startsWith("+")) {
            return null;
        }
        int indexOfTab = entry.indexOf(9);
        if (indexOfTab == -1) {
            return null;
        }
        int startName = indexOfTab + 1;
        String name = entry.substring(startName);
        if (name.endsWith("\r\n")) {
            i = name.lastIndexOf("\r\n");
            name = name.substring(0, i);
        }
        if (StringUtils.isBlank((CharSequence)name) || name.equals(".") || name.equals("..")) {
            return null;
        }
        file.setName(name);
        int endFacts = startName - 2;
        EPLFEntryParserContext factContext = new EPLFEntryParserContext(file);
        for (i = 1; i < endFacts; ++i) {
            int factEnd = entry.indexOf(44, i);
            String fact = entry.substring(i, factEnd);
            factContext.handleFact(fact);
            i = factEnd;
        }
        factContext.conclude();
        if (!factContext.hasMayBeRetreivedFact() && !factContext.hasMayCWDToFact()) {
            return null;
        }
        return file;
    }

    private static class EPLFEntryParserContext {
        private final Map<String, String> facts = new HashMap<String, String>();
        private FTPFile file;

        public EPLFEntryParserContext(FTPFile f) {
            this.file = f;
        }

        protected boolean hasSpecifiedPermissionsFact() {
            return this.hasFact("up");
        }

        protected boolean hasMayBeRetreivedFact() {
            return this.hasFact("r");
        }

        protected boolean hasMayCWDToFact() {
            return this.hasFact("/");
        }

        private boolean hasFact(String factId) {
            return this.facts.containsKey(factId);
        }

        protected void handleFact(String fact) {
            if (fact.length() == 0) {
                return;
            }
            if (fact.charAt(0) == 'r') {
                this.facts.put("r", "");
                return;
            }
            if (fact.charAt(0) == '/') {
                this.facts.put("/", "");
                return;
            }
            if (fact.startsWith("up")) {
                this.facts.put("up", fact.substring(2));
                return;
            }
            if (fact.charAt(0) == 's') {
                String sizeString = fact.substring(1);
                this.facts.put("s", sizeString);
                try {
                    this.file.setSize(Long.parseLong(sizeString));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                return;
            }
            if (fact.charAt(0) == 'm') {
                String timeString = fact.substring(1);
                this.facts.put("m", timeString);
                try {
                    long secsSince1970 = Long.parseLong(timeString);
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTimeInMillis(secsSince1970 * 1000L);
                    this.file.setTimestamp(calendar);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        protected void conclude() {
            if (this.hasMayCWDToFact()) {
                this.file.setType(1);
            } else if (this.hasMayBeRetreivedFact()) {
                this.file.setType(0);
            }
            if (this.hasSpecifiedPermissionsFact()) {
                this.createAndSetSpecifiedPermission();
            }
        }

        private void createAndSetSpecifiedPermission() {
            Permission newPermission = this.createSpecifiedPermission();
            if (newPermission != null) {
                this.file.setPermission(0, 0, newPermission.getUser().implies(Permission.Action.read));
                this.file.setPermission(0, 1, newPermission.getUser().implies(Permission.Action.write));
                this.file.setPermission(0, 2, newPermission.getUser().implies(Permission.Action.execute));
                this.file.setPermission(1, 0, newPermission.getUser().implies(Permission.Action.read));
                this.file.setPermission(1, 1, newPermission.getUser().implies(Permission.Action.write));
                this.file.setPermission(1, 2, newPermission.getUser().implies(Permission.Action.execute));
                this.file.setPermission(2, 0, newPermission.getUser().implies(Permission.Action.read));
                this.file.setPermission(2, 1, newPermission.getUser().implies(Permission.Action.write));
                this.file.setPermission(2, 2, newPermission.getUser().implies(Permission.Action.execute));
            }
        }

        private Permission createSpecifiedPermission() {
            try {
                int perm = Integer.valueOf(this.facts.get("up"), 8);
                return new Permission(perm);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
    }
}

