-------------------------------------------------------------------------------------------------------------------------------
-- Mod expansion and additional coding by anygoodname by keanuWheeze consent.
-- This mod shall not be redistributed or modified/renamed/rebranded and published as a separate mod without keanuWheeze and anygoodname permission.
-- To use code snippets from this mod in other mods requires a consent and a proper credit note.

--[[ DISCLAIMER:

This mod is a non-commercial fan creation intended for personal use only.

By using the word "republish" I mean both republish and redistribute in this disclaimer:
You're not allowed to republish the mod without my consent or against the Nexusmods rules.
You're not allowed to republish parts of this mod code or files without consent. Either mine either other authors.
You can modify the mod code or files for your personal use only.
By modifying the mod code or files, you acknowledge I cannot support the modified mod code or files.
You're not allowed to publish your modifications to the mod code or files without my consent.
You're not allowed to publicly propose unauthorized changes to the mod code or files.
You're not allowed to use any part of the mod code or files for commercial purposes, advertising or promotion of any kind.
You can use the mod code and files to learn how to code this game mods and improve your skills.
You can use parts the code or file modifications in your creations only by my consent and on a credit note.
You're not allowed to use parts of the code or files marked as coming from other people without their consent.
You can create and publish translations of the parts of the mod that are explicitly marked as allowed to translate either in the mod description either in the mod files.
The translations must follow the Nexusmods translation publishing rules.
]]--

-- THIS MODULE DOES NOT SUPPORT TRANSLATIONS IN IT'S CURRENT SHAPE

-- Oct 9, 2024 based on the (c)keanuWheeze original script modified by (c)anygoodname by the keanuWheeze consent
-- Uses (c)psiberx code snippets and libraries on his license.


logic = {
			modVer = 'v3.5.6',
			moduleVer = 'v3.5.6',
			modName = 'Autoloot',
			modAuthorName = 'keanuWheeze and anygoodname',
			lastLootCompletedTime = 0,
			isPlayerInWorkspot = false, isLootDialogOnScreen = false, isAnyDialogOnScreen = false, isAnyOtherInteractonOnScreen = false, cooldown = 0,
			isInitialized = false,
		}

local Ref = require('lib/Ref')
if not Ref then return end
local journalMappinExtractor = require('lib/journalMappinExtractor')
if not journalMappinExtractor then return end

local lastLootingController, isLootDialogOnScreen, isAnyDialogOnScreen, isAnyOtherInteractonOnScreen, cooldown
local lastPhoneMessagePopupGameController, lastLoadingScreenProgressBarController, lastTutorialMainController = nil, nil, nil
local lastInteractionUIBase = nil
local lastCursorDeviceGameController, lastTerminalInteractionActive = nil, false
local objectMappins = {}
local objectMappinsCount = 0
local worldMappins = {}
local allJournalQuestEntries = {}
local customLootMappins = {}
local protectedSpecialItems = {}
local protectedNpcs
local collectedPoiMappins = nil
local lastDialogWidgetGameController = nil
local isGameV2 = false
local protectKeyCards = true
local questsSystem = nil
local n, t
local journalManager, workspotSystem, transactionSystem, gameBlackBoardSystem, allBlackboardDefs, targetingSystem, cameraSystem, spatialQueriesSystem
local lootableClasses
local ScriptedPuppet = "ScriptedPuppet"
local UI_Slots = "UI_Slots"
local lootResult = {
	generalFailure = -4,
	allItemsFailed = -3,
	notLootObject = -2,
	protectedObject = -1,
	nothingToLoot = 0,
	partialLoot = 1,
	allLooted = 2
	}

function logic.init()
	if logic.isInitialized then return end
	n = CName
	t = TweakDBID
	questsSystem = Ref.Weak(Game.GetQuestsSystem())
	journalManager = Ref.Weak(Game.GetJournalManager())
	workspotSystem = Ref.Weak(Game.GetWorkspotSystem())
	transactionSystem = Ref.Weak(Game.GetTransactionSystem())
	gameBlackBoardSystem = Ref.Weak(Game.GetBlackboardSystem())
	allBlackboardDefs = Ref.Weak(Game.GetAllBlackboardDefs())
	targetingSystem = Ref.Weak(Game.GetTargetingSystem())
	cameraSystem = Ref.Weak(Game.GetCameraSystem())
	spatialQueriesSystem = Ref.Weak(Game.GetSpatialQueriesSystem())
	ScriptedPuppet = n"ScriptedPuppet"
	UI_Slots = n"UI_Slots"
	for i = 1, #lootableClasses do lootableClasses[i] = CName.new(lootableClasses[i]) end
	logic.resetVariables()
	logic.setObservers()
	if journalMappinExtractor then journalMappinExtractor.init() end
	logic.isInitialized = true
end

function logic.resetVariables()
	lastLootingController = nil
	logic.isPlayerInWorkspot = false
	logic.isLootDialogOnScreen = false
	logic.isAnyDialogOnScreen = false
	logic.isAnyOtherInteractonOnScreen = false
	logic.cooldown = 0
	objectMappins = {}
	objectMappinsCount = 0
	allJournalQuestEntries = {}
	customLootMappins = {}
	collectedPoiMappins = nil
	lastCursorDeviceGameController = nil
	lastTerminalInteractionActive = false
end

function logic.isInSettingsMenu()
	if not GetPlayer then return end
	local result, blackboardSystem = pcall(function() return gameBlackBoardSystem:Get(allBlackboardDefs.UI_System) end)
	if not result then return true end
	if not IsDefinedS(blackboardSystem) then return true end
	if not blackboardSystem:GetBool(allBlackboardDefs.UI_System.IsInMenu) then return end
	return logic.isMenuScenario_Settings
end

function logic.setObservers()
	if logic.isInitialized then return end
	isGameV2 = tonumber(Game.GetSystemRequestsHandler():GetGameVersion()) >= 2

	ObserveAfter('inkMenuScenario', 'SwitchToScenario', function(this, name)
		logic.isMenuScenario_Settings = false
		if name.value == 'MenuScenario_Settings' then logic.isMenuScenario_Settings = true end
	end)

	if isGameV2 then
		ObserveAfter("WorldMappinsContainerController", "CreateMappinUIProfile", function(this, mappin, mappinVariant, customData);
			local shouldRegisterMappin = mappin:IsQuestMappin()
				or mappin:IsQuestImportant()
				or mappinVariant == gamedataMappinVariant.FocusClueVariant
				or mappinVariant == gamedataMappinVariant.HiddenStashVariant
				or mappinVariant == gamedataMappinVariant.ImportantInteractionVariant
				or mappinVariant == gamedataMappinVariant.MinorActivityVariant
				or mappinVariant == gamedataMappinVariant.Zzz07_PlayerStashVariant
				or mappinVariant == gamedataMappinVariant.Zzz08_WardrobeVariant
				or mappinVariant == gamedataMappinVariant.Zzz12_WorldEncounterVariant;

			if not shouldRegisterMappin then return end;
			local position = mappin:GetWorldPosition();
			if position:IsZero() then return end
			local mappinId = tostring(position.x)..tostring(position.y)..tostring(position.z);
			if not collectedPoiMappins then collectedPoiMappins = {} end
			collectedPoiMappins[mappinId] = {mappin = mappin, position = position, mappinVariant = mappinVariant};
		end);
	end

	Observe('LoadingScreenProgressBarController', 'SetProgress', function(self) lastLoadingScreenProgressBarController = Ref.Weak(self) end)
	Observe('TutorialMainController', 'OnInitialize', function(self) lastTutorialMainController = Ref.Weak(self) end)
	Observe('TutorialMainController', 'StartTutorial', function(self) lastTutorialMainController = Ref.Weak(self) end)
	Observe('TutorialMainController', 'UpdateTutorialStep', function(self) lastTutorialMainController = Ref.Weak(self) end)

	if modAutolootRedsHelper then
		local isSupportedVersion = false
		if type(modAutolootRedsHelper.GetVersion) == 'function' then
			local helperVerStr = modAutolootRedsHelper.GetVersion()
			if type(helperVerStr) == 'string' then
				local helperVer = tonumber((helperVerStr:gsub('^(%d+)%.(%d+)%.(%d+)(.*)', function(major, minor, patch, wip) -- based on psiberx code
					return ('%d.%02d%02d%d'):format(major, minor, patch, (wip == '' and 0 or 1))
				end)))
				if helperVer >= 3.0117 then
					logic.shouldUseRedsHelper = true
					isSupportedVersion = true
					print(logic.modName, logic.modVer, 'Redscript helper plug-in found:', helperVerStr)
				else
					print(logic.modName, logic.modVer, 'Outdated redscript helper plug-in version found:', helperVerStr, 'The plugin will not be used.')
				end
			else
				print(logic.modName, logic.modVer, 'Unknown redscript helper plug-in found. The plugin will not be used.')
			end
		else
			print(logic.modName, logic.modVer, 'Outdated redscript helper plug-in found. The plugin will not be used.')
		end
		local cetVer = tonumber((GetVersion():gsub('^v(%d+)%.(%d+)%.(%d+)(.*)', function(major, minor, patch, wip) -- (c)psiberx
			return ('%d.%02d%02d%d'):format(major, minor, patch, (wip == '' and 0 or 1))
		end)))
		if cetVer >= 1.21 then
			logic.shouldUseRedsHelper = false
			if not isSupportedVersion then
				print(logic.modName, logic.modVer, 'The redscript helper plug-in is no longer needed in this game version so you can ignore the plug-in warning.')
			else
				print(logic.modName, logic.modVer, 'The redscript helper plug-in will not be used as it is no longer needed in this game version.')
			end
		end
	end

	if logic.shouldUseRedsHelper then
		Observe('modAutolootRedsHelper', 'LastPhoneMessagePopupGameController;PhoneMessagePopupGameController', function(this)
			if IsDefinedS(self) then lastPhoneMessagePopupGameController = Ref.Weak(this) end
		end)

		Observe('modAutolootRedsHelper', 'LastDialogWidgetGameController;dialogWidgetGameControllerInt32', function(this, hubsCount)
			lastDialogWidgetGameController = Ref.Weak(this)
			logic.isAnyDialogOnScreen = hubsCount > 0
			if hubsCount < 1 then
				logic.lastHubCountReset = os.clock()
			end
		end)

		Observe('modAutolootRedsHelper', 'LastInteractionUIBase;InteractionUIBase', function(this)
			lastInteractionUIBase = Ref.Weak(this)
		end)

		Observe('modAutolootRedsHelper', 'LastCursorDeviceGameController;cursorDeviceGameControllerVariant', function(this, value)
			lastCursorDeviceGameController = Ref.Weak(this)
			local v = FromVariant(value)
			if not v then lastTerminalInteractionActive = false return end
			lastTerminalInteractionActive = v.terminalInteractionActive
			logic.isNativeHubLeftoverActive = false
		end)

		Observe('modAutolootRedsHelper', 'LastLootingController;LootingControllerBool', function(this, isShow)
			lastLootingController = Ref.Weak(this)
			logic.isLootDialogOnScreen = isShow
			if isShow then logic.isNativeHubLeftoverActive = false end
		end)

		Observe('modAutolootRedsHelper', 'AddToObjectMappins;GameObjectIScriptableBool', function(owner, mappinObjectRef, forceNew)
			addToObjectMappins(Ref.Weak(owner), Ref.Weak(mappinObjectRef), forceNew)
		end)
	else
		Observe('PhoneMessagePopupGameController', 'OnInitialize', function(self) if IsDefinedS(self) then lastPhoneMessagePopupGameController = Ref.Weak(self) end end)

		ObserveAfter("dialogWidgetGameController", "OnDialogsActivateHub", function(this);
			lastDialogWidgetGameController = Ref.Weak(this)
			logic.isAnyDialogOnScreen = this.hubAvailable
			if not this.hubAvailable then logic.lastHubCountReset = os.clock() end
		end);

		Observe('dialogWidgetGameController', 'AdjustHubsCount', function(this, evt)
			lastDialogWidgetGameController = Ref.Weak(this)
			logic.isAnyDialogOnScreen = evt > 0
			if evt < 1 then logic.lastHubCountReset = os.clock() end
		end)

		ObserveAfter('InteractionUIBase', 'OnInitialize', function(self);
			lastInteractionUIBase = Ref.Weak(self)
		end)

		ObserveAfter('InteractionUIBase', 'OnDialogsActivateHub', function(self);
			lastInteractionUIBase = Ref.Weak(self)
		end)

		Observe('cursorDeviceGameController', 'OnInteractionStateChange', function(this, value)
			lastCursorDeviceGameController = Ref.Weak(this)
			local v = FromVariant(value)
			if not v then lastTerminalInteractionActive = false return end
			lastTerminalInteractionActive = v.terminalInteractionActive
			logic.isNativeHubLeftoverActive = false
		end)

		Observe('LootingController', 'Show', function(self)
			lastLootingController = Ref.Weak(self)
			logic.isLootDialogOnScreen = true
			logic.isNativeHubLeftoverActive = false
		end)

		Observe('LootingController', 'Hide', function(self)
			logic.isLootDialogOnScreen = false
			lastLootingController = Ref.Weak(self)
		end)

		ObserveAfter('gameItemDropObject', 'OnItemEntitySpawned', function(self)
			addToObjectMappins(Ref.Weak(self), nil)
		end)

		Observe('GameplayRoleComponent', 'CreateRoleMappinData', function(self)
			local owner = Ref.Weak(self:GetOwner())
			addToObjectMappins(owner, Ref.Weak(self), true)
		end)

		ObserveAfter('GameplayRoleComponent', 'OnLogicReady', function(self)
			local owner = Ref.Weak(self:GetOwner())
			addToObjectMappins(owner, Ref.Weak(self))
		end)

		Observe('GameplayRoleComponent', 'ShowRoleMappinsByTask', function(self)
			local owner = Ref.Weak(self:GetOwner())
			addToObjectMappins(owner, Ref.Weak(self))
		end)

		ObserveAfter('GameplayRoleComponent', 'ShowRoleMappins', function(self)
			local owner = Ref.Weak(self:GetOwner())
			addToObjectMappins(owner, Ref.Weak(self))
		end)

		Observe('GameplayRoleComponent', 'SetForceHidden', function(self, isHidden)
			local owner = Ref.Weak(self:GetOwner())
			addToObjectMappins(owner, Ref.Weak(self), (self.isForceHidden and not isHidden))
		end)

		ObserveAfter('GameplayRoleComponent', 'OnGameAttach', function(self)
			local owner = Ref.Weak(self:GetOwner())
			addToObjectMappins(owner, Ref.Weak(self), true)
		end)

		ObserveAfter('GameplayRoleComponent', 'OnHUDInstruction', function(self)
			local owner = Ref.Weak(self:GetOwner())
			addToObjectMappins(owner, Ref.Weak(self), true)
		end)
	end

	ObserveAfter("gameLootContainerBase", "OnInventoryFilledEvent", function(this)
		if not this:IsA("gameLootContainerBase") then return end;
		addToObjectMappins(Ref.Weak(this), this:FindComponentByName("GameplayRole"))
	end);
	ObserveAfter("gameLootContainerBase", "OnInventoryChangedEvent", function(this)
		if not this:IsA("gameLootContainerBase") then return end;
		addToObjectMappins(Ref.Weak(this), this:FindComponentByName("GameplayRole"))
	end);

	Observe('gameInventoryScriptCallback', 'OnItemAdded', function()
		if not logic.isLootingTime() then return end
		hideLootMarkers()
	end)

	local lookForLeftovers = true
	Observe('PlayerPuppet', 'OnGameAttached', function(self)
		if self:IsReplacer() then return end
		questsSystem = Ref.Weak(Game.GetQuestsSystem())
		journalManager = Ref.Weak(Game.GetJournalManager())
		workspotSystem = Ref.Weak(Game.GetWorkspotSystem())
		transactionSystem = Ref.Weak(Game.GetTransactionSystem())
		gameBlackBoardSystem = Ref.Weak(Game.GetBlackboardSystem())
		allBlackboardDefs = Ref.Weak(Game.GetAllBlackboardDefs())
		targetingSystem = Ref.Weak(Game.GetTargetingSystem())
		cameraSystem = Ref.Weak(Game.GetCameraSystem())
		spatialQueriesSystem = Ref.Weak(Game.GetSpatialQueriesSystem())
		if logic.settings and type(logic.config) == 'table' and type(logic.config.loadConfig) == 'function' then
			local newSettings = logic.config.loadConfig("config/config.json", logic.settings)
			if type(newSettings) == 'table' then
				for k, v in pairs(newSettings) do logic.settings[k] = v end
			end
		end
		logic.isNativeHubLeftoverActive = false
		lookForLeftovers = true
		if logic.resetAutoLootStates then logic.resetAutoLootStates() end
		logic.resetVariables()
	end)

	Observe('PlayerPuppet', 'OnMakePlayerVisibleAfterSpawn', function (this)
		lookForLeftovers = false
	end)

	Observe('interactionWidgetGameController', 'OnUpdateInteraction', function(this, argValue);
		if not lookForLeftovers then return end
		if not this.root then return end;
		local data = FromVariant(argValue);
		if not data.active then return end;
		logic.isNativeHubLeftoverActive = true
		lookForLeftovers = false
	end)
	
	ObserveAfter('InteractionUIBase', 'OnInteractionData', function(this)
		lastInteractionUIBase = Ref.Weak(this)
		logic.isNativeHubLeftoverActive = false
	end)

	protectedSpecialItems = {
		{position = Vector4.new(-1741.0364, -2352.3066, 32.136505, 1)},
		{position = Vector4.new(-2034.3328, -2735.4219, 36.66288, 1)},
		{position = Vector4.new(-1394.0176, -2036.0061, 75.7336, 1)},
		{position = Vector4.new(-1434.1599, -2030.45, 74.83998, 1)},
		{position = Vector4.new(-1397.3597, -2014.2797, 72.139984, 1)},
		{position = Vector4.new(-1417.3597, -2081.31, 72.14998, 1)},
		{position = Vector4.new(-1372.9598, -1932.09, 71.11998, 1)},
		{position = Vector4.new(-2412.8733, -2662.6848, 13.127945, 1), factName = CName.new(3795274209, 739829857)},
		{position = Vector4.new(-2413.4795, -2661.944, 12.942177, 1), factName = CName.new(3795274209, 739829857)},
		{position = Vector4.new(-2413.816, -2661.3318, 12.942177, 1), factName = CName.new(3795274209, 739829857)},
		{position = Vector4.new(-2413.4268, -2661.377, 13.230896, 1), factName = CName.new(3795274209, 739829857)},
		{position = Vector4.new(-2413.1953, -2661.8281, 13.237434, 1), factName = CName.new(3795274209, 739829857)},
		{position = Vector4.new(-2417.722, -2659.966, 13.014374, 1), factName = CName.new(3795274209, 739829857)},
		{position = Vector4.new(-2418.1, -2659.8289, 13.286064, 1), factName = CName.new(3795274209, 739829857)},
		{position = Vector4.new(-2420.0388, -2664.5303, 11.776367, 1), factName = CName.new(3795274209, 739829857)},
		{position = Vector4.new(-2417.5742, -2659.9058, 12.392654, 1), factName = CName.new(3795274209, 739829857)},
		{position = Vector4.new(-478.33173, 406.93695, 132.11, 1)},
		{id = TweakDBID.new(1592060811, 30)},
		{id = TweakDBID.new(878607196, 18)},
		{id = TweakDBID.new(2017263017, 19)},
		{id = TweakDBID.new(893995339, 41)},
	}
	protectedNpcs = {
		{ownerId = TweakDBID.new(559568892, 17)},
		{ownerId = TweakDBID.new(2793039571, 32)},
		{ownerId = TweakDBID.new(1119903596, 22)},
		{ownerId = TweakDBID.new(1878025896, 27)},
		{ownerId = TweakDBID.new(2045015319, 15)},
		{ownerId = TweakDBID.new(3444547383, 25)},
		{ownerId = TweakDBID.new(2424102690, 35)},
		{ownerId = TweakDBID.new(1136692099, 25)},
	}
end

lootableClasses = {
	"gameLootContainerBase",
	"gameLootObject",
	"gameLootBag",
	"gameweaponObject",
	"NPCPuppet",
}
local lootableClassesCount = #lootableClasses

function addToObjectMappins(owner, mappinObjectRef, forceNew)
	if type(owner) ~= 'userdata' then return end
	if not owner.GetEntityID then return end
	local isAccepted = false
	for i = 1, lootableClassesCount do
		if owner:IsA(lootableClasses[i]) then isAccepted = true break end
	end
	if not isAccepted then return end
	local ownerHash = owner:GetEntityID().hash
	if ownerHash == 1ULL then return end
	local ownerHashStr = tostring(ownerHash)
	if not objectMappins[ownerHashStr] then
		objectMappinsCount = objectMappinsCount + 1
		objectMappins[ownerHashStr] = {isNew = true, mappinObjectRef = mappinObjectRef}
	else
		if forceNew then
			objectMappins[ownerHashStr] = {isNew = true, mappinObjectRef = mappinObjectRef}
		else
			if mappinObjectRef then objectMappins[ownerHashStr].mappinObjectRef = mappinObjectRef end
		end
	end
end

function hideLootMarkers()
	for ownerHashStr, mappinRec in pairs(customLootMappins) do
		if mappinRec.isLootOn then
			local mappinObjectRef = mappinRec.mappin.mappinObjectRef
			if mappinObjectRef and IsDefined(mappinObjectRef) then
				local mappins = mappinObjectRef.mappins
				if mappins and #mappins > 0 then
					local owner = findEntityByIDHashStr(ownerHashStr)
					if owner and owner:IsA('NPCPuppet') then
						local hideLootMappin = false
						local result, items = transactionSystem:GetItemList(owner)
						if result and items then hideLootMappin = #items == 0 end
						if hideLootMappin then
							for i = #mappins, 1, -1 do
								if mappins[i].mappinVariant == gamedataMappinVariant.LootVariant then
									mappinObjectRef:HideRoleMappins()
									mappinRec.isLootOn = false
									break
								end
							end
						end
					end
				end
			end
		end
	end
end

local searchQuery
function logic.lootInRange(range, lootInView, lootVisible, audioFeedback)
	if not logic.isLootingTime() then return end
	if not range then range = 20 end
	if type(range) ~= 'number' then range = 20 end
	local lootInRange = range > 0
	local forceShard = true
	if not lootInRange then range = 10000 end
	lootInView = true
	local objectsProcessed = {}

	local player = GetPlayer()
	local gameObj = nil
	local isAnythingLooted = false
	local result, items = false, nil

	local rangeSquared = range * range
	local playerPos = player:GetWorldPosition()

	if objectMappinsCount > 0 then
		for ownerHashStr, mappin in pairs(objectMappins) do
			if mappin and mappin.isNew then
				gameObj = findEntityByIDHashStr(ownerHashStr)
				if isObjectOfInterest(gameObj) then
					if isNpcSafeToLoot(gameObj) then
						local hasItemsToLoot, objectHasLootItems, ownerHasLootItems = false, false, false
						result, items = transactionSystem:GetItemList(gameObj)
						if result then if items then if #items > 0 then hasItemsToLoot = true objectHasLootItems = true end end end
						local gameObjOwner = nil
						result = false
						pcall(function() gameObjOwner = gameObj:GetOwner() end)
						if gameObjOwner then result, items = transactionSystem:GetItemList(gameObjOwner) end
						if result then if items then if #items > 0 then hasItemsToLoot = true ownerHasLootItems = true end end end
						if hasItemsToLoot then
							local takeIt = true
							if lootInRange then
								local gameObjPos = gameObj:GetWorldPosition()
								takeIt = Vector4.DistanceSquared(playerPos, gameObjPos) <= rangeSquared
							end
							if takeIt then
								if lootInView then takeIt = cameraSystem:IsInCameraFrustum(gameObj, 0.5, 0.2) end
								if takeIt then
									if lootVisible then takeIt = isObjectVisibleToPlayer(gameObj, player, true) end
									if takeIt then
										local lootStep1Result, lootStep2Result = lootResult.nothingToLoot, lootResult.nothingToLoot
										if objectHasLootItems then
											result = lootObjectItems(gameObj, forceShard, true)
											objectsProcessed[tostring(gameObj:GetEntityID().hash)] = true
											lootStep1Result = result
											if result > lootResult.nothingToLoot then
												isAnythingLooted = true
											end
										end

										if ownerHasLootItems then
											if gameObjOwner then
												gameObj = gameObjOwner
												result = lootObjectItems(gameObj, forceShard, false)
												objectsProcessed[tostring(gameObj:GetEntityID().hash)] = true
												lootStep2Result = result
												if result > lootResult.nothingToLoot then
													isAnythingLooted = true
												end
											end
										end

										local shouldSetMarker = false
										if lootStep1Result == lootResult.allItemsFailed or lootStep1Result == lootResult.protectedObject or lootStep1Result == lootResult.partialLoot then shouldSetMarker = true end
										if not shouldSetMarker then
											if lootStep2Result == lootResult.allItemsFailed or lootStep2Result == lootResult.protectedObject or lootStep2Result == lootResult.partialLoot then shouldSetMarker = true end
										end
										if shouldSetMarker then
											if gameObj:IsA('NPCPuppet') then
												mappin.mappinObjectRef:ShowRoleMappins()
												customLootMappins[ownerHashStr] = {mappin = mappin, isLootOn = true}
											end
										end
									end
								end
							end
						end
					end
				else
					mappin.isNew = false
				end
			end
		end
	end

	local gameObjEntityIdHashStr = ''
	if not searchQuery then
		searchQuery = TSQ_ALL()
		searchQuery.testedSet = gameTargetingSet.Visible
		searchQuery.includeSecondaryTargets = false
		searchQuery.ignoreInstigator = true
	end
	searchQuery.maxDistance = range

	gameObj = targetingSystem:GetLookAtObject(player, false, false)
	if gameObj then
		local gameObjEntIdHash = gameObj:GetEntityID().hash
		gameObjEntityIdHashStr = tostring(gameObjEntIdHash)

		if objectsProcessed[gameObjEntityIdHashStr] then
			result = 0
		else
			local takeIt = true
			if lootInRange then
				local gameObjPos = gameObj:GetWorldPosition()
				takeIt = Vector4.DistanceSquared(playerPos, gameObjPos) <= rangeSquared
			end
			if takeIt then
				if isObjectLootable(gameObj, gameObjEntityIdHashStr, true) then
					result = lootObjectItems(gameObj, forceShard, false)
					objectsProcessed[gameObjEntityIdHashStr] = true
					if result > lootResult.nothingToLoot then
						isAnythingLooted = true
					else
						local owner = nil
						pcall(function() owner = gameObj:GetOwner() end)
						if owner then
							local ownerEntIdHash = owner:GetEntityID().hash
							gameObjEntityIdHashStr = tostring(ownerEntIdHash)
							if not objectsProcessed[gameObjEntityIdHashStr] then
								if not string.find(owner:ToString(), 'gameLootSlot') then
									if gameObjEntIdHash ~= ownerEntIdHash then
										result = lootObjectItems(owner, forceShard, false)
										objectsProcessed[gameObjEntityIdHashStr] = true
										if result > lootResult.nothingToLoot then
											isAnythingLooted = true
										end
									end
								end
							end
						end
					end
				else
					objectsProcessed[gameObjEntityIdHashStr] = true
				end
			end
		end
	end

	local sr, objects = targetingSystem:GetTargetParts(player, searchQuery)
	for _, v in ipairs(objects) do
		gameObj = v:GetComponent(v):GetEntity()
		local gameObjEntIdHash = gameObj:GetEntityID().hash
		gameObjEntityIdHash = tostring(gameObjEntIdHash)
		if objectsProcessed[gameObjEntityIdHashStr] then
			result = 0
		else
			local takeIt = true
			if lootInRange then
				local gameObjPos = gameObj:GetWorldPosition()
				takeIt = Vector4.DistanceSquared(playerPos, gameObjPos) <= rangeSquared
			end
			if takeIt then
				if isObjectLootable(gameObj, gameObjEntityIdHashStr, true) then
					result = lootObjectItems(gameObj, forceShard, false)
					if result > lootResult.nothingToLoot then
						isAnythingLooted = true
					else
						local owner = nil
						pcall(function() owner = gameObj:GetOwner() end)
						if owner then
							local ownerEntIdHash = owner:GetEntityID().hash
							gameObjEntityIdHashStr = tostring(ownerEntIdHash)
							if not objectsProcessed[gameObjEntityIdHashStr] then
								if not string.find(owner:ToString(), 'gameLootSlot') then
									if gameObjEntIdHash ~= ownerEntIdHash then
										result = lootObjectItems(owner, forceShard, false)
										if result > lootResult.nothingToLoot then
											isAnythingLooted = true
										end
									end
								end
							end
						end
					end
				end
			end
		end
	end

	logic.lastLootCompletedTime = os.clock()
	if audioFeedback then if isAnythingLooted then Game.GetAudioSystem():PlayLootAllSound() end end
end

local angleIncrements = {0, 5, -5, 10, -10, 15, -15}
local elevationIncrements = {0, 0.33, 0.45, 0.5}
local distanceToAngleFactor = 0.003 * 360

function isObjectVisibleToPlayer(gameObj, player, skipPreCheck)
	if not skipPreCheck then
		if not gameObj then return end
		if not IsDefinedS(gameObj) then return end
		if not gameObj:IsA('gameObject') then return end
	end

	player = player or GetPlayer()
	local senseManager = Game.GetSenseManager()
	local isVisble = senseManager:IsObjectVisible(player:GetEntity(), gameObj:GetEntity())
	if isVisble then return true end

	local playerPos = player:GetWorldPosition()
	local objectPos = gameObj:GetWorldPosition()

	local uiSlotsPos
	if not gameObj:IsA(ScriptedPuppet) then
		local uiSlots = gameObj:FindComponentByName(UI_Slots)
		if uiSlots and type(uiSlots.GetLocalPosition) == 'function' and (not uiSlots:GetLocalPosition():IsZero()) then
			uiSlotsPos = Matrix.GetTranslation(uiSlots:GetLocalToWorld());
		end
	end

	local playerEyesPos, forward = targetingSystem:GetCrosshairData(player)
	local playerToEyesDist2D = Vector4.Distance2D(playerPos, playerEyesPos) + 0.02
	playerEyesPos.z = playerEyesPos.z + 0.02
	local playerToObjectAngle = Vector4.new(objectPos.x - playerEyesPos.x, objectPos.y - playerEyesPos.y, 0, 0):ToRotation().yaw + 90
	playerEyesPos = Vector4.new(playerPos.x + playerToEyesDist2D * math.cos(math.rad(playerToObjectAngle)), playerPos.y + playerToEyesDist2D * math.sin(math.rad(playerToObjectAngle)), playerEyesPos.z, 1)

	isVisble = senseManager:IsPositionVisible(playerEyesPos, objectPos) or (uiSlotsPos and senseManager:IsPositionVisible(playerEyesPos, uiSlotsPos))
	if isVisble then return true end

	local eyesToObjectDist2D = Vector4.Distance2D(playerEyesPos, objectPos)
	if eyesToObjectDist2D ~= 0 then
		local objectToPlayerEyesAngle = Vector4.new(playerEyesPos.x - objectPos.x, playerEyesPos.y - objectPos.y, 0, 0):ToRotation().yaw + 90
		local angleShiftFactor = distanceToAngleFactor / eyesToObjectDist2D

		local newPlayerEyesPos = Vector4.new(playerEyesPos)
		for _, angleShift in ipairs(angleIncrements) do
			if angleShift ~= 0 then
				angleShift = angleShift * angleShiftFactor
				local newAngleRad = math.rad(objectToPlayerEyesAngle+angleShift)
				newPlayerEyesPos = Vector4.new(objectPos.x + eyesToObjectDist2D * math.cos(newAngleRad), objectPos.y + eyesToObjectDist2D * math.sin(newAngleRad), playerEyesPos.z, 1)
			end
			if uiSlotsPos then
				isVisble = senseManager:IsPositionVisible(newPlayerEyesPos, uiSlotsPos)
				if isVisble then return true end
			end

			local elevatedObjectPos = Vector4.new(objectPos)
			for _, elevationIncrement in ipairs(elevationIncrements) do
				elevatedObjectPos.z = elevatedObjectPos.z + elevationIncrement

				isVisble = senseManager:IsPositionVisible(newPlayerEyesPos, elevatedObjectPos)
				if isVisble then return true end
			end
		end
	end

	local hitPoint, hitPoints = getHitPointFromTo(playerEyesPos, objectPos)
	if not hitPoint then return true end

	if not hitPoints then hitPoints = {} end
	local objectDist = Vector4.Distance(playerPos, objectPos)
	local hitPointDist = Vector4.Distance(playerPos, hitPoint)
	local dif = objectDist - hitPointDist

	if hitPointDist > objectDist then
		return
	elseif (#hitPoints > 0 and (string.find(hitPoints[#hitPoints].materials, 'concrete') or string.find(hitPoints[#hitPoints].materials, 'asphalt'))) then
		return
	elseif dif < 0.33 then
		return true
	elseif (dif < 1 and Game.GetAINavigationSystem():IsPointOnNavmesh(gameObj, hitPoint, Vector4.new(0.3, 0.3, 0.3, 1))) then
		return true
	end
end

function isObjectOfInterest(gameObj)
	if type(gameObj) ~= 'userdata' then return false end
	if not IsDefined(gameObj) then return false end
	if not gameObj:IsA('gameObject') then return false end
	if gameObj.isCrowd then return false end
	local isAccepted = false
	for i = 1, lootableClassesCount do
		if gameObj:IsA(lootableClasses[i]) then isAccepted = true break end
	end
	if not isAccepted then return end

	if gameObj:IsA('gameItemDropObject') then
		local itemObject = gameObj:GetItemObject()
		if itemObject and itemObject:IsA('gameweaponObject') and itemObject.isHeavyWeapon then return false end
	end
	return true
end

function isProtectedNpc(gameObj)
	if type(protectedNpcs) ~= 'table' then return end
	local id = gameObj:GetTDBID()
	if id.hash == 0 then return end
	for _, protectedNpc in ipairs(protectedNpcs) do
		if protectedNpc.ownerId and id == protectedNpc.ownerId then return true end
	end
end

function isNpcSafeToLoot(gameObj)
	if not gameObj:IsNPC() then return true end
	if isProtectedNpc(gameObj) then return end
	if gameObj:IsDead() then return true end
	if not (gameObj:GetKiller() == nil) then return true end
	if gameObj:IsDefeated() then return true end
	return false
end

function isObjectLootable(gameObj, gameObjEntityIdHashStr, isClassicScan)
	local isAccepted = false
	for i = 1, lootableClassesCount do
		if gameObj:IsA(lootableClasses[i]) then isAccepted = true break end
	end
	if not isAccepted then return end
	if gameObj:IsA(ScriptedPuppet) and gameObj:IsHuman() and (not isProtectedNpc(gameObj)) then return true end
	if isClassicScan then return true end
	if objectMappinsCount == 0 then return false end
	if not gameObjEntityIdHashStr then gameObjEntityIdHashStr = tostring(gameObj:GetEntityID().hash) end
	if not objectMappins[gameObjEntityIdHashStr] then return false end
	local mappinObjectRef = objectMappins[gameObjEntityIdHashStr].mappinObjectRef
	if not mappinObjectRef then return false end
	if not IsDefinedS(mappinObjectRef) then return false end
	local mappins = mappinObjectRef.mappins
	if not mappins then return false end
	if #mappins < 1 then return false end
	return true
end

function lootObjectItems(gameObj, forceShard, skipPreCheck)
	if not skipPreCheck then
		if not isObjectOfInterest(gameObj) then return lootResult.notLootObject end
		if not isNpcSafeToLoot(gameObj) then return lootResult.notLootObject end
	end
	local protectQuestObject = true

	local isObjectLockProtected = false
	local isObjectQuestProtected = false
	local isObjectQuestSiteProtected = false

	if forceShard then
		if string.find(gameObj:ToString(), 'Shard') then
			protectQuestObject = false
		end
	end
	local player = GetPlayer()
	if gameObj:IsA('gameContainerObjectBase') then
		if gameObj:IsA('ShardCaseContainer') then
			if protectKeyCards and gameObj.itemTDBID and RPGManager.GetItemType(ItemID.FromTDBID(gameObj.itemTDBID)) == gamedataItemType.Gen_Keycard then return lootResult.protectedObject end
		else
			if gameObj:IsLocked(player) then return lootResult.protectedObject end
		end
	end

	if protectQuestObject then if gameObj:IsQuest() then return lootResult.protectedObject end end
	if isObjectAtQuestSite(gameObj) then return lootResult.protectedObject end

	local isObjectWeaponGradeProtected = false
	if gameObj:IsA('gameItemDropObject') then
		local itemObject = gameObj:GetItemObject()
		if itemObject then
			if itemObject:IsA('gameweaponObject') then
				itemObject = gameObj:GetItemObject()
				if itemObject then
					if isGameV2 then
						if gameObj.isIconic and itemObject.isIconic then
							isObjectWeaponGradeProtected = true
						end
					else
						if itemObject.isIconic then
							isObjectWeaponGradeProtected = true
						end
					end
				end
			end
		end
	end

	local objectPosition = gameObj:GetWorldPosition()
	if isValidVector4(objectPosition) then
		if type(protectedSpecialItems) == 'table' then
			for _, protectedItem in ipairs(protectedSpecialItems) do
				if protectedItem.position then
					if Vector4.DistanceSquared(objectPosition, protectedItem.position) < 0.36 then
						if protectedItem.factName then
							if questsSystem:GetFact(protectedItem.factName) < 1 then
								return lootResult.protectedObject
							end
						else
							return lootResult.protectedObject
						end
					end
				end
			end
		end

		if type(collectedPoiMappins) == 'table' then
			for id, mappinData in pairs(collectedPoiMappins) do
				if not IsDefinedS(mappinData.mappin) then collectedPoiMappins[id] = nil
				elseif mappinData.position then
					if Vector4.DistanceSquared(objectPosition, mappinData.position) < 0.1225 then
						return lootResult.protectedObject
					end
				end
			end
		end
	end

	local result, items = transactionSystem:GetItemList(gameObj)
	if result then
		if #items > 0 then
			local lootedItems, totalItems = 0, #items
			for i, item in ipairs(items) do
				if IsDefinedS(item) then
					local isItemQuestProtected = false
					local isHeavyWeaponItem = false
					local isItemWeaponGradeProtected = false
					local questFound = false
					local itemId = item:GetID():GetTDBID()
					local itemRecord = TweakDBInterface.GetItemRecord(itemId)
					if itemRecord then
						local itemSecondaryAction = itemRecord:ItemSecondaryAction()
						if itemSecondaryAction then
							local appendedTweakDBID = TweakDBID.new(itemSecondaryAction:GetID(), ".journalEntry")
							local journalPath = TweakDBInterface.GetString(appendedTweakDBID, "")
							local journalEntry = journalManager:GetEntryByString(journalPath, "gameJournalOnscreen")

							if journalEntry then
								local level = 0
								while (journalEntry and (not journalEntry:IsA('gameJournalFolderEntry')) and level < 10) do
									journalEntry = journalManager:GetParentEntry(journalEntry)
									level = level + 1
								end
								if journalEntry then
									if #allJournalQuestEntries == 0 then
										allJournalQuestEntries = journalMappinExtractor.getAllJournalQuestEntries()
										if not allJournalQuestEntries then allJournalQuestEntries = {} end
									end

									for i, qe in ipairs(allJournalQuestEntries) do
										if (not questFound) and journalEntry.id == qe.id then questFound = true break end
									end
								end
							end
						end
					end

					isItemQuestProtected = questFound

					if not isItemQuestProtected then
						if type(protectedSpecialItems) == 'table' then
							for _, protectedItem in ipairs(protectedSpecialItems) do
								if protectedItem.id and itemId.hash == protectedItem.id.hash and itemId.length == protectedItem.id.length then
									isItemQuestProtected = true
								end
							end
						end
					end
					
					local itemType = item:GetItemType()
					if itemType then
						isHeavyWeaponItem = itemType == gamedataItemType.Wea_HeavyMachineGun
						if string.find(itemType.value, 'Wea_') then
							isItemWeaponGradeProtected = item:GetStatValueByType(gamedataStatType.IsItemIconic) > 0
						end
					end

					if not isHeavyWeaponItem and not isObjectWeaponGradeProtected and not isItemWeaponGradeProtected and not isObjectLockProtected and not isItemQuestProtected and not isObjectQuestProtected and not isObjectQuestSiteProtected then
						if transactionSystem:TransferItem(gameObj, player, item:GetID(), item:GetQuantity()) then
							lootedItems = lootedItems + 1
						end
					end
				end
			end

			if lootedItems > 0 then
				if gameObj:IsA('gameContainerObjectBase') or gameObj:IsA('ShardCaseContainer') then
					if not gameObj.wasOpened then
						pcall(function() gameObj:OpenContainerWithTransformAnimation() end)
						gameObj.wasOpened = true
					end
				end
			end

			if lootedItems > 0 then
				if logic.isLootDialogOnScreen then
					if lastLootingController then
						if IsDefinedS(lastLootingController) then
							lastLootingController:Hide()
						end
					end
				end
				if lootedItems == totalItems then
					return lootResult.allLooted
				else
					return lootResult.partialLoot
				end
			else
				return lootResult.allItemsFailed
			end
		else
			return lootResult.nothingToLoot
		end
	else
		return lootResult.nothingToLoot
	end

	return lootResult.generalFailure
end

function isObjectAtQuestSite(gameObj)
	if isQuestMappWithinRangeByJournal(gameObj, 0.5) then return true end
	if isWorldMappinOfTypeWithinRange(gameObj, 0.5, 'Quest') then return true end
	return false
end

function isQuestMappWithinRangeByJournal(gameObj, range)
	if not gameObj then return false end
	if not IsDefinedS(gameObj) then return false end
	if not gameObj:IsA('gameObject') then return false end
	if not range then range = 0.5 end
	if type(range) ~= 'number' then range = 0.5 end

	local capturedQuestMappins = journalMappinExtractor.getCurrentQuestsMappins()
	if not capturedQuestMappins then return false end
	if not #capturedQuestMappins == 0 then return false end

	local objectPos = gameObj:GetWorldPosition()

	closeMappins = {}
	for _, mappin in ipairs(capturedQuestMappins) do
		if math.abs(mappin.pos.x - objectPos.x) <= range then
			if math.abs(mappin.pos.y - objectPos.y) <= range then
				if math.abs(mappin.pos.z - objectPos.z) <= range then
					local takeIt = true
					if takeIt then table.insert(closeMappins, mappin) end
				end
			end
		end
	end

	if #closeMappins == 0 then return false end
	if #closeMappins == 1 then return closeMappins[1] end

	lowestDistanceIndex = 0
	lowestDistanceSquared = 1000000000

	for i = 1, #closeMappins do
		local distSquared = Vector4.DistanceSquared(objectPos, closeMappins[i].pos)
		if distSquared < lowestDistanceSquared then
			lowestDistanceSquared = distSquared
			lowestDistanceIndex = i
		end
	end

	if lowestDistanceIndex > 0 then
		if lowestDistanceSquared <= range * range then
			return closeMappins[lowestDistanceIndex]
		end
	end

	return false
end

function isWorldMappinOfTypeWithinRange(gameObj, range, typeFilterStr1, typeFilterStr2)
	if not gameObj then return false end
	if not IsDefinedS(gameObj) then return false end
	if not gameObj:IsA('gameObject') then return false end
	if not range then range = 0.5 end
	if type(range) ~= 'number' then range = 0.5 end
	if type(typeFilterStr1) ~= 'string' then typeFilterStr1 = false end
	if type(typeFilterStr2) ~= 'string' then typeFilterStr2 = false end
	local noTypeFilters = not typeFilterStr1 and not typeFilterStr2

	if not worldMappins then worldMappins = {} end
	worldMappins = Game.GetMappinSystem():GetMappins(gamemappinsMappinTargetType.World)
	if not worldMappins then return false end
	if #worldMappins == 0 then return false end

	local objectPos = gameObj:GetWorldPosition()

	closeMappins = {}
	for _, mappin in ipairs(worldMappins) do
		if math.abs(mappin.worldPosition.x - objectPos.x) <= range then
			if math.abs(mappin.worldPosition.y - objectPos.y) <= range then
				if math.abs(mappin.worldPosition.z - objectPos.z) <= range then
					local takeIt = false
					if noTypeFilters then
						takeIt = true
					else
						if typeFilterStr1 then if string.find(mappin.type.value, typeFilterStr1) then takeIt = true end end
						if takeIt ~= true then if typeFilterStr2 then if string.find(mappin.type.value, typeFilterStr2) then takeIt = true end end end
					end
					if takeIt then table.insert(closeMappins, mappin) end
				end
			end
		end
	end

	if #closeMappins == 0 then return false end
	if #closeMappins == 1 then return closeMappins[1] end

	lowestDistanceIndex = 0
	lowestDistanceSquared = 1000000000

	for i = 1, #closeMappins do
		local distSquared = Vector4.DistanceSquared(objectPos, closeMappins[i].worldPosition)
		if distSquared < lowestDistanceSquared then
			lowestDistanceSquared = distSquared
			lowestDistanceIndex = i
		end
	end

	if lowestDistanceIndex > 0 then
		if lowestDistanceSquared <= range * range then
			return closeMappins[lowestDistanceIndex]
		end
	end

	return false
end

function logic.couldStartNewLootingCycle(player)
	player = player or GetPlayer()
	logic.isPlayerInWorkspot = workspotSystem:IsActorInWorkspot(player)
	if logic.isPlayerInWorkspot then return false end
	if isAnyGamePausingScreen(player) then return false end
	if isPlayerSpecialMode(player) then return false end
	if isMessagePopupOnScreen() then return false end
	if isPlayerInVehicle(player) then return false end
	if isPlayerInComputerControl(player) then return end
	if isPlayerControllingDevice(player) then return end
	if isPlayerInFastTravel() then return false end
	if isPlayerInBraindance() then return false end
	if isExcludedSpecialQuestCase() then return false end
	return true
end

function logic.isLootingTime(isBurstMode)
	local player = GetPlayer()
	logic.isPlayerInWorkspot = workspotSystem:IsActorInWorkspot(player)

	if type(logic.cooldown) == 'number' then if os.clock() > logic.cooldown then logic.cooldown = 0 end else logic.cooldown = 0 end
	if logic.cooldown > 0 then return end

	logic.isAnyDialogOnScreen = isDialogOpen()
	logic.isAnyOtherInteractonOnScreen = isInteractionsOpen()
	
	if lastTerminalInteractionActive then
		if lastCursorDeviceGameController then
			if IsDefinedS(lastCursorDeviceGameController) then
				if not lastCursorDeviceGameController.cursorDevice:IsVisible() then
					lastTerminalInteractionActive = false
				end
			else
				lastTerminalInteractionActive = false
			end
		else
			lastTerminalInteractionActive = false
		end
	end
	if not logic.isAnyOtherInteractonOnScreen then logic.isAnyOtherInteractonOnScreen = lastTerminalInteractionActive end
	if not logic.isLootDialogOnScreen then
		if logic.isAnyDialogOnScreen then
			if not isBurstMode then logic.cooldown = os.clock() + 0.75 end
			return false
		end
		if logic.isAnyOtherInteractonOnScreen then
			if not isBurstMode then logic.cooldown = os.clock() + 0.25 end
			return false
		end
	end

	if logic.isPlayerInWorkspot then return false end
	if isAnyGamePausingScreen(player) then return false end
	if isPlayerSpecialMode(player) then return false end
	if isMessagePopupOnScreen() then return false end
	if isPlayerInVehicle(player) then return false end
	if (not isBurstMode) and isPlayerScanning(player) then return false end
	if isPlayerInComputerControl(player) then return end
	if isPlayerControllingDevice(player) then return end
	if isPlayerInFastTravel() then return false end
	if isPlayerInBraindance() then return false end
	if isExcludedSpecialQuestCase() then return false end

	logic.cooldown = 0
	return true
end

local questCaseLookup = {}
questCaseLookup['1460153075'] = true
questCaseLookup['1414086225'] = true
questCaseLookup['3328820332'] = true
questCaseLookup['1168297061'] = true
questCaseLookup['3643888599'] = true
questCaseLookup['694730282'] = true
questCaseLookup['751325220'] = true
questCaseLookup['2957282811'] = true
questCaseLookup['3556076006'] = true

function isExcludedSpecialQuestCase()
	if not questCaseLookup then return false end
	local objective = journalManager:GetTrackedEntry()
	if not objective then return false end
	local hash = journalManager:GetEntryHash(objective)
	if hash < 0 then hash = hash + 4294967296 end
	return questCaseLookup[tostring(hash)]
end

function isMessagePopupOnScreen()
	if not lastPhoneMessagePopupGameController then return false end
	return IsDefinedS(lastPhoneMessagePopupGameController)
end

function isDialogOnScreen()
	local dialogChoiceHubs = FromVariant(gameBlackBoardSystem:Get(allBlackboardDefs.UIInteractions):GetVariant(allBlackboardDefs.UIInteractions.DialogChoiceHubs))
	if dialogChoiceHubs then return #dialogChoiceHubs.choiceHubs > 0 end
	return false
end

function isDialogOpen()
	if isDialogOnScreen() then return true end
	if lastDialogWidgetGameController and IsDefined(lastDialogWidgetGameController) and lastDialogWidgetGameController.hubAvailable then return true end
	if lastInteractionUIBase and IsDefined(lastInteractionUIBase) then
		local rootWidget = lastInteractionUIBase:GetRootWidget()
		if rootWidget then
			local numChildren = rootWidget:GetNumChildren()
			if numChildren > 1 then
				local hubWidget = rootWidget:GetWidgetByPathName(CName.new('hub'))
				if hubWidget and hubWidget:GetNumChildren() > 1 then return true end
			end
		end
	end
	if type(logic.lastHubCountReset) == 'number' and os.clock() - logic.lastHubCountReset < 0.5 then return true end
	return false
end

function isLootingOpen()
	if not lastLootingController then return false end
	if not IsDefinedS(lastLootingController) then return false end
	return lastLootingController:IsShown()
end

function isInteractionsOpen()
	if logic.isNativeHubLeftoverActive then return true end
	if not lastInteractionUIBase then return false end
	if not IsDefinedS(lastInteractionUIBase) then return false end
	if not lastInteractionUIBase.AreInteractionsOpen then return false end
	return true
end

function isPlayerInVehicle(player)
	player = player or GetPlayer()
	if not player then return end
	return GetMountedVehicle(player)
end

function isPlayerScanning()
	local scannerMode = false
	pcall(function() scannerMode = FromVariant(gameBlackBoardSystem:Get(allBlackboardDefs.UI_Scanner):GetVariant(allBlackboardDefs.UI_Scanner.ScannerMode)) end)
	if scannerMode then if scannerMode.mode then if scannerMode.mode ~= gameScanningMode.Inactive then return true end end end
	return false
end

function isPlayerInBraindance()
	return gameBlackBoardSystem:Get(allBlackboardDefs.Braindance):GetBool(allBlackboardDefs.Braindance.IsActive)
end

function isPlayerInFastTravel()
	if gameBlackBoardSystem:Get(allBlackboardDefs.FastTRavelSystem):GetBool(allBlackboardDefs.FastTRavelSystem.FastTravelLoadingScreenFinished) then return false end	
	if not FromVariant(gameBlackBoardSystem:Get(allBlackboardDefs.FastTRavelSystem):GetVariant(allBlackboardDefs.FastTRavelSystem.DestinationPoint)) then return false end
	return true
end

function isPlayerInComputerControl(player)
	player = player or GetPlayer()
	if not player then return true end
	local isUIZoomDevice = false
	pcall(function() isUIZoomDevice = gameBlackBoardSystem:GetLocalInstanced(player:GetEntityID(), allBlackboardDefs.PlayerStateMachine):GetBool(allBlackboardDefs.PlayerStateMachine.IsUIZoomDevice) end)
	return isUIZoomDevice
end

function isPlayerControllingDevice(player)
	player = player or GetPlayer()
	if not player then return true end
	local isDevice = false
	pcall(function() isDevice = gameBlackBoardSystem:GetLocalInstanced(player:GetEntityID(), allBlackboardDefs.PlayerStateMachine):GetBool(allBlackboardDefs.PlayerStateMachine.IsControllingDevice) end)
	return isDevice
end

function isAnyGamePausingScreen(player)
	local result, blackboardSystem = pcall(function() return gameBlackBoardSystem:Get(allBlackboardDefs.UI_System) end)
	if not blackboardSystem then return true end
	if blackboardSystem:GetBool(allBlackboardDefs.UI_System.IsInMenu) then return true end
	if isPreGame() then return true end
	if isGamePaused() then return true end
	if isPlayerDetached(player) then return true end
	if isLoadingBar() then return true end
	if isRadialWheel() then return true end
	if isPhotoMode() then return true end
	if isTutorial() then return true end
	return false
end

local restrictionTags
function isPlayerSpecialMode(player)
	player = player or GetPlayer()
	if not player then return true end
	local sceneTier = player:GetSceneTier()
	if sceneTier < 1 then return true end
	if sceneTier == 6 then return end
	if sceneTier >= 3 then return true end
	if player:IsReplacer() then return true end
	if player:IsJohnnyReplacer() then return true end
	if not restrictionTags then restrictionTags = {n"Defeated", n"Cyberspace", n"CyberspacePresence"} end
	if StatusEffectSystem.ObjectHasStatusEffectWithTags(player, restrictionTags) then return true end
end

function isPreGame()
	return Game.GetSystemRequestsHandler():IsPreGame()
end

function isGamePaused()
	return Game.GetSystemRequestsHandler():IsGamePaused()
end

function isPlayerDetached(player)
	player = player or GetPlayer()
	if not player then return true end
	local streetCred = false
	pcall(function() streetCred = Game.GetStatsSystem():GetStatValue(player:GetEntityID(), 'StreetCred') end) --(c)psiberx)
	if not streetCred then return true end
	if streetCred < 1 then return true end
	return false
end

function isLoadingBar()
	if not lastLoadingScreenProgressBarController then return false end
	if not IsDefinedS(lastLoadingScreenProgressBarController) then return false end	
	local rootWidget = lastLoadingScreenProgressBarController.progressBarRoot
	if rootWidget then return rootWidget:IsVisible() end
	return false
end

function isRadialWheel()
	if Game.GetTimeSystem():IsTimeDilationActive('radial') then return true end -- (c)psiberx hint
	return false
end

function isPhotoMode()
	local isActive = false
	pcall(function() isActive = gameBlackBoardSystem:Get(allBlackboardDefs.PhotoMode):GetBool(allBlackboardDefs.PhotoMode.IsActive) end)
	if isActive then return true end
	return false
end

function isTutorial()
	if not lastTutorialMainController then return false end
	if not IsDefinedS(lastTutorialMainController) then return false end
	if lastTutorialMainController.tutorialActive then return true end
	return false
end


-- raycast helper:

-- this part is a modified extract from TargetingHelper.lua example by (c)psiberx
--https://github.com/WolvenKit/cet-examples
local obstacles = {
	'Static',
	'Terrain',
	'PlayerBlocker'
}

function getHitPointFromTo(from, to, staticOnly)
	if not staticOnly then staticOnly = false end
	local results = {}
	for i, filter in ipairs(obstacles) do
		local success, result = spatialQueriesSystem:SyncRaycastByCollisionGroup(from, to, filter, staticOnly, false)
		if success then
			local resultPosition = Vector4.Vector3To4(result.position)
			table.insert(results, {
				distance = Vector4.DistanceSquared(from, resultPosition),
				position = resultPosition,
				material = result.material
			})
		end
	end

	if #results == 0 then return end

	local hitPoints = {}
	table.insert(hitPoints, {position = results[1].position, materials = results[1].material.value})
	local nearest = results[1]
	for i = 2, #results do
		if results[i].distance < nearest.distance then nearest = results[i] table.insert(hitPoints, {position = results[i].position, materials = results[i].material.value})
		elseif results[i].distance == nearest.distance then
			for ii = 2, #hitPoints do
				if hitPoints[ii].position.x == results[i].position.x then
					if hitPoints[ii].position.y == results[i].position.y then
						if hitPoints[ii].position.z == results[i].position.z then
							if hitPoints[ii].materials then
								hitPoints[ii].materials = hitPoints[ii].materials..','..results[i].material.value
							else
								hitPoints[ii].materials = results[i].material.value
							end
						end
					end
				end
			end
		end
	end

	return nearest.position, hitPoints
end

function findEntityByIDHashStr(hashStr)
	if type(hashStr) ~= 'string' then return end
	local result, data = pcall(function() return Game.FindEntityByID(entEntityID.new({ hash = loadstring('return ' .. hashStr, '')() })) end)
	if not result then return end
	return data
end

function isValidVector4(input)
	if type(input) ~= 'userdata' then return false end
	if type(input.IsZero) ~= 'function' then return false end
	if input:IsZero() then return false end
	return true
end

function IsDefinedS(gameObj)
	local result, val
	result, val = pcall(function() return IsDefined(gameObj) end)
	if result then return val else return false end
end

return logic