package com.example.dolitbt;


import cn.dolit.DLBT.DLBT_KERNEL_START_PARAM;
import cn.dolit.DLBT.DolitBT;
import android.app.Application;
import android.util.Log;
import android.widget.Toast;


public class MainApplication extends Application {
	
	public DolitBT mDolitBT = null;
	private boolean mBInit = false;
	
	protected static final String TAG = "DolitBTDemoApp/";	
	
	//֤Կ1 Կ2 -- Ҫṩhttp://www.dolit.cnϵ
	public static final String strDolitParseKey1 = "dolitBTSample";		
	public static final String strDolitParseKey2 = "PoweredBy-www.Dolit.cn";
	
	@Override
    public void onCreate() {
	    super.onCreate();
	    initDolitBT();
	}
	
	public void onDestroy()
	{
		Shutdown();
	}
	
    /**
     * ʹýsdkǰȳʼDolitSiteParser.
     * DolitSiteParserȫֵģΪطãҪڵһα֮ǰʼҲԷŵʼʱʼһΣ
     * ֻҪҪõͲӦDolitSiteParser
     * 
     * ڳʼʱҪKeyûϵȡ
     */
	
	public void initDolitBT() 
	{
        if (mDolitBT == null) 
        {
        	mDolitBT = new DolitBT(this);         	

        	int ret = mDolitBT.InitAPIKey(strDolitParseKey1, strDolitParseKey2);
        	if (ret == -4)
        	{
        		Log.e(TAG, "InitAPIKey Error, please check your apk key!");
        		Toast.makeText(this.getApplicationContext(), 
                        "KeystoreͰδBTȨϵȡȷȨKey!", Toast.LENGTH_LONG).show(); 
        		return;
        	}
        	else if (ret != 0)
            {
        		Log.e(TAG, "InitAPIKey failed, please check your env!");
                Toast.makeText(this.getApplicationContext(), 
                        "BTģ ʼ!,ret:" + ret, Toast.LENGTH_LONG).show();
                return;
            }
        }    	
    	// bt
    	if(!mBInit)
    	{
        	DLBT_KERNEL_START_PARAM param = new DLBT_KERNEL_START_PARAM();
        	param.startPort = 9010;
        	param.endPort = 9020;        	
        	mDolitBT.DLBT_Startup(param, "", false, "");
        	mBInit = true;
    	}
	}
	
	public void Shutdown()
	{
		 if (mDolitBT != null && mBInit) 
		 {
			 mDolitBT.DLBT_Shutdown();
		 }
		 mBInit = false;
	}
}
