PrefabFiles = {
	"civi",
    "nightmare_darkgem",
    "nightmare_lightgem",
    "realnightsword",
    "realnightarmor",
    "nightmare_axe_pickaxe",
    "glowingbackpack",
    "night_battleproof",
    "book_harvest",
    "books",
    "nightmarestaff"

}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/civi.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/civi.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/civi.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/civi.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/civi_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/civi_silho.xml" ),

    Asset( "IMAGE", "bigportraits/civi.tex" ),
    Asset( "ATLAS", "bigportraits/civi.xml" ),

	Asset( "IMAGE", "images/map_icons/civi.tex" ),
	Asset( "ATLAS", "images/map_icons/civi.xml" ),

    Asset( "ANIM", "anim/nightmare_gems.zip"),
    Asset( "IMAGE", "images/inventoryimages/nightmare_darkgem.tex"),
    Asset( "ATLAS", "images/inventoryimages/nightmare_darkgem.xml"),

    -- Asset( "ANIM", "anim/nightmare_lightgem.zip"),
    Asset( "IMAGE", "images/inventoryimages/nightmare_lightgem.tex"),
    Asset( "ATLAS", "images/inventoryimages/nightmare_lightgem.xml"),

    Asset( "IMAGE", "images/hud/nightmaretab.tex"),
    Asset( "ATLAS", "images/hud/nightmaretab.xml"),

    Asset( "IMAGE", "images/inventoryimages/realnightsword.tex"),
    Asset( "ATLAS", "images/inventoryimages/realnightsword.xml"),

    Asset( "IMAGE", "images/inventoryimages/realnightarmor.tex"),
    Asset( "ATLAS", "images/inventoryimages/realnightarmor.xml"),

    Asset( "IMAGE", "images/inventoryimages/nightmare_axe_pickaxe.tex"),
    Asset( "ATLAS", "images/inventoryimages/nightmare_axe_pickaxe.xml"),

    Asset( "IMAGE", "images/inventoryimages/glowingbackpack.tex"),
    Asset( "ATLAS", "images/inventoryimages/glowingbackpack.xml"),

    Asset( "IMAGE", "images/inventoryimages/night_battleproof.tex"),
    Asset( "ATLAS", "images/inventoryimages/night_battleproof.xml"),

    Asset( "IMAGE", "images/inventoryimages/book_harvest.tex"),
    Asset( "ATLAS", "images/inventoryimages/book_harvest.xml"),

    Asset( "IMAGE", "images/inventoryimages/nightmarestaff.tex"),
    Asset( "ATLAS", "images/inventoryimages/nightmarestaff.xml"),
}

local Ingredient = GLOBAL.Ingredient
local RECIPETABS = GLOBAL.RECIPETABS
local TECH = GLOBAL.TECH
local Recipe = GLOBAL.Recipe
local TUNING = GLOBAL.TUNING
local STRINGS = GLOBAL.STRINGS
local GetPlayer = GLOBAL.GetPlayer
local IsHUDPaused = GLOBAL.IsPaused
local TheInput = GLOBAL.TheInput
local TheFrontEnd = GLOBAL.TheFrontEnd
local TheSim = GLOBAL.TheSim


local require = GLOBAL.require

AddMinimapAtlas("images/inventoryimages/glowingbackpack.xml")
AddMinimapAtlas("images/map_icons/civi.xml")

AddModCharacter("civi", "FEMALE")

-----------

-- lang --
TUNING.LANGA = GetModConfigData("LANG")
TUNING.NM_BOOKS = GetModConfigData("NM_BOOKS")
TUNING.NM_MAGICBONUS = GetModConfigData("NM_MAGICBONUS")
TUNING.NM_GBACKPACK = GetModConfigData("NM_GBACKPACK")
TUNING.NM_TOY = GetModConfigData("NM_TOY")

if TUNING.LANGA == 0 then
    -- The character select screen lines
    STRINGS.CHARACTER_TITLES.civi = "光暗魔法使"
    STRINGS.CHARACTER_NAMES.civi = "Civi"
    STRINGS.CHARACTER_DESCRIPTIONS.civi = "*通过黑/白宝石升降级\n*与知识和魔法为伴\n*能够操纵噩梦"
    STRINGS.CHARACTER_QUOTES.civi = "\"谁爱用黑人谁用去，我换人设啦\""
else
    STRINGS.CHARACTER_TITLES.civi = "Mogician of Light and Dark"
    STRINGS.CHARACTER_NAMES.civi = "Civi"
    STRINGS.CHARACTER_DESCRIPTIONS.civi = "*Travel between light and dark via gems\n*Friend of books and magic\n*Can control nightmare."
    STRINGS.CHARACTER_QUOTES.civi = "Get close to Nightmare!"
end

    STRINGS.NAMES.civi = "Civi"

AddComponentPostInit("armor", function(self)
    local old_fn_setcond = self.SetCondition
    self.SetCondition = function(self,amount)
    if self.inst.prefab ~= "realnightarmor" then
            old_fn_setcond(self,amount)
        else
            self.condition = math.min(amount, self.maxcondition)
            self.inst:PushEvent("percentusedchange", { percent = self:GetPercent() })
            if self.condition <= 0 then
                self.condition = 0
                self.absorb_percent = 0
            end

        end
    end

    function self:SetMaxCondition(amount)
        self.maxcondition = amount
    end

    -- self.inst:ListenForEvent("percentusedchange", self.PercentChanged)

    function self:PercenChanged2(self, inst, data)
        if self.inst.prefab ~= "realnightarmor" then
            self:PercentChanged(inst, data)
        end
        -- body
    end

    local Armor = Class(
    function(self, inst)
    self.inst = inst
    self.condition = 100
    self.maxcondition = 100
    self.tags = nil
    self.weakness = nil
    self.inst:ListenForEvent("percentusedchange", PercentChanged2)
    end)

end)

AddComponentPostInit("tool", function(self)
    function self:PercenChanged2(self, inst, data)
        if self.inst.prefab ~= "realnightarmor" then
            self:PercentChanged(inst, data)
        end
        -- body
    end

    local Tool = Class(
    function(self, inst)
        self.inst = inst
        self.actions = {}
        inst:ListenForEvent("percentusedchange", PercentChanged2)
    end)

end)

AddComponentPostInit("blinkstaff", function(self)
    local old_fn_blink = self.Blink
    self.Blink = function (self,pt, caster)
    if self:CanBlinkToPoint(pt) == false then
        return false
    end
    if self.inst.prefab == "nightmarestaff" and not self.inst.components.inventoryitem.owner.components.inventory:Has("nightmarefuel",1) then
        return false
    end
    self:SpawnEffect(caster)
    caster.SoundEmitter:PlaySound("dontstarve/common/staff_blink")
    caster:Hide()
    if caster.components.health then
        caster.components.health:SetInvincible(true)
    end
    caster:DoTaskInTime(0.25, function()
        if caster.components.health then
            caster.components.health:SetInvincible(false)
        end
        caster.Transform:SetPosition(pt.x, pt.y, pt.z)
        self:SpawnEffect(caster)
        caster:Show()
        caster.SoundEmitter:PlaySound("dontstarve/common/staff_blink")
        end)

    --TheCamera:Snap()
    if self.onblinkfn then
        self.onblinkfn(self.inst, pt, caster)
    end
    return true
end
end)




-- bb --
-- local containers = require("containers")

-- local oldwidgetsetup = containers.widgetsetup
-- containers.widgetsetup = function(container, prefab)
-- if not prefab and container.inst.prefab == "glowingbackpack" then
-- prefab = "piggyback" end
-- oldwidgetsetup(container, prefab)
-- end






-- Special Recipe by Civi --


-- if TUNING.LANGA == 0 then
--     tabname = "噩梦"
-- else
--     tabname = "Nightmare"
-- end
-- -- local civitab = AddRecipeTab(tabname, 10, "images/hud/nightmaretab.xml", "nightmaretab.tex", "nightmaregem")

--     -- 黑宝石 --
--     AddRecipe("nightmare_darkgem",
--     {Ingredient("purplegem", 1),Ingredient("nightmarefuel", 5),},
--     civitab, TECH.NONE, nil, nil, nil, nil, "nightmaregem",
--     "images/inventoryimages/nightmare_darkgem.xml", "nightmare_darkgem.tex")

--     -- 白宝石 --
--     AddRecipe("nightmare_lightgem",
--     {Ingredient("purplegem", 1),Ingredient("nightmarefuel", 5)},
--     civitab, TECH.NONE, nil, nil, nil, nil, "nightmaregem",
--     "images/inventoryimages/nightmare_lightgem.xml", "nightmare_lightgem.tex" )

-- if TUNING.NMTAB == 1 then

--     -- 红宝石 --
--     AddRecipe("redgem",
--     {Ingredient("bluegem", 1),Ingredient("nightmarefuel", 1)},
--     civitab, TECH.NONE, nil, nil, nil, nil, "nightmaregem")
--     -- local GLOBAL.STRINGS.RECIPE_DESC.REDGEM = "1"

--     -- 蓝宝石 --
--     AddRecipe("bluegem",
--     {Ingredient("redgem", 1),Ingredient("nightmarefuel", 1)},
--     civitab, TECH.NONE, nil, nil, nil, nil, "nightmaregem")
--     -- local GLOBAL.STRINGS.RECIPE_DESC.BLUEGEM = "2"

--     -- 真·影刀 --
--     AddRecipe("realnightsword",
--     {Ingredient("nightsword", 1), Ingredient("nightmare_darkgem",1,"images/inventoryimages/nightmare_darkgem.xml"), Ingredient("nightmare_lightgem",1,"images/inventoryimages/nightmare_lightgem.xml")},
--     civitab, TECH.MAGIC_THREE, nil, nil, nil, nil, "nightmaregem",
--     "images/inventoryimages/realnightsword.xml", "realnightsword.tex" )

--     -- 真·影甲 --
--     AddRecipe("realnightarmor",
--     {Ingredient("armor_sanity", 1), Ingredient("nightmare_darkgem",1,"images/inventoryimages/nightmare_darkgem.xml"), Ingredient("nightmare_lightgem",1,"images/inventoryimages/nightmare_lightgem.xml")},
--     civitab, TECH.MAGIC_THREE, nil, nil, nil, nil, "nightmaregem",
--     "images/inventoryimages/realnightarmor.xml", "realnightarmor.tex" )

--     -- 影之斧镐 --
--     AddRecipe("nightmare_axe_pickaxe",
--     {Ingredient("nightmarefuel", 5), Ingredient("goldenaxe", 1), Ingredient("goldenpickaxe", 1)},
--     civitab, TECH.MAGIC_THREE, nil, nil, nil, nil, "nightmaregem",
--     "images/inventoryimages/nightmare_axe_pickaxe.xml", "nightmare_axe_pickaxe.tex" )

--     -- 发光影包 --
--     AddRecipe("glowingbackpack",
--     {Ingredient("nightmarefuel", 10), Ingredient("lightbulb", 5), Ingredient("ice", 15)},
--     civitab, TECH.MAGIC_THREE, nil, nil, nil, nil, "nightmaregem",
--     "images/inventoryimages/glowingbackpack.xml", "glowingbackpack.tex" )

--     -- 影之勋章 --
--     AddRecipe("night_battleproof",
--     {Ingredient("nightmarefuel", 1), Ingredient("monstermeat", 20)},
--     civitab, TECH.MAGIC_THREE, nil, nil, nil, nil, "nightmaregem",
--     "images/inventoryimages/night_battleproof.xml", "night_battleproof.tex" )

-- end

--     ----BOOK----
--     AddRecipe("book_birds", {Ingredient("papyrus", 2), Ingredient("bird_egg", 2)}, civitab, TECH.NONE, nil, nil, nil, nil,"nightmaregem")
--     AddRecipe("book_gardening", {Ingredient("papyrus", 2), Ingredient("seeds", 1), Ingredient("poop", 1)}, civitab, TECH.SCIENCE_TWO, nil, nil, nil, nil,"nightmaregem")

--         -- 收获的季节 --
--     AddRecipe("book_harvest",
--     {Ingredient("papyrus", 2), Ingredient("goldnugget", 10)},
--     civitab, TECH.SCIENCE_TWO, nil, nil, nil, nil,"nightmaregem", "images/inventoryimages/book_harvest.xml", "book_harvest.tex")

--     ----BOOK----
--     AddRecipe("book_sleep", {Ingredient("papyrus", 2), Ingredient("nightmarefuel", 2)}, civitab, TECH.MAGIC_TWO, nil, nil, nil, nil,"nightmaregem")
--     AddRecipe("book_brimstone", {Ingredient("papyrus", 2), Ingredient("redgem", 1)}, civitab, TECH.MAGIC_THREE, nil, nil, nil, nil,"nightmaregem")
--     AddRecipe("book_tentacles", {Ingredient("papyrus", 2), Ingredient("tentaclespots", 1)}, civitab, TECH.MAGIC_THREE, nil, nil, nil, nil,"nightmaregem")

