local assets =
{
    Asset("ANIM", "anim/book_harvest.zip"),
}

local prefabs =
{
    "splash_ocean",
    "book_fx"
}

function book_harvest(inst, reader)
    reader.components.sanity:DoDelta(-40)
    local pos = Vector3(inst.Transform:GetWorldPosition())
    local ents = TheSim:FindEntities(pos.x,pos.y,pos.z, 30)
    for k,v in pairs(ents) do
        if v.components.pickable and v.prefab ~= "flower" then
            v.components.pickable:Pick(reader)
        end
        if v.components.crop then
            v.components.crop:Harvest(reader)
        end
    end
    return true
end

local function fn(Sim)
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    -- inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("book_harvest")
    inst.AnimState:SetBuild("book_harvest")
    inst.AnimState:PlayAnimation("book_harvest")

    if SaveGameIndex:IsModeShipwrecked() or inst.components.poisonable then
        MakeInventoryFloatable(inst, "book_harvest_water", "book_harvest")
    end

    -- inst.entity:SetPristine()

    -- if not TheWorld.ismastersim then
    --     return inst
    -- end

    inst:AddComponent("inspectable")
    inst:AddComponent("book")
    inst.components.book.onread = book_harvest

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "book_harvest"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/book_harvest.xml"

    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(5)
    inst.components.finiteuses:SetUses(5)
    inst.components.finiteuses:SetOnFinished(inst.Remove)

    inst:AddComponent("fuel")
    inst.components.fuel.fuelvalue = TUNING.MED_FUEL

    MakeSmallBurnable(inst, TUNING.MED_BURNTIME)
    MakeSmallPropagator(inst)

    MakeSmallPropagator(inst)

    return inst
end

if TUNING.LANGA == 0 then
    STRINGS.NAMES.BOOK_HARVEST = "收获的季节"
    STRINGS.RECIPE_DESC.BOOK_HARVEST = "大丰收啦！"
    STRINGS.CHARACTERS.GENERIC.DESCRIBE.BOOK_HARVEST = "收收收收！"
else
    STRINGS.NAMES.BOOK_HARVEST = "Season of Harvest"
    STRINGS.RECIPE_DESC.BOOK_HARVEST = "Should help you harvest!"
    STRINGS.CHARACTERS.GENERIC.DESCRIBE.BOOK_HARVEST = "Go Go Go!"
end

return Prefab("common/inventory/book_harvest", fn, assets, prefabs)