
local MakePlayerCharacter = require "prefabs/player_common"

local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wendy.fsb" ),

        Asset( "ANIM", "anim/civi.zip" ),

}

local prefabs = {
    "nightmarefuel",
}
local start_inv = {}

local function CheckLevel( inst )
	local eater = inst.components.eater
	if inst.level == 0 then
		eater.foodprefs = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "NMDARKGEM" }
		eater.ablefoods = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "NMDARKGEM" }
	elseif inst.level == 1 then
		eater.foodprefs = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "NMDARKGEM", "NMLIGHTGEM" }
		eater.ablefoods = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "NMDARKGEM", "NMLIGHTGEM" }
	elseif inst.level == 2 then
		eater.foodprefs = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "NMLIGHTGEM" }
		eater.ablefoods = { "MEAT", "VEGGIE", "INSECT", "SEEDS", "GENERIC", "NMLIGHTGEM" }
	end


end

local function applyupgrades(inst)
	inst.level = math.min(2,inst.level)
	inst.level = math.max(0,inst.level)

	local hunger_percent = inst.components.hunger:GetPercent()
	local health_percent = inst.components.health:GetPercent()
	local sanity_percent = inst.components.sanity:GetPercent()

	inst.components.hunger.max = ( 160 - inst.level * 40 ) -- max_level = 100
	inst.components.sanity.max = ( 160 - inst.level * 40 ) -- max_level = 100
	inst.components.health.maxhealth = ( 160 - inst.level * 40 ) -- max_level = 100

	inst.components.locomotor.walkspeed = ( TUNING.WILSON_WALK_SPEED * ( 1 + 0.25 * inst.level) ) -- max_level = 6
	inst.components.locomotor.runspeed = ( TUNING.WILSON_RUN_SPEED * ( 1 + 0.25 * inst.level) ) -- max_level = 8

    if not inst.DLC2 then
        inst.components.combat.damagemultiplier = ( 1 + inst.level * 0.25 )
    elseif inst.DLC2 then
        inst.components.combat:AddDamageModifier("civi", ( inst.level * 0.25 ))
    end

	inst.components.health.absorb = ( inst.level * 0.1 ) -- max_level = 0.5
	inst.components.sanity.night_drain_mult = ( 1 - inst.level * 0.1 )
  	inst.components.hunger:SetRate( ( 1-inst.level*0.1) * TUNING.WILSON_HUNGER_RATE )

	inst.components.hunger:SetPercent(hunger_percent)
	inst.components.health:SetPercent(health_percent)
	inst.components.sanity:SetPercent(sanity_percent)

 	CheckLevel(inst)
end


local function oneat(inst, food)
	if inst.level < 2 and food and food.components.edible and food.prefab == "nightmare_darkgem" then
		--upgrade
		inst.level = ( math.max(inst.level, 0) + 1 )
		-- applyupgrades(inst)
		inst.SoundEmitter:PlaySound("dontstarve/characters/wx78/levelup")
	end

	if inst.level > 0 and food and food.components.edible and food.prefab == "nightmare_lightgem" then
		--degrade
		inst.level = ( math.min(inst.level, 2) - 1 )

		-- applyupgrades(inst)
		inst.SoundEmitter:PlaySound("dontstarve/characters/wx78/levelup")
	end
  applyupgrades(inst)
end



local function onpreload(inst, data)
	if data then
		if data.level then
			inst.level = data.level
			applyupgrades(inst)
			--re-set these from the save data, because of load-order clipping issues
			if data.health and data.health.health then inst.components.health.currenthealth = data.health.health end
			if data.hunger and data.hunger.hunger then inst.components.hunger.current = data.hunger.hunger end
			if data.sanity and data.sanity.current then inst.components.sanity.current = data.sanity.current end
			inst.components.health:DoDelta(0)
			inst.components.hunger:DoDelta(0)
			inst.components.sanity:DoDelta(0)
		end
	end
end

local function onsave(inst, data)
	data.level = inst.level

end

local function ondeath(inst)
	applyupgrades(inst)
end

local function onbecamehuman(inst)
	applyupgrades(inst)
end
-- This initializes for both clients and the host
-- local common_postinit = function(inst)
-- 	-- choose which sounds this character will play
--     inst.soundsname = "wendy"
--   -- tags
-- 		inst:AddTag("nightmaregem")
--     inst:AddTag("reader")
-- 	-- Minimap icon
-- 		inst.MiniMapEntity:SetIcon( "civi.tex" )
-- end

local function CustomRecipe()

	--制作栏图标
	    RECIPETABS['CIVITAB'] = {str = "CIVITAB", sort= 233, icon = "nightmaretab.tex", icon_atlas = "images/hud/nightmaretab.xml"}
	--黑宝石
	    local nm_darkgem = Recipe("nightmare_darkgem", { Ingredient("purplegem", 1), Ingredient("nightmarefuel", 5) }, RECIPETABS.CIVITAB, TECH.NONE)
        nm_darkgem.atlas = "images/inventoryimages/nightmare_darkgem.xml"
	--白宝石
	    local nm_lightgem = Recipe("nightmare_lightgem", {Ingredient("purplegem", 1),Ingredient("nightmarefuel", 5)}, RECIPETABS.CIVITAB, TECH.NONE)
	    nm_lightgem.atlas = "images/inventoryimages/nightmare_lightgem.xml"

        if TUNING.NM_MAGICBONUS >= 1 then

		--红宝石
		    local nm_redgem = Recipe("redgem", {Ingredient("bluegem", 1),Ingredient("nightmarefuel", 1)}, RECIPETABS.CIVITAB, TECH.NONE)
		--蓝宝石
			local nm_bluegem = Recipe("bluegem", {Ingredient("redgem", 1),Ingredient("nightmarefuel", 1)}, RECIPETABS.CIVITAB, TECH.NONE)
        end

		-- --真影刀
		--     local nm_realsowrd = Recipe("realnightsword", {Ingredient("nightsword", 1),Ingredient("nightmare_darkgem", 1, "images/inventoryimages/nightmare_darkgem.xml"),Ingredient("nightmare_lightgem", 1, "images/inventoryimages/nightmare_lightgem.xml")}, RECIPETABS.CIVITAB, TECH.MAGIC_THREE)
		--     nm_realsowrd.atlas = "images/inventoryimages/realnightsword.xml"
		-- --真影甲
		--     local nm_realarmor = Recipe("realnightarmor", {Ingredient("armor_sanity", 1),Ingredient("nightmare_darkgem", 1, "images/inventoryimages/nightmare_darkgem.xml"),Ingredient("nightmare_lightgem", 1, "images/inventoryimages/nightmare_lightgem.xml")}, RECIPETABS.CIVITAB, TECH.MAGIC_THREE)
		--     nm_realarmor.atlas = "images/inventoryimages/realnightarmor.xml"

        --法杖
        if SaveGameIndex:IsModeShipwrecked() then
            local nm_staff = Recipe("nightmarestaff",
        {Ingredient("nightmarefuel", 10), Ingredient("magic_seal", 1), Ingredient("nightmare_darkgem", 2,"images/inventoryimages/nightmare_darkgem.xml")}, RECIPETABS.CIVITAB, TECH.MAGIC_THREE)
            nm_staff.atlas = "images/inventoryimages/nightmarestaff.xml"
        else
            local nm_staff = Recipe("nightmarestaff",
        {Ingredient("nightmarefuel", 10), Ingredient("cane", 1), Ingredient("nightmare_darkgem", 2,"images/inventoryimages/nightmare_darkgem.xml")}, RECIPETABS.CIVITAB, TECH.MAGIC_THREE)
            nm_staff.atlas = "images/inventoryimages/nightmarestaff.xml"
        end
		--斧镐
		    local nm_axe_pickaxe = Recipe("nightmare_axe_pickaxe", {Ingredient("nightmarefuel", 5),Ingredient("goldenaxe", 1),Ingredient("goldenpickaxe", 1)}, RECIPETABS.CIVITAB, TECH.MAGIC_THREE)
		    nm_axe_pickaxe.atlas = "images/inventoryimages/nightmare_axe_pickaxe.xml"
        --影包
        if TUNING.NM_GBACKPACK == 1 then
            -- basic
		    local nm_gpack = Recipe("glowingbackpack", {Ingredient("nightmarefuel", 5),Ingredient("fireflies", 1)}, RECIPETABS.CIVITAB, TECH.MAGIC_THREE)
		    nm_gpack.atlas = "images/inventoryimages/glowingbackpack.xml"
        elseif TUNING.NM_GBACKPACK == 2 then
            -- Most
            local nm_gpack = Recipe("glowingbackpack", {Ingredient("nightmarefuel", 7),Ingredient("fireflies", 1),Ingredient("boneshard",3)}, RECIPETABS.CIVITAB, TECH.MAGIC_THREE)
            nm_gpack.atlas = "images/inventoryimages/glowingbackpack.xml"
        elseif TUNING.NM_GBACKPACK == 3 then
            -- Most
            local nm_gpack = Recipe("glowingbackpack", {Ingredient("nightmarefuel", 10),Ingredient("fireflies", 1),Ingredient("boneshard",6),Ingredient("ice",10)}, RECIPETABS.CIVITAB, TECH.MAGIC_THREE)
            nm_gpack.atlas = "images/inventoryimages/glowingbackpack.xml"
        end
		--勋章
        if TUNING.NM_TOY == 1 then
            if SaveGameIndex:IsModeShipwrecked() then
    		    local nm_medal = Recipe("dubloon", {Ingredient("nightmarefuel", 1),Ingredient("monstermeat", 10)}, RECIPETABS.CIVITAB, TECH.MAGIC_THREE)
                nm_medal.numtogive = 30
    		    -- nm_medal.atlas = "images/inventoryimages/night_battleproof.xml"
            else
                local nm_medal = Recipe("night_battleproof", {Ingredient("nightmarefuel", 1),Ingredient("monstermeat", 10)}, RECIPETABS.CIVITAB, TECH.MAGIC_THREE)
                nm_medal.atlas = "images/inventoryimages/night_battleproof.xml"
            end
        end

	--书籍
    if TUNING.NM_BOOKS >= 2 then
		local nm_book1 = Recipe("book_birds", {Ingredient("papyrus", 2), Ingredient("bird_egg", 2)}, RECIPETABS.CIVITAB, {SCIENCE = 0, MAGIC = 0})
		local nm_book2 = Recipe("book_gardening", {Ingredient("papyrus", 2), Ingredient("seeds", 1), Ingredient("poop", 1)}, RECIPETABS.CIVITAB, {SCIENCE = 2})
    end
	-- 收获的季节
    if TUNING.NM_BOOKS == 1 or TUNING.NM_BOOKS == 3 then
		local nm_harvest = Recipe("book_harvest", {Ingredient("papyrus", 2),Ingredient("goldnugget", 10)}, RECIPETABS.CIVITAB, TECH.SCIENCE_TWO)
		nm_harvest.atlas = "images/inventoryimages/book_harvest.xml"
    end

    if TUNING.NM_BOOKS >= 2 then
        local nm_book3 = Recipe("book_sleep", {Ingredient("papyrus", 2), Ingredient("nightmarefuel", 2)}, RECIPETABS.CIVITAB, {MAGIC = 2})
		local nm_book4 = Recipe("book_brimstone", {Ingredient("papyrus", 2), Ingredient("redgem", 1)}, RECIPETABS.CIVITAB, {MAGIC = 3})
		local nm_book5 = Recipe("book_tentacles", {Ingredient("papyrus", 2), Ingredient("tentaclespots", 1)}, RECIPETABS.CIVITAB, {MAGIC = 3})
    end
end



-- This initializes for the host only
local fn = function(inst)
    inst.soundsname = "wendy"
	inst:AddTag("nightmaregem")
    inst:AddTag("reader")

	inst.entity:AddMiniMapEntity()
	inst.MiniMapEntity:SetIcon( "civi.tex" )

	inst.level = 0
    inst:AddComponent("reader")

    if TUNING.NM_MAGICBONUS == 1 then
    	inst.components.builder.magic_bonus = 2
    end

    inst.components.health:SetMaxHealth(160)
    inst.components.hunger:SetMax(160)
    inst.components.sanity:SetMax(160)
    inst.components.locomotor.walkspeed = 4
    inst.components.locomotor.runspeed = 6
    inst.components.combat.damagemultiplier = 1
    inst.components.health.absorb = 0.00

	-- table.insert(inst.components.eater.foodprefs, "GEARS")
	inst.components.eater:SetOnEatFn(oneat)


	applyupgrades(inst)


	inst.OnSave = onsave
	inst.OnPreLoad = onpreload
	inst:ListenForEvent("death", ondeath)
  	inst:ListenForEvent("ms_respawnedfromghost", onbecamehuman)

	CustomRecipe()

    if IsDLCInstalled(REIGN_OF_GIANTS) and not IsDLCInstalled(CAPY_DLC) then
    if inst.components.moisture then
        inst:AddTag("DLC")
        inst.DLC = true
    end end
    if IsDLCInstalled(REIGN_OF_GIANTS) and IsDLCInstalled(CAPY_DLC) then
    if inst.components.poisonable or SaveGameIndex:IsModeShipwrecked() then
        inst.DLC2 = true
        inst:AddTag("DLC2")
        inst.DLC = true
        inst:AddTag("DLC")
    elseif not inst.components.poisonable and not SaveGameIndex:IsModeShipwrecked() and inst.components.moisture then
        inst.DLC = true
        inst:AddTag("DLC")
    end end

    if not IsDLCInstalled(REIGN_OF_GIANTS) and IsDLCInstalled(CAPY_DLC) then
    if inst.components.poisonable or SaveGameIndex:IsModeShipwrecked() then
        inst.DLC2 = true
        inst:AddTag("DLC2")
        inst.DLC = true
        inst:AddTag("DLC")
    end end
end

return MakePlayerCharacter("civi", prefabs, assets, fn, start_inv)