local assets =
{
    Asset("ANIM", "anim/glowingbackpack.zip"),
    Asset("ANIM", "anim/swap_glowingbackpack.zip"),
}

local function onfuelupdate(inst)
    local owner = inst.components.inventoryitem.owner or nil

    -- 检查发光状态
    if not inst.components.fueled:IsEmpty() then
        -- 彩色宝石添加冰冻功能
        if TUNING.NM_GBACKPACK <= 1 then
            if inst.components.container:Has("blueamulet", 1) then
                inst:AddTag("fridge")
                inst:AddTag("nocool")
            else
                if inst:HasTag("fridge") then
                    inst:RemoveTag("fridge")
                end
                if inst:HasTag("nocool") then
                    inst:RemoveTag("nocool")
                end
            end
            if inst.components.container:Has("deerclops_eyeball",1) or inst.components.container:Has("shark_gills",1) then
                inst.components.waterproofer:SetEffectiveness(1)
            else
                inst.components.waterproofer:SetEffectiveness(0)
            end
            inst.components.equippable.insulated = false

        else
            inst:AddTag("fridge")
            inst.components.waterproofer:SetEffectiveness(1)
            inst.components.equippable.insulated = true
        end

        if owner ~= nil and not inst.components.container:IsOpen() and inst.components.fueled ~= nil then
        -- if inst.components.fueled ~= nil then

        -- 虎鲨 巨鹿 冰护符
            if TUNING.NM_GBACKPACK <= 1 then
                if inst.components.container:Has("blueamulet", 1) then
                    if inst.components.container:Has("deerclops_eyeball",1) or inst.components.container:Has("shark_gills",1) then
                        inst.components.fueled:StartConsuming()
                        inst.components.fueled.rate = (3/8)
                    else
                        inst.components.fueled:StartConsuming()
                        inst.components.fueled.rate = (1/4)
                    end
                else
                    if inst.components.container:Has("deerclops_eyeball",1) or inst.components.container:Has("shark_gills",1) then
                        inst.components.fueled:StartConsuming()
                        inst.components.fueled.rate = (1/4)
                    else
                        inst.components.fueled:StopConsuming()
                    end
                end
            end

            inst.Light:Enable(false)
        elseif inst.components.fueled ~= nil then
            inst.components.fueled:StartConsuming()
            -- 改变燃料倍率
            if TUNING.NM_GBACKPACK <= 1 then
                inst.components.fueled:StartConsuming()
                if inst.components.container:Has("blueamulet", 1) then
                    if inst.components.container:Has("deerclops_eyeball",1) or inst.components.container:Has("shark_gills",1) then
                        inst.components.fueled.rate = (1/2)
                    else
                        inst.components.fueled.rate = (3/8)
                    end
                else
                    if inst.components.container:Has("deerclops_eyeball",1) or inst.components.container:Has("shark_gills",1) then
                        inst.components.fueled.rate = (3/8)
                    else
                        inst.components.fueled.rate = (1/4)
                    end
                end
            end
            inst.Light:Enable(true)
        end
    elseif inst.components.fueled:IsEmpty() then
        inst.Light:Enable(false)
    end
end

local function onequip(inst, owner)
    --owner.AnimState:OverrideSymbol("swap_body", "swap_backpack", "backpack")
    owner.AnimState:OverrideSymbol("swap_body", "swap_glowingbackpack", "swap_body")
    owner.components.inventory:SetOverflow(inst)
    inst.components.container:Open(owner)
    onfuelupdate(inst)
end

local function onunequip(inst, owner)
    --owner.AnimState:ClearOverrideSymbol("backpack")
    owner.AnimState:ClearOverrideSymbol("swap_body")
    owner.components.inventory:SetOverflow(nil)
    inst.components.container:Close(owner)
    onfuelupdate(inst)
end


local function onopen(inst)
    inst.SoundEmitter:PlaySound("dontstarve/wilson/backpack_open", "open")
    onfuelupdate(inst)
end

local function onclose(inst)
    inst.SoundEmitter:PlaySound("dontstarve/wilson/backpack_close", "open")
    onfuelupdate(inst)
end


local slotpos = {}

for y = 0, 3 do
    table.insert(slotpos, Vector3(-162, -y*75 + 114 ,0))
    table.insert(slotpos, Vector3(-162 +75, -y*75 + 114 ,0))
end


local function fn(Sim)
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("glowingbackpack")
    inst.AnimState:SetBuild("glowingbackpack")
    inst.AnimState:PlayAnimation("anim")

    inst:AddTag("backpack")
    if TUNING.NM_GBACKPACK == 3 then
        inst:AddTag("fridge")
        inst:AddTag("icebox_valid")
    end

    local minimap = inst.entity:AddMiniMapEntity()
    minimap:SetIcon("glowingbackpack.tex")

    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.cangoincontainer = false
    inst.components.inventoryitem.foleysound = "dontstarve/movement/foley/backpack"
    inst.components.inventoryitem.imagename = "glowingbackpack"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/glowingbackpack.xml"

    if SaveGameIndex:IsModeShipwrecked() or inst.components.poisonable then
        MakeInventoryFloatable(inst, "idle_water", "anim")
    end
    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.BACK or EQUIPSLOTS.BODY
    -- inst.components.equippable.equipslot = EQUIPSLOTS.BODY

    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
    -- inst.components.equippable.walkspeedmult = TUNING.PIGGYBACK_SPEED_MULT
    inst.components.equippable.insulated = true

    inst:AddComponent("waterproofer")
    -- if TUNING.NM_GBACKPACK >= 2 then
    --     inst.components.waterproofer.effectiveness = 1
    -- else
    --     inst.components.waterproofer.effectiveness = 0
    -- end
    if TUNING.NM_GBACKPACK == 2 then
        if SaveGameIndex:IsModeShipwrecked() or inst.components.poisonable then
            inst.components.equippable.poisonblocker = true
        end
    end

    inst:AddComponent("fueled")
    inst.components.fueled.maxfuel = TUNING.NIGHTLIGHT_FUEL_MAX
    inst.components.fueled.accepting = true
    inst.components.fueled.rate = (1/4)
    inst.components.fueled.fueltype = "NIGHTMARE"
    inst.components.fueled.ontakefuelfn = function() inst.SoundEmitter:PlaySound("dontstarve/common/nightmareAddFuel") onfuelupdate(inst) end
    inst.components.fueled:SetDepletedFn(function() inst.Light:Enable(false) end)
    inst.components.fueled:SetUpdateFn(onfuelupdate)
    inst.components.fueled:InitializeFuelLevel(TUNING.NIGHTLIGHT_FUEL_MAX)
    inst.components.fueled:StartConsuming()

    inst:AddComponent("container")
    inst.components.container:SetNumSlots(#slotpos)
    inst.components.container.widgetslotpos = slotpos
    inst.components.container.widgetanimbank = "ui_backpack_2x4"
    inst.components.container.widgetanimbuild = "ui_backpack_2x4"
    inst.components.container.widgetpos = Vector3(-5,-50,0)
    inst.components.container.side_widget = true
    inst.components.container.type = "pack"

    inst.components.container.onopenfn = onopen
    inst.components.container.onclosefn = onclose

    inst.entity:AddLight()
    inst.Light:Enable(true)
    inst.Light:SetIntensity(.6)
    inst.Light:SetColour(197/255,197/255,150/255)
    inst.Light:SetFalloff( 0.75 )
    inst.Light:SetRadius( 3 )

    return inst
end

if TUNING.LANGA == 0 then
    STRINGS.NAMES.GLOWINGBACKPACK = "影背包"
    STRINGS.RECIPE_DESC.GLOWINGBACKPACK = "驱散黑暗"
    STRINGS.CHARACTERS.GENERIC.DESCRIBE.GLOWINGBACKPACK = "好像需要发光的东西"
else
    STRINGS.NAMES.GLOWINGBACKPACK = "Night Backpack"
    STRINGS.RECIPE_DESC.GLOWINGBACKPACK = "Dark away."
    STRINGS.CHARACTERS.GENERIC.DESCRIBE.GLOWINGBACKPACK = "It seems to need some glowing materials."
end

return Prefab( "common/inventory/glowingbackpack", fn, assets)
