local assets=
{
    Asset("ANIM", "anim/night_battleproof.zip"),

    Asset("ATLAS", "images/inventoryimages/night_battleproof.xml"),
    Asset("IMAGE", "images/inventoryimages/night_battleproof.tex"),
}

local prefabs =
{
}


local function fn(sim)
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    -- inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)
    if SaveGameIndex:IsModeShipwrecked() or inst.components.poisonable then
        MakeInventoryFloatable(inst, "idle_water", "idle")
        MakeBlowInHurricane(inst, TUNING.WINDBLOWN_SCALE_MIN.MEDIUM, TUNING.WINDBLOWN_SCALE_MAX.MEDIUM)

    end




    inst.AnimState:SetBank("night_battleproof")
    inst.AnimState:SetBuild("night_battleproof")
    inst.AnimState:PlayAnimation("idle")

	-- if not TheWorld.ismastersim then
 --        return inst
 --    end

    -- inst.entity:SetPristine()


    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "night_battleproof"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/night_battleproof.xml"

	-- inst.entity:SetPristine()

	inst:AddComponent("stackable")
	inst.components.stackable.maxsize = 20

	inst:AddComponent("inspectable")

	inst:AddComponent("tradable")
    inst.components.tradable.goldvalue = 20
    if SaveGameIndex:IsModeShipwrecked() then
        inst.components.tradable.dubloonvalue = 20
    end

    inst:AddTag("trinket")


    return inst
end
if TUNING.LANGA == 0 then
	STRINGS.NAMES.NIGHT_BATTLEPROOF = "影之勋章"
	STRINGS.RECIPE_DESC.NIGHT_BATTLEPROOF = "这是和怪物战斗的证明"
	STRINGS.CHARACTERS.GENERIC.DESCRIBE.NIGHT_BATTLEPROOF = "似乎可以兑换很多金子"
else
	STRINGS.NAMES.NIGHT_BATTLEPROOF = "Night Medal"
	STRINGS.RECIPE_DESC.NIGHT_BATTLEPROOF = "Something that can proof your braveness."
	STRINGS.CHARACTERS.GENERIC.DESCRIBE.NIGHT_BATTLEPROOF = "It's valueable!"
end


return Prefab("common/inventory/night_battleproof", fn, assets, prefabs)