local assets =
{
    Asset("ANIM", "anim/nightmare_axe_pickaxe.zip"),
    Asset("ANIM", "anim/swap_nightmare_axe_pickaxe.zip"),
}
--------------
local MAXUSES = 200
local SANPUNISH = 1
--------------
local function onequip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_object", "swap_nightmare_axe_pickaxe", "swap_object")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")
end

local function onunequip(inst, owner)
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
end
local function FackTool(inst)
    if inst.components.tool ~= nil then
        inst:RemoveComponent("tool")
        inst:RemoveComponent("weapon")
    end
    local owner = inst.components.inventoryitem.owner or nil
    if owner ~= nil then
        if TUNING.LANGA == 0 then
            owner.components.talker:Say("用这种东西我无法下手")
        else
            owner.components.talker:Say("I can't use it")
        end
    end
end
local function onUseChange( inst, data )
    local owner = inst.components.inventoryitem.owner or nil
    if owner ~= nil and owner.components.sanity ~= nil then
        inst.components.inventoryitem.owner.components.sanity:DoDelta(-1 * SANPUNISH)
    end
    if data.percent > 0 then
        if inst.components.tool == nil then
            inst:AddComponent("tool")
            inst.components.tool:SetAction(ACTIONS.CHOP, 2.5)
            inst.components.tool:SetAction(ACTIONS.MINE, 2)
            if SaveGameIndex:IsModeShipwrecked() then
                inst.components.tool:SetAction(ACTIONS.HACK, 2)
            end
            inst:AddComponent("weapon")
            inst.components.weapon:SetDamage(TUNING.MULTITOOL_DAMAGE)
        end
    else
        FackTool(inst)
    end
    if data.percent > 1 then
        inst.components.finiteuses:SetUses(MAXUSES)
    end
end


local function ShouldAcceptItem( inst, item)
    local owner = item.components.inventoryitem:GetGrandOwner()
    if item.prefab == "nightmarefuel"  then
        if inst.components.finiteuses:GetPercent() < 1 then
            return true
        else
            if TUNING.LANGA == 0 then
                owner.components.talker:Say("这把斧镐已经修好了！")
            else
                owner.components.talker:Say("It has been repaired.")
            end
        end
    else
        if TUNING.LANGA == 0 then
            owner.components.talker:Say("这玩意儿不能拿来修斧镐！")
        else
            owner.components.talker:Say("Can't repair with this.")
        end
    end
   return false
end
local function OnGetItemFromPlayer( inst, giver, item )
    inst.components.finiteuses:Use(-1 * math.min(80, MAXUSES - inst.components.finiteuses:GetUses()))
    -- giver.components.sanity:DoDelta(0)
    inst.SoundEmitter:PlaySound("dontstarve/common/nightmareAddFuel")
end
local function fn(sim)
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    -- inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("nightmare_axe_pickaxe")
    inst.AnimState:SetBuild("nightmare_axe_pickaxe")
    inst.AnimState:PlayAnimation("idle")
    if SaveGameIndex:IsModeShipwrecked() or inst.components.poisonable then
        MakeInventoryFloatable(inst, "idle_water", "idle")
    end
    inst:AddTag("sharp")

    -- inst.entity:SetPristine()

    -- if not TheWorld.ismastersim then
    --     return inst
    -- end

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(TUNING.MULTITOOL_DAMAGE)
    -----
    inst:AddComponent("tool")
    inst.components.tool:SetAction(ACTIONS.CHOP, 2.5)
    inst.components.tool:SetAction(ACTIONS.MINE, 2)
    if SaveGameIndex:IsModeShipwrecked() then
        inst.components.tool:SetAction(ACTIONS.HACK, 2)
    end
    -------
    inst:AddComponent("finiteuses")

    inst.components.finiteuses:SetMaxUses(MAXUSES)
    inst.components.finiteuses:SetUses(MAXUSES)

    inst.components.finiteuses:SetConsumption(ACTIONS.CHOP, 1)
    inst.components.finiteuses:SetConsumption(ACTIONS.MINE, 1)
    if SaveGameIndex:IsModeShipwrecked() then
        inst.components.finiteuses:SetConsumption(ACTIONS.HACK, 1)
    end
    -------
    inst:AddComponent("trader")
    inst.components.trader.acceptnontradable = true
    inst.components.trader.onaccept = OnGetItemFromPlayer
    inst.components.trader:SetAcceptTest(ShouldAcceptItem)
    -------
    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "nightmare_axe_pickaxe"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/nightmare_axe_pickaxe.xml"
    inst:AddComponent("equippable")

    inst.components.equippable:SetOnEquip(onequip)

    inst.components.equippable:SetOnUnequip(onunequip)

    inst:ListenForEvent("percentusedchange", onUseChange)

    -- MakeHauntableLaunch(inst)

    return inst
end

if TUNING.LANGA == 0 then
    STRINGS.NAMES.NIGHTMARE_AXE_PICKAXE = "影之斧镐"
    STRINGS.RECIPE_DESC.NIGHTMARE_AXE_PICKAXE = "在黑暗中徘徊的斧镐"
    STRINGS.CHARACTERS.GENERIC.DESCRIBE.NIGHTMARE_AXE_PICKAXE = "它会比普通的工具更♂快吗？"
else
    STRINGS.NAMES.NIGHTMARE_AXE_PICKAXE = "Night Axe Pickaxe"
    STRINGS.RECIPE_DESC.NIGHTMARE_AXE_PICKAXE = "Fell the power of Nightmare"
    STRINGS.CHARACTERS.GENERIC.DESCRIBE.NIGHTMARE_AXE_PICKAXE = "Will it be faster than normal tools?"
end




return Prefab("common/inventory/nightmare_axe_pickaxe", fn, assets)