-- TUNING.LANGA = GetModConfigData("LANG")

local assets=
{
    Asset("ANIM", "anim/nightmare_gems.zip"),
    Asset("ATLAS", "images/inventoryimages/nightmare_darkgem.xml"),
    Asset("IMAGE", "images/inventoryimages/nightmare_darkgem.tex"),
}

local prefabs ={}

local function oneaten(inst, eater)

	if not eater:HasTag("nightmaregem") then
			return
	end
    if eater and eater.prefab == "civi" then
        if TUNING.LANGA == 0 then
            if eater.level < 2 then
            eater.components.talker:Say("我感受到了黑暗", 3)
      else
            eater.components.talker:Say("我已经深陷黑暗中", 3)
      end
        else
            if eater.level < 2 then
            eater.components.talker:Say("I felt the dark.", 3)
      else
            eater.components.talker:Say("I've already in the dark", 3)
      end
        end
    end
    -- if eater.level >=2 then
    --     inst:RemoveComponent("edible")
    --     inst:AddTag("moved")
    -- end
end

local function CheckEdible(inst)
    inst:RemoveComponent("edible")
    inst:AddTag("moved")
    local owner = inst.components.inventoryitem.owner
    if owner.prefab == "civi" and owner.level < 2 then
        if inst:HasTag("moved")then
            inst:AddComponent("edible")
            inst.components.edible.healthvalue = 0
            inst.components.edible.sanityvalue = 0
            inst.components.edible.hungervalue = 0
            inst.components.edible.foodtype = "GENERIC"
            inst.components.edible:SetOnEatenFn(oneaten)
            inst:RemoveTag("moved")
            else
                return
        end
    end
end

local function fn(sim)
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    -- inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("nightmare_gems")
    inst.AnimState:SetBuild("nightmare_gems")
    inst.AnimState:PlayAnimation("darkgem_idle")

    if SaveGameIndex:IsModeShipwrecked() or inst.components.poisonable then
        MakeInventoryFloatable(inst, "darkgem_idle_water", "darkgem_idle")
    end


	-- if not TheWorld.ismastersim then
 --        return inst
 --    end

    -- inst.entity:SetPristine()
    inst:AddComponent("edible")
    inst.components.edible.healthvalue = 0
    inst.components.edible.sanityvalue = 0
    inst.components.edible.hungervalue = 0
    inst.components.edible.foodtype = "NMDARKGEM"
	inst.components.edible:SetOnEatenFn(oneaten)

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "nightmare_darkgem"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/nightmare_darkgem.xml"
    -- inst.components.inventoryitem:SetOnPutInInventoryFn(CheckEdible)


	inst:AddComponent("stackable")
    inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM


    inst:AddComponent("tradable")


	inst:AddComponent("inspectable")

    return inst
end

if TUNING.LANGA == 0 then
    STRINGS.NAMES.NIGHTMARE_DARKGEM = "黑宝石"
    STRINGS.RECIPE_DESC.NIGHTMARE_DARKGEM = "升级！升级！"
    STRINGS.CHARACTERS.GENERIC.DESCRIBE.NIGHTMARE_DARKGEM = "使你更接近黑暗！"
else
    STRINGS.NAMES.NIGHTMARE_DARKGEM = "Dark Gem"
    STRINGS.RECIPE_DESC.NIGHTMARE_DARKGEM = "Upgrades!"
    STRINGS.CHARACTERS.GENERIC.DESCRIBE.NIGHTMARE_DARKGEM = "Get closer to dark!"
end

return Prefab("nightmare_darkgem", fn, assets, prefabs)