-- TUNING.LANGA = GetModConfigData("LANG")

local assets=
{
    Asset("ANIM", "anim/nightmare_gems.zip"),
    Asset("ATLAS", "images/inventoryimages/nightmare_lightgem.xml"),
    Asset("IMAGE", "images/inventoryimages/nightmare_lightgem.tex"),
}

local prefabs =
{
}

local function oneaten(inst, eater)

	if not eater:HasTag("nightmaregem") then
			return
	end

  if eater and eater.prefab == "civi" then
		if TUNING.LANGA == 0 then
			if eater.level > 0 then
            eater.components.talker:Say("我感受到了光明", 3)
      else
            eater.components.talker:Say("我已经沐浴在光明中", 3)
      end
		else
			if eater.level > 0 then
            eater.components.talker:Say("I felt the light.", 3)
      else
            eater.components.talker:Say("I've already in the light", 3)
      end
		end
	end
    -- if eater.level <=0 then
    --     inst:RemoveComponent("edible")
    --     inst:AddTag("moved")
    -- end
end

local function CheckEdible(inst)
    inst:RemoveComponent("edible")
    inst:AddTag("moved")
    local owner = inst.components.inventoryitem.owner
    if owner.prefab == "civi" and owner.level > 0 then
        if inst:HasTag("moved")then
            inst:AddComponent("edible")
            inst.components.edible.healthvalue = 0
            inst.components.edible.sanityvalue = 0
            inst.components.edible.hungervalue = 0
            inst.components.edible.foodtype = "GENERIC"
            inst.components.edible:SetOnEatenFn(oneaten)
            inst:RemoveTag("moved")
            else
                return
        end
    end
end

local function fn(sim)
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    -- inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("nightmare_gems")
    inst.AnimState:SetBuild("nightmare_gems")
    inst.AnimState:PlayAnimation("lightgem_idle")
    if SaveGameIndex:IsModeShipwrecked() or inst.components.poisonable then
        MakeInventoryFloatable(inst, "lightgem_idle_water", "lightgem_idle")
    end

	-- if not TheWorld.ismastersim then
 --        return inst
 --    end

    -- inst.entity:SetPristine()

	inst:AddComponent("edible")
	inst.components.edible.healthvalue = 0
	inst.components.edible.sanityvalue = 0
	inst.components.edible.hungervalue = 0
	inst.components.edible.foodtype = "NMLIGHTGEM"
	inst.components.edible:SetOnEatenFn(oneaten)

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "nightmare_lightgem"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/nightmare_lightgem.xml"
    -- inst.components.inventoryitem:SetOnPutInInventoryFn(CheckEdible)

	-- inst.entity:SetPristine()

	inst:AddComponent("stackable")
    inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

	inst:AddComponent("inspectable")

    inst:AddComponent("tradable")

  return inst
end



if TUNING.LANGA == 0 then
    STRINGS.NAMES.NIGHTMARE_LIGHTGEM = "白宝石"
    STRINGS.RECIPE_DESC.NIGHTMARE_LIGHTGEM = "降级！降级！"
    STRINGS.CHARACTERS.GENERIC.DESCRIBE.NIGHTMARE_LIGHTGEM = "使你更接近光明！"
else
    STRINGS.NAMES.NIGHTMARE_LIGHTGEM = "Light Gem"
    STRINGS.RECIPE_DESC.NIGHTMARE_LIGHTGEM = "Degrades!"
    STRINGS.CHARACTERS.GENERIC.DESCRIBE.NIGHTMARE_LIGHTGEM = "Get closer to light!"
end


return Prefab("nightmare_lightgem", fn, assets, prefabs)